/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.saml;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.datatype.XMLGregorianCalendar;
import org.keycloak.protocol.saml.SAML2BindingBuilder;
import org.picketlink.common.PicketLinkLogger;
import org.picketlink.common.PicketLinkLoggerFactory;
import org.picketlink.common.constants.JBossSAMLURIConstants;
import org.picketlink.common.exceptions.ConfigurationException;
import org.picketlink.common.exceptions.ProcessingException;
import org.picketlink.common.util.DocumentUtil;
import org.picketlink.common.util.StringUtil;
import org.picketlink.identity.federation.api.saml.v2.response.SAML2Response;
import org.picketlink.identity.federation.core.saml.v2.common.IDGenerator;
import org.picketlink.identity.federation.core.saml.v2.holders.IDPInfoHolder;
import org.picketlink.identity.federation.core.saml.v2.holders.IssuerInfoHolder;
import org.picketlink.identity.federation.core.saml.v2.holders.SPInfoHolder;
import org.picketlink.identity.federation.core.saml.v2.util.StatementUtil;
import org.picketlink.identity.federation.core.saml.v2.util.XMLTimeUtil;
import org.picketlink.identity.federation.saml.v2.assertion.AssertionType;
import org.picketlink.identity.federation.saml.v2.assertion.AttributeStatementType;
import org.picketlink.identity.federation.saml.v2.assertion.AuthnStatementType;
import org.picketlink.identity.federation.saml.v2.assertion.StatementAbstractType;
import org.picketlink.identity.federation.saml.v2.protocol.ResponseType;
import org.picketlink.identity.federation.saml.v2.protocol.StatusResponseType;
import org.w3c.dom.Document;

public class SALM2LoginResponseBuilder
extends SAML2BindingBuilder<SALM2LoginResponseBuilder> {
    protected static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();
    protected List<String> roles = new LinkedList<String>();
    protected String nameId;
    protected String nameIdFormat;
    protected boolean multiValuedRoles;
    protected boolean disableAuthnStatement;
    protected String requestID;
    protected String authMethod;
    protected String requestIssuer;
    protected Map<String, Object> attributes = new HashMap<String, Object>();

    public SALM2LoginResponseBuilder attributes(Map<String, Object> attributes) {
        this.attributes = attributes;
        return this;
    }

    public SALM2LoginResponseBuilder attribute(String name, Object value) {
        if (value == null) {
            this.attributes.remove(name);
        } else {
            this.attributes.put(name, value);
        }
        return this;
    }

    public SALM2LoginResponseBuilder requestID(String requestID) {
        this.requestID = requestID;
        return this;
    }

    public SALM2LoginResponseBuilder requestIssuer(String requestIssuer) {
        this.requestIssuer = requestIssuer;
        return this;
    }

    public SALM2LoginResponseBuilder roles(List<String> roles) {
        this.roles = roles;
        return this;
    }

    public SALM2LoginResponseBuilder roles(String ... roles) {
        for (String role : roles) {
            this.roles.add(role);
        }
        return this;
    }

    public SALM2LoginResponseBuilder authMethod(String authMethod) {
        this.authMethod = authMethod;
        return this;
    }

    public SALM2LoginResponseBuilder nameIdentifier(String nameIdFormat, String nameId) {
        this.nameIdFormat = nameIdFormat;
        this.nameId = nameId;
        return this;
    }

    public SALM2LoginResponseBuilder multiValuedRoles(boolean multiValuedRoles) {
        this.multiValuedRoles = multiValuedRoles;
        return this;
    }

    public SALM2LoginResponseBuilder disableAuthnStatement(boolean disableAuthnStatement) {
        this.disableAuthnStatement = disableAuthnStatement;
        return this;
    }

    public SAML2BindingBuilder.RedirectBindingBuilder redirectBinding() throws ConfigurationException, ProcessingException {
        Document samlResponseDocument = this.buildDocument();
        return new SAML2BindingBuilder.RedirectBindingBuilder(this, samlResponseDocument);
    }

    public SAML2BindingBuilder.PostBindingBuilder postBinding() throws ConfigurationException, ProcessingException {
        Document samlResponseDocument = this.buildDocument();
        return new SAML2BindingBuilder.PostBindingBuilder(this, samlResponseDocument);
    }

    public Document buildDocument() throws ConfigurationException, ProcessingException {
        Document samlResponseDocument = null;
        ResponseType responseType = null;
        SAML2Response saml2Response = new SAML2Response();
        String id = IDGenerator.create((String)"ID_");
        IssuerInfoHolder issuerHolder = new IssuerInfoHolder(this.responseIssuer);
        issuerHolder.setStatusCode(JBossSAMLURIConstants.STATUS_SUCCESS.get());
        IDPInfoHolder idp = new IDPInfoHolder();
        idp.setNameIDFormatValue(this.nameId);
        idp.setNameIDFormat(this.nameIdFormat);
        SPInfoHolder sp = new SPInfoHolder();
        sp.setResponseDestinationURI(this.destination);
        sp.setRequestID(this.requestID);
        sp.setIssuer(this.requestIssuer);
        responseType = saml2Response.createResponseType(id, sp, idp, issuerHolder);
        AssertionType assertion = ((ResponseType.RTChoiceType)responseType.getAssertions().get(0)).getAssertion();
        if (!this.disableAuthnStatement) {
            String authContextRef = JBossSAMLURIConstants.AC_UNSPECIFIED.get();
            if (StringUtil.isNotNull((String)this.authMethod)) {
                authContextRef = this.authMethod;
            }
            AuthnStatementType authnStatement = StatementUtil.createAuthnStatement((XMLGregorianCalendar)XMLTimeUtil.getIssueInstant(), (String)authContextRef);
            authnStatement.setSessionIndex(assertion.getID());
            assertion.addStatement((StatementAbstractType)authnStatement);
        }
        if (this.roles != null && !this.roles.isEmpty()) {
            AttributeStatementType attrStatement = StatementUtil.createAttributeStatementForRoles(this.roles, (boolean)this.multiValuedRoles);
            assertion.addStatement((StatementAbstractType)attrStatement);
        }
        if (this.attributes != null && this.attributes.size() > 0) {
            AttributeStatementType attStatement = StatementUtil.createAttributeStatement(this.attributes);
            assertion.addStatement((StatementAbstractType)attStatement);
        }
        try {
            samlResponseDocument = saml2Response.convert((StatusResponseType)responseType);
            if (logger.isTraceEnabled()) {
                logger.trace("SAML Response Document: " + DocumentUtil.asString((Document)samlResponseDocument));
            }
        }
        catch (Exception e) {
            throw logger.samlAssertionMarshallError((Throwable)e);
        }
        if (this.encrypt) {
            this.encryptDocument(samlResponseDocument);
        }
        return samlResponseDocument;
    }
}

