/*
 * Decompiled with CFR 0.152.
 */
package liquibase.diff.output.changelog;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.parsers.ParserConfigurationException;
import liquibase.change.Change;
import liquibase.changelog.ChangeSet;
import liquibase.configuration.GlobalConfiguration;
import liquibase.configuration.LiquibaseConfiguration;
import liquibase.database.Database;
import liquibase.database.ObjectQuotingStrategy;
import liquibase.diff.DiffResult;
import liquibase.diff.ObjectDifferences;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.changelog.ChangeGenerator;
import liquibase.diff.output.changelog.ChangeGeneratorFactory;
import liquibase.diff.output.changelog.ChangedObjectChangeGenerator;
import liquibase.diff.output.changelog.MissingObjectChangeGenerator;
import liquibase.diff.output.changelog.UnexpectedObjectChangeGenerator;
import liquibase.exception.DatabaseException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.logging.LogFactory;
import liquibase.serializer.ChangeLogSerializer;
import liquibase.serializer.ChangeLogSerializerFactory;
import liquibase.serializer.core.xml.XMLChangeLogSerializer;
import liquibase.structure.DatabaseObject;
import liquibase.structure.DatabaseObjectComparator;
import liquibase.util.StringUtils;

public class DiffToChangeLog {
    private String idRoot = String.valueOf(new Date().getTime());
    private int changeNumber = 1;
    private String changeSetContext;
    private String changeSetAuthor;
    private String changeSetPath;
    private DiffResult diffResult;
    private DiffOutputControl diffOutputControl;
    private static Set<Class> loggedOrderFor = new HashSet<Class>();

    public DiffToChangeLog(DiffResult diffResult, DiffOutputControl diffOutputControl) {
        this.diffResult = diffResult;
        this.diffOutputControl = diffOutputControl;
    }

    public DiffToChangeLog(DiffOutputControl diffOutputControl) {
        this.diffOutputControl = diffOutputControl;
    }

    public void setDiffResult(DiffResult diffResult) {
        this.diffResult = diffResult;
    }

    public void setChangeSetContext(String changeSetContext) {
        this.changeSetContext = changeSetContext;
    }

    public void print(String changeLogFile) throws ParserConfigurationException, IOException, DatabaseException {
        ChangeLogSerializer changeLogSerializer = ChangeLogSerializerFactory.getInstance().getSerializer(changeLogFile);
        this.print(changeLogFile, changeLogSerializer);
    }

    public void print(PrintStream out) throws ParserConfigurationException, IOException, DatabaseException {
        this.print(out, (ChangeLogSerializer)new XMLChangeLogSerializer());
    }

    public void print(String changeLogFile, ChangeLogSerializer changeLogSerializer) throws ParserConfigurationException, IOException, DatabaseException {
        File file = new File(changeLogFile);
        if (!file.exists()) {
            LogFactory.getLogger().info(file + " does not exist, creating");
            FileOutputStream stream = new FileOutputStream(file);
            this.print(new PrintStream(stream), changeLogSerializer);
            stream.close();
        } else {
            String line;
            LogFactory.getLogger().info(file + " exists, appending");
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            this.print(new PrintStream(out), changeLogSerializer);
            String xml = new String(out.toByteArray());
            xml = xml.replaceFirst("(?ms).*<databaseChangeLog[^>]*>", "");
            xml = xml.replaceFirst("</databaseChangeLog>", "");
            xml = xml.trim();
            if ("".equals(xml)) {
                LogFactory.getLogger().info("No changes found, nothing to do");
                return;
            }
            String lineSeparator = LiquibaseConfiguration.getInstance().getConfiguration(GlobalConfiguration.class).getOutputLineSeparator();
            BufferedReader fileReader = new BufferedReader(new FileReader(file));
            long offset = 0L;
            while ((line = fileReader.readLine()) != null) {
                int index = line.indexOf("</databaseChangeLog>");
                if (index >= 0) {
                    offset += (long)index;
                    continue;
                }
                offset += (long)line.getBytes().length;
                offset += (long)lineSeparator.getBytes().length;
            }
            fileReader.close();
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
            randomAccessFile.seek(offset);
            randomAccessFile.writeBytes("    ");
            randomAccessFile.write(xml.getBytes());
            randomAccessFile.writeBytes(lineSeparator);
            randomAccessFile.writeBytes("</databaseChangeLog>" + lineSeparator);
            randomAccessFile.close();
        }
    }

    public void print(PrintStream out, ChangeLogSerializer changeLogSerializer) throws ParserConfigurationException, IOException, DatabaseException {
        List<ChangeSet> changeSets = this.generateChangeSets();
        changeLogSerializer.write(changeSets, out);
        out.flush();
    }

    public List<ChangeSet> generateChangeSets() {
        Change[] changes;
        ObjectQuotingStrategy quotingStrategy;
        ChangeGeneratorFactory changeGeneratorFactory = ChangeGeneratorFactory.getInstance();
        DatabaseObjectComparator comparator = new DatabaseObjectComparator();
        ArrayList<ChangeSet> changeSets = new ArrayList<ChangeSet>();
        List<Class<? extends DatabaseObject>> types = this.getOrderedOutputTypes(MissingObjectChangeGenerator.class);
        for (Class<? extends DatabaseObject> type : types) {
            quotingStrategy = ObjectQuotingStrategy.QUOTE_ALL_OBJECTS;
            for (DatabaseObject databaseObject : this.diffResult.getMissingObjects(type, comparator)) {
                if (databaseObject == null || this.diffResult.getReferenceSnapshot().getDatabase().isLiquibaseObject(databaseObject) || this.diffResult.getReferenceSnapshot().getDatabase().isSystemObject(databaseObject)) continue;
                changes = changeGeneratorFactory.fixMissing(databaseObject, this.diffOutputControl, this.diffResult.getReferenceSnapshot().getDatabase(), this.diffResult.getComparisonSnapshot().getDatabase());
                this.addToChangeSets(changes, changeSets, quotingStrategy);
            }
        }
        types = this.getOrderedOutputTypes(UnexpectedObjectChangeGenerator.class);
        for (Class<? extends DatabaseObject> type : types) {
            quotingStrategy = ObjectQuotingStrategy.QUOTE_ALL_OBJECTS;
            for (DatabaseObject databaseObject : this.diffResult.getUnexpectedObjects(type, comparator)) {
                if (this.diffResult.getComparisonSnapshot().getDatabase().isLiquibaseObject(databaseObject) || this.diffResult.getComparisonSnapshot().getDatabase().isSystemObject(databaseObject)) continue;
                changes = changeGeneratorFactory.fixUnexpected(databaseObject, this.diffOutputControl, this.diffResult.getReferenceSnapshot().getDatabase(), this.diffResult.getComparisonSnapshot().getDatabase());
                this.addToChangeSets(changes, changeSets, quotingStrategy);
            }
        }
        types = this.getOrderedOutputTypes(ChangedObjectChangeGenerator.class);
        for (Class<? extends DatabaseObject> type : types) {
            quotingStrategy = ObjectQuotingStrategy.QUOTE_ALL_OBJECTS;
            for (Map.Entry entry : this.diffResult.getChangedObjects(type, comparator).entrySet()) {
                if (this.diffResult.getReferenceSnapshot().getDatabase().isLiquibaseObject((DatabaseObject)entry.getKey()) || this.diffResult.getReferenceSnapshot().getDatabase().isSystemObject((DatabaseObject)entry.getKey())) continue;
                changes = changeGeneratorFactory.fixChanged((DatabaseObject)entry.getKey(), (ObjectDifferences)entry.getValue(), this.diffOutputControl, this.diffResult.getReferenceSnapshot().getDatabase(), this.diffResult.getComparisonSnapshot().getDatabase());
                this.addToChangeSets(changes, changeSets, quotingStrategy);
            }
        }
        return changeSets;
    }

    protected List<Class<? extends DatabaseObject>> getOrderedOutputTypes(Class<? extends ChangeGenerator> generatorType) {
        Database comparisonDatabase = this.diffResult.getComparisonSnapshot().getDatabase();
        DependencyGraph graph = new DependencyGraph();
        for (Class<? extends DatabaseObject> type : this.diffResult.getReferenceSnapshot().getSnapshotControl().getTypesToInclude()) {
            graph.addType(type);
        }
        List<Class<? extends DatabaseObject>> types = graph.sort(comparisonDatabase, generatorType);
        if (!loggedOrderFor.contains(generatorType)) {
            String log = generatorType.getSimpleName() + " type order: ";
            for (Class<? extends DatabaseObject> type : types) {
                log = log + "    " + type.getName();
            }
            LogFactory.getLogger().debug(log);
            loggedOrderFor.add(generatorType);
        }
        return types;
    }

    private void addToChangeSets(Change[] changes, List<ChangeSet> changeSets, ObjectQuotingStrategy quotingStrategy) {
        if (changes != null) {
            ChangeSet changeSet = new ChangeSet(this.generateId(), this.getChangeSetAuthor(), false, false, null, this.changeSetContext, null, quotingStrategy, null);
            for (Change change : changes) {
                changeSet.addChange(change);
            }
            changeSets.add(changeSet);
        }
    }

    protected String getChangeSetAuthor() {
        if (this.changeSetAuthor != null) {
            return this.changeSetAuthor;
        }
        String author = System.getProperty("user.name");
        if (StringUtils.trimToNull(author) == null) {
            return "diff-generated";
        }
        return author + " (generated)";
    }

    public void setChangeSetAuthor(String changeSetAuthor) {
        this.changeSetAuthor = changeSetAuthor;
    }

    public String getChangeSetPath() {
        return this.changeSetPath;
    }

    public void setChangeSetPath(String changeSetPath) {
        this.changeSetPath = changeSetPath;
    }

    public void setIdRoot(String idRoot) {
        this.idRoot = idRoot;
    }

    protected String generateId() {
        return this.idRoot + "-" + this.changeNumber++;
    }

    private static class DependencyGraph {
        private Map<Class<? extends DatabaseObject>, Node> allNodes = new HashMap<Class<? extends DatabaseObject>, Node>();

        private DependencyGraph() {
        }

        private void addType(Class<? extends DatabaseObject> type) {
            this.allNodes.put(type, new Node(type));
        }

        public List<Class<? extends DatabaseObject>> sort(Database database, Class<? extends ChangeGenerator> generatorType) {
            ChangeGeneratorFactory changeGeneratorFactory = ChangeGeneratorFactory.getInstance();
            for (Class<? extends DatabaseObject> type : this.allNodes.keySet()) {
                for (Class<? extends DatabaseObject> clazz : changeGeneratorFactory.runBeforeTypes(type, database, generatorType)) {
                    this.getNode(type).addEdge(this.getNode(clazz));
                }
                for (Class clazz : changeGeneratorFactory.runAfterTypes(type, database, generatorType)) {
                    this.getNode(clazz).addEdge(this.getNode(type));
                }
            }
            ArrayList<Node> returnNodes = new ArrayList<Node>();
            TreeSet<Node> nodesWithNoIncomingEdges = new TreeSet<Node>(new Comparator<Node>(){

                @Override
                public int compare(Node o1, Node o2) {
                    return o1.type.getName().compareTo(o2.type.getName());
                }
            });
            for (Node node : this.allNodes.values()) {
                if (node.inEdges.size() != 0) continue;
                nodesWithNoIncomingEdges.add(node);
            }
            while (!nodesWithNoIncomingEdges.isEmpty()) {
                Node node = (Node)nodesWithNoIncomingEdges.iterator().next();
                nodesWithNoIncomingEdges.remove(node);
                returnNodes.add(node);
                Iterator<Edge> iterator = node.outEdges.iterator();
                while (iterator.hasNext()) {
                    Edge edge = iterator.next();
                    Node nodePointedTo = edge.to;
                    iterator.remove();
                    nodePointedTo.inEdges.remove(edge);
                    if (!nodePointedTo.inEdges.isEmpty()) continue;
                    nodesWithNoIncomingEdges.add(nodePointedTo);
                }
            }
            for (Node node : this.allNodes.values()) {
                if (node.inEdges.isEmpty()) continue;
                String message = "Could not resolve " + generatorType.getSimpleName() + " dependencies due to dependency cycle. Dependencies: \n";
                for (Node node2 : this.allNodes.values()) {
                    TreeSet<String> fromTypes = new TreeSet<String>();
                    TreeSet<String> toTypes = new TreeSet<String>();
                    for (Edge edge : node2.inEdges) {
                        fromTypes.add(edge.from.type.getSimpleName());
                    }
                    for (Edge edge : node2.outEdges) {
                        toTypes.add(edge.to.type.getSimpleName());
                    }
                    String from = StringUtils.join(fromTypes, ",");
                    String to = StringUtils.join(toTypes, ",");
                    message = message + "    [" + from + "] -> " + node2.type.getSimpleName() + " -> [" + to + "]\n";
                }
                throw new UnexpectedLiquibaseException(message);
            }
            ArrayList<Class<? extends DatabaseObject>> returnList = new ArrayList<Class<? extends DatabaseObject>>();
            for (Node node : returnNodes) {
                returnList.add(node.type);
            }
            return returnList;
        }

        private Node getNode(Class<? extends DatabaseObject> type) {
            Node node = this.allNodes.get(type);
            if (node == null) {
                node = new Node(type);
            }
            return node;
        }

        static class Edge {
            public final Node from;
            public final Node to;

            public Edge(Node from, Node to) {
                this.from = from;
                this.to = to;
            }

            public boolean equals(Object obj) {
                if (!(obj instanceof Edge)) {
                    return false;
                }
                if (obj == null) {
                    return false;
                }
                Edge e = (Edge)obj;
                return e.from == this.from && e.to == this.to;
            }

            public int hashCode() {
                return (this.from.toString() + "." + this.to.toString()).hashCode();
            }
        }

        static class Node {
            public final Class<? extends DatabaseObject> type;
            public final HashSet<Edge> inEdges;
            public final HashSet<Edge> outEdges;

            public Node(Class<? extends DatabaseObject> type) {
                this.type = type;
                this.inEdges = new HashSet();
                this.outEdges = new HashSet();
            }

            public Node addEdge(Node node) {
                Edge e = new Edge(this, node);
                this.outEdges.add(e);
                node.inEdges.add(e);
                return this;
            }

            public String toString() {
                return this.type.getName();
            }
        }
    }
}

