/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.managers;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.jboss.logging.Logger;
import org.keycloak.ClientConnection;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UsernameLoginFailureModel;

public class BruteForceProtector
implements Runnable {
    protected static Logger logger = Logger.getLogger(BruteForceProtector.class);
    protected volatile boolean run = true;
    protected int maxDeltaTimeSeconds = 43200;
    protected KeycloakSessionFactory factory;
    protected CountDownLatch shutdownLatch = new CountDownLatch(1);
    protected volatile long failures;
    protected volatile long lastFailure;
    protected volatile long totalTime;
    protected LinkedBlockingQueue<LoginEvent> queue = new LinkedBlockingQueue();
    public static final int TRANSACTION_SIZE = 20;

    public BruteForceProtector(KeycloakSessionFactory factory) {
        this.factory = factory;
    }

    public void failure(KeycloakSession session, LoginEvent event) {
        logger.debug((Object)"failure");
        RealmModel realm = this.getRealmModel(session, event);
        this.logFailure(event);
        UsernameLoginFailureModel user = this.getUserModel(session, event);
        if (user == null) {
            user = session.sessions().addUserLoginFailure(realm, event.username);
        }
        user.setLastIPFailure(event.ip);
        long currentTime = System.currentTimeMillis();
        long last = user.getLastFailure();
        long deltaTime = 0L;
        if (last > 0L) {
            deltaTime = currentTime - last;
        }
        user.setLastFailure(currentTime);
        if (deltaTime > 0L && deltaTime > (long)realm.getMaxDeltaTimeSeconds() * 1000L) {
            user.clearFailures();
        }
        user.incrementFailures();
        logger.debugv("new num failures: {0}", (Object)user.getNumFailures());
        int waitSeconds = realm.getWaitIncrementSeconds() * (user.getNumFailures() / realm.getFailureFactor());
        logger.debugv("waitSeconds: {0}", (Object)waitSeconds);
        logger.debugv("deltaTime: {0}", (Object)deltaTime);
        if (waitSeconds == 0 && last > 0L && deltaTime < realm.getQuickLoginCheckMilliSeconds()) {
            logger.debugv("quick login, set min wait seconds", new Object[0]);
            waitSeconds = realm.getMinimumQuickLoginWaitSeconds();
        }
        if (waitSeconds > 0) {
            waitSeconds = Math.min(realm.getMaxFailureWaitSeconds(), waitSeconds);
            int notBefore = (int)(currentTime / 1000L) + waitSeconds;
            logger.debugv("set notBefore: {0}", (Object)notBefore);
            user.setFailedLoginNotBefore(notBefore);
        }
    }

    protected UsernameLoginFailureModel getUserModel(KeycloakSession session, LoginEvent event) {
        RealmModel realm = this.getRealmModel(session, event);
        if (realm == null) {
            return null;
        }
        UsernameLoginFailureModel user = session.sessions().getUserLoginFailure(realm, event.username);
        if (user == null) {
            return null;
        }
        return user;
    }

    protected RealmModel getRealmModel(KeycloakSession session, LoginEvent event) {
        RealmModel realm = session.realms().getRealm(event.realmId);
        if (realm == null) {
            return null;
        }
        return realm;
    }

    public void start() {
        new Thread((Runnable)this, "Brute Force Protector").start();
    }

    public void shutdown() {
        this.run = false;
        try {
            this.queue.offer(new ShutdownEvent());
            this.shutdownLatch.await(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void logSuccess(LoginEvent event) {
        logger.warn((Object)("login success for user " + event.username + " from ip " + event.ip));
    }

    protected void logFailure(LoginEvent event) {
        logger.warn((Object)("login failure for user " + event.username + " from ip " + event.ip));
        ++this.failures;
        long delta = 0L;
        if (this.lastFailure > 0L) {
            delta = System.currentTimeMillis() - this.lastFailure;
            this.totalTime = delta > (long)this.maxDeltaTimeSeconds * 1000L ? 0L : (this.totalTime += delta);
        }
    }

    public void successfulLogin(RealmModel realm, String username, ClientConnection clientConnection) {
        logger.info((Object)("successful login user: " + username + " from ip " + clientConnection.getRemoteAddr()));
    }

    public void invalidUser(RealmModel realm, String username, ClientConnection clientConnection) {
        logger.warn((Object)("invalid user: " + username + " from ip " + clientConnection.getRemoteAddr()));
    }

    public void failedLogin(RealmModel realm, String username, ClientConnection clientConnection) {
        try {
            FailedLogin event = new FailedLogin(realm.getId(), username, clientConnection.getRemoteAddr());
            this.queue.offer(event);
            event.latch.await(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public boolean isTemporarilyDisabled(KeycloakSession session, RealmModel realm, String username) {
        UsernameLoginFailureModel failure = session.sessions().getUserLoginFailure(realm, username);
        if (failure == null) {
            return false;
        }
        int currTime = (int)(System.currentTimeMillis() / 1000L);
        if (currTime < failure.getFailedLoginNotBefore()) {
            logger.debugv("Current: {0} notBefore: {1}", (Object)currTime, (Object)failure.getFailedLoginNotBefore());
            return true;
        }
        return false;
    }

    public long getFailures() {
        return this.failures;
    }

    public long getLastFailure() {
        return this.lastFailure;
    }

    protected class FailedLogin
    extends LoginEvent {
        protected final CountDownLatch latch;

        public FailedLogin(String realmId, String username, String ip) {
            super(realmId, username, ip);
            this.latch = new CountDownLatch(1);
        }
    }

    protected class ShutdownEvent
    extends LoginEvent {
        public ShutdownEvent() {
            super(null, null, null);
        }
    }

    protected class SuccessfulLogin
    extends LoginEvent {
        public SuccessfulLogin(String realmId, String userId, String ip) {
            super(realmId, userId, ip);
        }
    }

    protected abstract class LoginEvent
    implements Comparable<LoginEvent> {
        protected final String realmId;
        protected final String username;
        protected final String ip;

        protected LoginEvent(String realmId, String username, String ip) {
            this.realmId = realmId;
            this.username = username;
            this.ip = ip;
        }

        @Override
        public int compareTo(LoginEvent o) {
            return this.username.compareTo(o.username);
        }
    }
}

