/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.validation;

import java.util.List;
import java.util.regex.Pattern;
import javax.ws.rs.core.MultivaluedMap;
import org.keycloak.models.PasswordPolicy;

public class Validation {
    private static final Pattern EMAIL_PATTERN = Pattern.compile("[a-zA-Z0-9!#$%&'*+/=?^_`{|}~.-]+@[a-zA-Z0-9-]+(\\.[a-zA-Z0-9-]+)*");

    public static String validateRegistrationForm(MultivaluedMap<String, String> formData, List<String> requiredCredentialTypes) {
        if (Validation.isEmpty((String)formData.getFirst((Object)"firstName"))) {
            return "missingFirstName";
        }
        if (Validation.isEmpty((String)formData.getFirst((Object)"lastName"))) {
            return "missingLastName";
        }
        if (Validation.isEmpty((String)formData.getFirst((Object)"email"))) {
            return "missingEmail";
        }
        if (!Validation.isEmailValid((String)formData.getFirst((Object)"email"))) {
            return "invalidEmail";
        }
        if (Validation.isEmpty((String)formData.getFirst((Object)"username"))) {
            return "missingUsername";
        }
        if (requiredCredentialTypes.contains("password")) {
            if (Validation.isEmpty((String)formData.getFirst((Object)"password"))) {
                return "missingPassword";
            }
            if (!((String)formData.getFirst((Object)"password")).equals(formData.getFirst((Object)"password-confirm"))) {
                return "invalidPasswordConfirm";
            }
        }
        return null;
    }

    public static String validatePassword(MultivaluedMap<String, String> formData, PasswordPolicy policy) {
        return policy.validate((String)formData.getFirst((Object)"password"));
    }

    public static String validateUpdateProfileForm(MultivaluedMap<String, String> formData) {
        if (Validation.isEmpty((String)formData.getFirst((Object)"firstName"))) {
            return "missingFirstName";
        }
        if (Validation.isEmpty((String)formData.getFirst((Object)"lastName"))) {
            return "missingLastName";
        }
        if (Validation.isEmpty((String)formData.getFirst((Object)"email"))) {
            return "missingEmail";
        }
        if (!Validation.isEmailValid((String)formData.getFirst((Object)"email"))) {
            return "invalidEmail";
        }
        return null;
    }

    public static boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }

    public static boolean isEmailValid(String email) {
        return EMAIL_PATTERN.matcher(email).matches();
    }
}

