/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.xacml.sunxacml.attr;

import java.net.URI;
import javax.security.auth.x500.X500Principal;
import org.jboss.security.xacml.sunxacml.attr.AttributeValue;
import org.w3c.dom.Node;

public class X500NameAttribute
extends AttributeValue {
    public static final String identifier = "urn:oasis:names:tc:xacml:1.0:data-type:x500Name";
    private X500Principal value;
    private static URI identifierURI = URI.create("urn:oasis:names:tc:xacml:1.0:data-type:x500Name");

    public X500NameAttribute(X500Principal value) {
        super(identifierURI);
        this.value = value;
    }

    public static X500NameAttribute getInstance(Node root) throws IllegalArgumentException {
        return X500NameAttribute.getInstance(root.getFirstChild().getNodeValue());
    }

    public static X500NameAttribute getInstance(String value) throws IllegalArgumentException {
        return new X500NameAttribute(new X500Principal(value));
    }

    public X500Principal getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (!(o instanceof X500NameAttribute)) {
            return false;
        }
        X500NameAttribute other = (X500NameAttribute)o;
        return this.value.equals(other.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String encode() {
        return this.value.getName();
    }
}

