/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.web.handlers.saml2;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.ParserConfigurationException;
import org.picketlink.common.constants.JBossSAMLURIConstants;
import org.picketlink.common.exceptions.ConfigurationException;
import org.picketlink.common.exceptions.ParsingException;
import org.picketlink.common.exceptions.ProcessingException;
import org.picketlink.common.util.StringUtil;
import org.picketlink.config.federation.SPType;
import org.picketlink.identity.federation.api.saml.v2.request.SAML2Request;
import org.picketlink.identity.federation.api.saml.v2.response.SAML2Response;
import org.picketlink.identity.federation.core.audit.PicketLinkAuditEvent;
import org.picketlink.identity.federation.core.audit.PicketLinkAuditEventType;
import org.picketlink.identity.federation.core.audit.PicketLinkAuditHelper;
import org.picketlink.identity.federation.core.saml.v2.common.IDGenerator;
import org.picketlink.identity.federation.core.saml.v2.common.SAMLProtocolContext;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2Handler;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2HandlerRequest;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2HandlerResponse;
import org.picketlink.identity.federation.core.saml.v2.util.DocumentUtil;
import org.picketlink.identity.federation.core.saml.v2.util.XMLTimeUtil;
import org.picketlink.identity.federation.core.sts.PicketLinkCoreSTS;
import org.picketlink.identity.federation.core.wstrust.plugins.saml.SAMLUtil;
import org.picketlink.identity.federation.saml.v2.SAML2Object;
import org.picketlink.identity.federation.saml.v2.assertion.AssertionType;
import org.picketlink.identity.federation.saml.v2.assertion.AuthnStatementType;
import org.picketlink.identity.federation.saml.v2.assertion.NameIDType;
import org.picketlink.identity.federation.saml.v2.assertion.StatementAbstractType;
import org.picketlink.identity.federation.saml.v2.protocol.LogoutRequestType;
import org.picketlink.identity.federation.saml.v2.protocol.ResponseType;
import org.picketlink.identity.federation.saml.v2.protocol.StatusCodeType;
import org.picketlink.identity.federation.saml.v2.protocol.StatusResponseType;
import org.picketlink.identity.federation.saml.v2.protocol.StatusType;
import org.picketlink.identity.federation.web.core.HTTPContext;
import org.picketlink.identity.federation.web.core.IdentityServer;
import org.picketlink.identity.federation.web.core.SessionManager;
import org.picketlink.identity.federation.web.handlers.saml2.BaseSAML2Handler;
import org.picketlink.identity.federation.web.util.PostBindingUtil;
import org.picketlink.identity.federation.web.util.RedirectBindingUtil;
import org.w3c.dom.Document;

public class SAML2LogOutHandler
extends BaseSAML2Handler {
    public static final String BACK_CHANNEL_LOGOUT = "BACK_CHANNEL_LOGOUT";
    private final IDPLogOutHandler idp = new IDPLogOutHandler();
    private final SPLogOutHandler sp = new SPLogOutHandler();

    @Override
    public void generateSAMLRequest(SAML2HandlerRequest request, SAML2HandlerResponse response) throws ProcessingException {
        if (request.getTypeOfRequestToBeGenerated() == null) {
            return;
        }
        if (SAML2HandlerRequest.GENERATE_REQUEST_TYPE.LOGOUT != request.getTypeOfRequestToBeGenerated()) {
            return;
        }
        if (this.getType() == SAML2Handler.HANDLER_TYPE.IDP) {
            this.idp.generateSAMLRequest(request, response);
        } else {
            this.sp.generateSAMLRequest(request, response);
        }
    }

    @Override
    public void handleRequestType(SAML2HandlerRequest request, SAML2HandlerResponse response) throws ProcessingException {
        if (!(request.getSAML2Object() instanceof LogoutRequestType)) {
            return;
        }
        if (this.getType() == SAML2Handler.HANDLER_TYPE.IDP) {
            this.idp.handleRequestType(request, response);
        } else {
            this.sp.handleRequestType(request, response);
        }
    }

    @Override
    public void handleStatusResponseType(SAML2HandlerRequest request, SAML2HandlerResponse response) throws ProcessingException {
        if (request.getSAML2Object() instanceof ResponseType) {
            return;
        }
        if (!(request.getSAML2Object() instanceof StatusResponseType)) {
            return;
        }
        if (this.getType() == SAML2Handler.HANDLER_TYPE.IDP) {
            this.idp.handleStatusResponseType(request, response);
        } else {
            this.sp.handleStatusResponseType(request, response);
        }
    }

    public static boolean isBackChannelLogoutRequest(SAML2HandlerRequest request) {
        HTTPContext httpContext = (HTTPContext)request.getContext();
        HttpServletRequest httpServletRequest = httpContext.getRequest();
        return httpServletRequest.getParameter(BACK_CHANNEL_LOGOUT) != null;
    }

    private String getIdentityURL(SAML2HandlerRequest request) {
        SPType spConfiguration = this.getSPConfiguration();
        HTTPContext httpContext = (HTTPContext)request.getContext();
        HttpServletRequest httpServletRequest = httpContext.getRequest();
        String desiredIdP = (String)httpServletRequest.getAttribute("picketlink.desired.idp");
        if (desiredIdP != null) {
            return desiredIdP;
        }
        return spConfiguration.getIdentityURL();
    }

    private SPType getSPConfiguration() {
        return (SPType)this.getProviderconfig();
    }

    private class SPLogOutHandler {
        private SPLogOutHandler() {
        }

        public void generateSAMLRequest(SAML2HandlerRequest request, SAML2HandlerResponse response) throws ProcessingException {
            SAML2Request samlRequest = new SAML2Request();
            HTTPContext httpContext = (HTTPContext)request.getContext();
            HttpServletRequest httpRequest = httpContext.getRequest();
            Principal userPrincipal = (Principal)httpRequest.getSession().getAttribute("picketlink.principal");
            if (userPrincipal == null) {
                userPrincipal = httpRequest.getUserPrincipal();
            }
            if (userPrincipal == null) {
                return;
            }
            try {
                LogoutRequestType lot = samlRequest.createLogoutRequest(request.getIssuer().getValue());
                NameIDType nameID = new NameIDType();
                nameID.setValue(userPrincipal.getName());
                String nameIDFormat = (String)SAML2LogOutHandler.this.handlerConfig.getParameter("NAMEID_FORMAT");
                if (StringUtil.isNullOrEmpty((String)nameIDFormat)) {
                    nameIDFormat = JBossSAMLURIConstants.NAMEID_FORMAT_PERSISTENT.get();
                }
                nameID.setFormat(URI.create(nameIDFormat));
                lot.setNameID(nameID);
                SPType spConfiguration = SAML2LogOutHandler.this.getSPConfiguration();
                String logoutUrl = spConfiguration.getLogoutUrl();
                if (logoutUrl == null) {
                    logoutUrl = SAML2LogOutHandler.this.getIdentityURL(request);
                }
                lot.setDestination(URI.create(logoutUrl));
                this.populateSessionIndex(httpRequest, lot);
                response.setResultingDocument(samlRequest.convert(lot));
                response.setSendRequest(true);
            }
            catch (Exception e) {
                throw BaseSAML2Handler.logger.processingError((Throwable)e);
            }
        }

        private void populateSessionIndex(HttpServletRequest httpRequest, LogoutRequestType lot) throws ProcessingException, ConfigurationException, ParsingException {
            Document currentAssertion = (Document)httpRequest.getSession().getAttribute("ASSERTION_SESSION_ATTRIBUTE_NAME");
            if (currentAssertion != null) {
                AssertionType assertionType = SAMLUtil.fromElement(currentAssertion.getDocumentElement());
                Set<StatementAbstractType> statements = assertionType.getStatements();
                for (StatementAbstractType statementAbstractType : statements) {
                    if (!AuthnStatementType.class.isInstance(statementAbstractType)) continue;
                    AuthnStatementType authnStatement = (AuthnStatementType)statementAbstractType;
                    String sessionIndex = authnStatement.getSessionIndex();
                    if (sessionIndex == null) break;
                    lot.addSessionIndex(sessionIndex);
                    break;
                }
            }
        }

        public void handleStatusResponseType(SAML2HandlerRequest request, SAML2HandlerResponse response) throws ProcessingException {
            StatusResponseType statusResponseType = (StatusResponseType)request.getSAML2Object();
            SAML2LogOutHandler.this.checkDestination(statusResponseType.getDestination(), SAML2LogOutHandler.this.getSPConfiguration().getServiceURL());
            HTTPContext httpContext = (HTTPContext)request.getContext();
            HttpServletRequest servletRequest = httpContext.getRequest();
            HttpSession session = servletRequest.getSession(false);
            StatusType statusType = statusResponseType.getStatus();
            StatusCodeType statusCode = statusType.getStatusCode();
            URI statusCodeValueURI = statusCode.getValue();
            boolean success = false;
            if (statusCodeValueURI != null) {
                String statusCodeValue = statusCodeValueURI.toString();
                if (JBossSAMLURIConstants.STATUS_SUCCESS.get().equals(statusCodeValue)) {
                    success = true;
                    session.invalidate();
                }
            }
        }

        public void handleRequestType(SAML2HandlerRequest request, SAML2HandlerResponse response) throws ProcessingException {
            SAML2Object samlObject = request.getSAML2Object();
            if (!(samlObject instanceof LogoutRequestType)) {
                return;
            }
            SPType spConfiguration = SAML2LogOutHandler.this.getSPConfiguration();
            LogoutRequestType logOutRequest = (LogoutRequestType)samlObject;
            SAML2LogOutHandler.this.checkDestination(logOutRequest.getDestination(), spConfiguration.getServiceURL());
            HTTPContext httpContext = (HTTPContext)request.getContext();
            HttpServletRequest servletRequest = httpContext.getRequest();
            HttpSession session = servletRequest.getSession(false);
            SessionManager sessionManager = SessionManager.get(session.getServletContext());
            final String pricipalName = logOutRequest.getNameID().getValue();
            sessionManager.invalidate(new Principal(){

                @Override
                public String getName() {
                    return pricipalName;
                }
            });
            StatusResponseType statusResponse = null;
            try {
                statusResponse = new StatusResponseType(IDGenerator.create("ID_"), XMLTimeUtil.getIssueInstant());
            }
            catch (ConfigurationException e) {
                throw BaseSAML2Handler.logger.processingError((Throwable)e);
            }
            StatusType statusType = new StatusType();
            StatusCodeType statusCodeType = new StatusCodeType();
            statusCodeType.setValue(URI.create(JBossSAMLURIConstants.STATUS_SUCCESS.get()));
            statusType.setStatusCode(statusCodeType);
            statusResponse.setStatus(statusType);
            statusResponse.setInResponseTo(logOutRequest.getID());
            statusResponse.setIssuer(request.getIssuer());
            String logoutResponseLocation = spConfiguration.getLogoutResponseLocation();
            if (logoutResponseLocation == null) {
                response.setDestination(logOutRequest.getIssuer().getValue());
            } else {
                response.setDestination(logoutResponseLocation);
            }
            statusResponse.setDestination(response.getDestination());
            SAML2Response saml2Response = new SAML2Response();
            try {
                response.setResultingDocument(saml2Response.convert(statusResponse));
            }
            catch (Exception je) {
                throw BaseSAML2Handler.logger.processingError((Throwable)je);
            }
            String relayState = servletRequest.getParameter("RelayState");
            response.setRelayState(relayState);
            response.setSendRequest(false);
        }
    }

    private class IDPLogOutHandler {
        private IDPLogOutHandler() {
        }

        public void generateSAMLRequest(SAML2HandlerRequest request, SAML2HandlerResponse response) throws ProcessingException {
        }

        public void handleStatusResponseType(SAML2HandlerRequest request, SAML2HandlerResponse response) throws ProcessingException {
            String relayState;
            SAML2Object samlObject = request.getSAML2Object();
            StatusResponseType statusResponseType = (StatusResponseType)samlObject;
            SAML2LogOutHandler.this.checkDestination(statusResponseType.getDestination(), SAML2LogOutHandler.this.getProviderconfig().getIdentityURL());
            String statusIssuer = statusResponseType.getIssuer().getValue();
            if (statusIssuer.equals(SAML2LogOutHandler.this.getProviderconfig().getIdentityURL())) {
                response.setDestination(SAML2LogOutHandler.this.getProviderconfig().getIdentityURL());
                return;
            }
            HTTPContext httpContext = (HTTPContext)request.getContext();
            HttpServletRequest httpRequest = httpContext.getRequest();
            HttpSession httpSession = httpRequest.getSession(false);
            String decodedRelayState = relayState = request.getRelayState();
            try {
                decodedRelayState = RedirectBindingUtil.urlDecode(relayState);
            }
            catch (IOException ignore) {
                decodedRelayState = relayState;
            }
            ServletContext servletCtx = httpContext.getServletContext();
            IdentityServer server = (IdentityServer)servletCtx.getAttribute("IDENTITY_SERVER");
            if (server == null) {
                throw BaseSAML2Handler.logger.samlHandlerIdentityServerNotFoundError();
            }
            String sessionID = httpSession.getId();
            server.stack().deRegisterTransitParticipant(sessionID, statusIssuer);
            String nextParticipant = this.getParticipant(server, sessionID, decodedRelayState);
            if (nextParticipant == null || nextParticipant.equals(decodedRelayState)) {
                AssertionType assertion = (AssertionType)httpSession.getAttribute("ASSERTION");
                if (assertion != null) {
                    PicketLinkCoreSTS sts = PicketLinkCoreSTS.instance();
                    SAMLProtocolContext samlProtocolContext = new SAMLProtocolContext();
                    samlProtocolContext.setIssuedAssertion(assertion);
                    sts.cancelToken(samlProtocolContext);
                    httpSession.removeAttribute("ASSERTION");
                }
                try {
                    this.generateSuccessStatusResponseType(statusResponseType.getInResponseTo(), request, response, relayState);
                    boolean isPost = this.isPostBindingForResponse(server, relayState, request);
                    response.setPostBindingForResponse(isPost);
                }
                catch (Exception e) {
                    throw BaseSAML2Handler.logger.processingError((Throwable)e);
                }
                Map<String, Object> requestOptions = request.getOptions();
                PicketLinkAuditHelper auditHelper = (PicketLinkAuditHelper)requestOptions.get("AUDIT_HELPER");
                if (auditHelper != null) {
                    PicketLinkAuditEvent auditEvent = new PicketLinkAuditEvent("Info");
                    auditEvent.setWhoIsAuditing((String)requestOptions.get("CONTEXT_PATH"));
                    auditEvent.setType(PicketLinkAuditEventType.INVALIDATE_HTTP_SESSION);
                    auditEvent.setHttpSessionID(httpSession.getId());
                    auditHelper.audit(auditEvent);
                }
                httpSession.invalidate();
            } else {
                server.stack().registerTransitParticipant(sessionID, nextParticipant);
                boolean isPost = this.isPostBindingForResponse(server, nextParticipant, request);
                response.setPostBindingForResponse(isPost);
                response.setRelayState(relayState);
                response.setDestination(nextParticipant);
                SAML2Request saml2Request = new SAML2Request();
                try {
                    LogoutRequestType lort = saml2Request.createLogoutRequest(request.getIssuer().getValue());
                    Principal userPrincipal = httpRequest.getUserPrincipal();
                    if (userPrincipal == null) {
                        throw BaseSAML2Handler.logger.samlHandlerPrincipalNotFoundError();
                    }
                    NameIDType nameID = new NameIDType();
                    nameID.setValue(userPrincipal.getName());
                    String nameIDFormat = (String)SAML2LogOutHandler.this.handlerConfig.getParameter("NAMEID_FORMAT");
                    if (StringUtil.isNullOrEmpty((String)nameIDFormat)) {
                        nameIDFormat = JBossSAMLURIConstants.NAMEID_FORMAT_PERSISTENT.get();
                    }
                    nameID.setFormat(URI.create(nameIDFormat));
                    lort.setNameID(nameID);
                    lort.setDestination(URI.create(nextParticipant));
                    response.setResultingDocument(saml2Request.convert(lort));
                    response.setSendRequest(true);
                }
                catch (Exception e) {
                    throw BaseSAML2Handler.logger.processingError((Throwable)e);
                }
            }
        }

        public void handleRequestType(SAML2HandlerRequest request, SAML2HandlerResponse response) throws ProcessingException {
            HTTPContext httpContext = (HTTPContext)request.getContext();
            HttpServletRequest httpServletRequest = httpContext.getRequest();
            HttpSession session = httpServletRequest.getSession(false);
            String relayState = httpContext.getRequest().getParameter("RelayState");
            LogoutRequestType logOutRequest = (LogoutRequestType)request.getSAML2Object();
            SAML2LogOutHandler.this.checkDestination(logOutRequest.getDestination(), SAML2LogOutHandler.this.getProviderconfig().getIdentityURL());
            String issuer = logOutRequest.getIssuer().getValue();
            try {
                String originalIssuer;
                String string = originalIssuer = relayState == null ? issuer : relayState;
                if (this.getIdentityServer(session.getServletContext()) == null) {
                    throw BaseSAML2Handler.logger.samlHandlerIdentityServerNotFoundError();
                }
                if (this.isBackChannelLogout()) {
                    this.performBackChannelLogout(request, originalIssuer);
                } else {
                    this.performFrontChannelLogout(request, response, logOutRequest, originalIssuer, relayState);
                }
            }
            catch (ParserConfigurationException pe) {
                throw BaseSAML2Handler.logger.processingError((Throwable)pe);
            }
            catch (ConfigurationException pe) {
                throw BaseSAML2Handler.logger.processingError((Throwable)pe);
            }
            catch (ParsingException e) {
                throw BaseSAML2Handler.logger.processingError((Throwable)e);
            }
        }

        private void performFrontChannelLogout(SAML2HandlerRequest request, SAML2HandlerResponse response, LogoutRequestType logOutRequest, String originalIssuer, String relayState) throws ConfigurationException, ParserConfigurationException, ProcessingException, ParsingException {
            HTTPContext httpContext = (HTTPContext)request.getContext();
            HttpServletRequest httpServletRequest = httpContext.getRequest();
            HttpSession session = httpServletRequest.getSession(false);
            String sessionID = session.getId();
            ServletContext servletCtx = httpContext.getServletContext();
            IdentityServer server = this.getIdentityServer(servletCtx);
            String participant = this.getParticipant(server, sessionID, originalIssuer);
            boolean isIssuer = participant.equals(originalIssuer);
            if (participant == null || isIssuer) {
                session.invalidate();
                server.stack().pop(sessionID);
                if (participant.equals(SAML2LogOutHandler.this.getProviderconfig().getIdentityURL())) {
                    response.setDestination(SAML2LogOutHandler.this.getProviderconfig().getIdentityURL());
                } else {
                    this.generateSuccessStatusResponseType(logOutRequest.getID(), request, response, originalIssuer);
                    boolean isPost = this.isPostBindingForResponse(server, participant, request);
                    response.setPostBindingForResponse(isPost);
                }
            } else {
                server.stack().registerTransitParticipant(sessionID, participant);
                response.setRelayState(originalIssuer);
                response.setDestination(participant);
                boolean isPost = this.isPostBindingForResponse(server, participant, request);
                response.setPostBindingForResponse(isPost);
                LogoutRequestType lort = this.createLogoutRequest(request, participant);
                response.setResultingDocument(new SAML2Request().convert(lort));
                response.setSendRequest(true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void performBackChannelLogout(SAML2HandlerRequest request, String originalIssuer) throws ProcessingException {
            String partitipant = originalIssuer;
            HTTPContext httpContext = (HTTPContext)request.getContext();
            HttpServletRequest httpServletRequest = httpContext.getRequest();
            HttpSession session = httpServletRequest.getSession(false);
            String sessionID = session.getId();
            ServletContext servletCtx = httpContext.getServletContext();
            IdentityServer server = this.getIdentityServer(servletCtx);
            while (partitipant != null) {
                HttpURLConnection urlConnection = null;
                try {
                    URL participantURL = new URL(partitipant);
                    urlConnection = (HttpURLConnection)participantURL.openConnection();
                    if (participantURL.getProtocol().contains("https")) {
                        try {
                            HttpsURLConnection https = (HttpsURLConnection)urlConnection;
                            SSLContext sslContext = SSLContext.getInstance("TLS");
                            sslContext.init(null, new TrustManager[]{new X509TrustManager(){

                                @Override
                                public X509Certificate[] getAcceptedIssuers() {
                                    return null;
                                }

                                @Override
                                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                                }

                                @Override
                                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                                }
                            }}, null);
                            https.setSSLSocketFactory(sslContext.getSocketFactory());
                            HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier(){

                                @Override
                                public boolean verify(String hostname, SSLSession session) {
                                    return true;
                                }
                            });
                        }
                        catch (Exception e) {
                            throw new ProcessingException("Error while preparing HTTPS connection during back channel logout.", (Throwable)e);
                        }
                    }
                    urlConnection.setRequestMethod("POST");
                    urlConnection.setDoOutput(true);
                    urlConnection.setAllowUserInteraction(false);
                    urlConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                    LogoutRequestType logoutRequest = this.createLogoutRequest(request, partitipant);
                    Document logoutRequestDocument = new SAML2Request().convert(logoutRequest);
                    byte[] responseBytes = DocumentUtil.getDocumentAsString((Document)logoutRequestDocument).getBytes("UTF-8");
                    String samlResponse = PostBindingUtil.base64Encode(new String(responseBytes));
                    StringBuilder parameterBuilder = new StringBuilder();
                    parameterBuilder.append("SAMLRequest").append("=").append(URLEncoder.encode(samlResponse, "UTF-8")).append("&").append(SAML2LogOutHandler.BACK_CHANNEL_LOGOUT).append("=").append(SAML2LogOutHandler.BACK_CHANNEL_LOGOUT);
                    urlConnection.setRequestProperty("Content-Length", Integer.toString(parameterBuilder.length()));
                    if (BaseSAML2Handler.logger.isDebugEnabled()) {
                        BaseSAML2Handler.logger.debug("Sending back channel logout request to [" + partitipant + "]. Logout request is [ " + DocumentUtil.asString((Document)logoutRequestDocument) + "].");
                    }
                    DataOutputStream wr = new DataOutputStream(urlConnection.getOutputStream());
                    wr.writeBytes(parameterBuilder.toString());
                    wr.flush();
                    wr.close();
                    InputStream inputStream = urlConnection.getInputStream();
                    inputStream.close();
                }
                catch (Exception ignore) {
                    BaseSAML2Handler.logger.warn("Could not perform global logout from service provider [" + partitipant + "].");
                    BaseSAML2Handler.logger.samlLogoutError((Throwable)ignore);
                }
                finally {
                    if (urlConnection != null) {
                        urlConnection.disconnect();
                    }
                }
                partitipant = server.stack().pop(sessionID);
            }
            session.invalidate();
            try {
                HttpServletResponse httpServletResponse = httpContext.getResponse();
                httpServletResponse.sendRedirect(SAML2LogOutHandler.this.getProviderconfig().getIdentityURL());
            }
            catch (IOException e) {
                throw new ProcessingException("Could not redirect to IdP after a successful logout.", (Throwable)e);
            }
        }

        private IdentityServer getIdentityServer(ServletContext servletCtx) {
            return (IdentityServer)servletCtx.getAttribute("IDENTITY_SERVER");
        }

        private LogoutRequestType createLogoutRequest(SAML2HandlerRequest request, String participant) throws ConfigurationException, ProcessingException {
            HTTPContext httpContext = (HTTPContext)request.getContext();
            HttpServletRequest httpServletRequest = httpContext.getRequest();
            LogoutRequestType lort = new SAML2Request().createLogoutRequest(request.getIssuer().getValue());
            Principal userPrincipal = httpServletRequest.getUserPrincipal();
            if (userPrincipal == null) {
                throw BaseSAML2Handler.logger.samlHandlerPrincipalNotFoundError();
            }
            NameIDType nameID = new NameIDType();
            nameID.setValue(userPrincipal.getName());
            String nameIDFormat = (String)SAML2LogOutHandler.this.handlerConfig.getParameter("NAMEID_FORMAT");
            if (StringUtil.isNullOrEmpty((String)nameIDFormat)) {
                nameIDFormat = JBossSAMLURIConstants.NAMEID_FORMAT_PERSISTENT.get();
            }
            nameID.setFormat(URI.create(nameIDFormat));
            lort.setNameID(nameID);
            long assertionValidity = PicketLinkCoreSTS.instance().getConfiguration().getIssuedTokenTimeout();
            lort.setNotOnOrAfter(XMLTimeUtil.add(lort.getIssueInstant(), assertionValidity));
            lort.setDestination(URI.create(participant));
            return lort;
        }

        private boolean isBackChannelLogout() {
            return SAML2LogOutHandler.this.handlerConfig.getParameter(SAML2LogOutHandler.BACK_CHANNEL_LOGOUT) != null ? Boolean.valueOf(SAML2LogOutHandler.this.handlerConfig.getParameter(SAML2LogOutHandler.BACK_CHANNEL_LOGOUT).toString()) : false;
        }

        private void generateSuccessStatusResponseType(String logOutRequestID, SAML2HandlerRequest request, SAML2HandlerResponse response, String originalIssuer) throws ConfigurationException, ParserConfigurationException, ProcessingException {
            BaseSAML2Handler.logger.trace("Generating Success Status Response for " + originalIssuer);
            StatusResponseType statusResponse = new StatusResponseType(IDGenerator.create("ID_"), XMLTimeUtil.getIssueInstant());
            StatusType statusType = new StatusType();
            StatusCodeType statusCodeType = new StatusCodeType();
            statusCodeType.setValue(URI.create(JBossSAMLURIConstants.STATUS_SUCCESS.get()));
            statusType.setStatusCode(statusCodeType);
            statusResponse.setStatus(statusType);
            statusResponse.setInResponseTo(logOutRequestID);
            statusResponse.setIssuer(request.getIssuer());
            statusResponse.setDestination(originalIssuer);
            try {
                SAML2Response saml2Response = new SAML2Response();
                response.setResultingDocument(saml2Response.convert(statusResponse));
            }
            catch (ParsingException je) {
                throw BaseSAML2Handler.logger.processingError((Throwable)je);
            }
            response.setDestination(originalIssuer);
        }

        private String getParticipant(IdentityServer server, String sessionID, String originalRequestor) {
            int participants = server.stack().getParticipants(sessionID);
            String participant = originalRequestor;
            if (participants > 0) {
                do {
                    participant = server.stack().pop(sessionID);
                } while (--participants > 0 && participant.equals(originalRequestor));
            }
            return participant;
        }

        private boolean isPostBindingForResponse(IdentityServer server, String participant, SAML2HandlerRequest request) {
            Boolean isStrictPostBindingForResponse;
            Boolean isPostParticipant = server.stack().getBinding(participant);
            if (isPostParticipant == null) {
                isPostParticipant = Boolean.TRUE;
            }
            if ((isStrictPostBindingForResponse = (Boolean)request.getOptions().get("SAML_IDP_STRICT_POST_BINDING")) == null) {
                isStrictPostBindingForResponse = Boolean.FALSE;
            }
            return isPostParticipant != false || isStrictPostBindingForResponse != false;
        }
    }
}

