/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.mongo.utils;

import com.mongodb.DBObject;
import com.mongodb.QueryBuilder;
import java.util.Collections;
import java.util.List;
import org.keycloak.connections.mongo.api.context.MongoStoreInvocationContext;
import org.keycloak.models.ClientModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.entities.ClientEntity;
import org.keycloak.models.mongo.keycloak.adapters.ClientAdapter;
import org.keycloak.models.mongo.keycloak.adapters.UserAdapter;
import org.keycloak.models.mongo.keycloak.entities.MongoRoleEntity;
import org.keycloak.models.mongo.keycloak.entities.MongoUserEntity;

public class MongoModelUtils {
    public static List<MongoRoleEntity> getAllRolesOfUser(UserModel user, MongoStoreInvocationContext invContext) {
        MongoUserEntity userEntity = ((UserAdapter)user).getUser();
        List roleIds = userEntity.getRoleIds();
        if (roleIds == null || roleIds.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        DBObject query = new QueryBuilder().and("_id").in((Object)roleIds).get();
        return invContext.getMongoStore().loadEntities(MongoRoleEntity.class, query, invContext);
    }

    public static List<MongoRoleEntity> getAllScopesOfClient(ClientModel client, MongoStoreInvocationContext invContext) {
        ClientEntity scopedEntity = ((ClientAdapter)client).getMongoEntityAsClient();
        List scopeIds = scopedEntity.getScopeIds();
        if (scopeIds == null || scopeIds.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        DBObject query = new QueryBuilder().and("_id").in((Object)scopeIds).get();
        return invContext.getMongoStore().loadEntities(MongoRoleEntity.class, query, invContext);
    }
}

