/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.saml.mappers;

import java.util.ArrayList;
import java.util.List;
import org.keycloak.models.ClientSessionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.ProtocolMapper;
import org.keycloak.protocol.saml.mappers.AbstractSAMLProtocolMapper;
import org.keycloak.protocol.saml.mappers.AttributeStatementHelper;
import org.keycloak.protocol.saml.mappers.SAMLAttributeStatementMapper;
import org.picketlink.identity.federation.saml.v2.assertion.AttributeStatementType;

public class UserAttributeStatementMapper
extends AbstractSAMLProtocolMapper
implements SAMLAttributeStatementMapper {
    private static final List<ProtocolMapper.ConfigProperty> configProperties = new ArrayList<ProtocolMapper.ConfigProperty>();
    public static final String PROVIDER_ID = "saml-user-attribute-mapper";

    public List<ProtocolMapper.ConfigProperty> getConfigProperties() {
        return configProperties;
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public String getDisplayType() {
        return "User Attribute";
    }

    public String getDisplayCategory() {
        return "AttributeStatement Mapper";
    }

    public String getHelpText() {
        return "Map a custom user attribute to a to a SAML attribute.";
    }

    @Override
    public void transformAttributeStatement(AttributeStatementType attributeStatement, ProtocolMapperModel mappingModel, KeycloakSession session, UserSessionModel userSession, ClientSessionModel clientSession) {
        UserModel user = userSession.getUser();
        String attributeName = (String)mappingModel.getConfig().get("user.attribute");
        String attributeValue = user.getAttribute(attributeName);
        AttributeStatementHelper.addAttribute(attributeStatement, mappingModel, attributeValue);
    }

    public static ProtocolMapperModel createAttributeMapper(String name, String userAttribute, String samlAttributeName, String nameFormat, String friendlyName, boolean consentRequired, String consentText) {
        String mapperId = PROVIDER_ID;
        return AttributeStatementHelper.createAttributeMapper(name, userAttribute, samlAttributeName, nameFormat, friendlyName, consentRequired, consentText, mapperId);
    }

    static {
        ProtocolMapper.ConfigProperty property = new ProtocolMapper.ConfigProperty();
        property.setName("user.attribute");
        property.setLabel("User Attribute");
        property.setHelpText("Name of stored user attribute which is the name of an attribute within the UserModel.attribute map.");
        configProperties.add(property);
        AttributeStatementHelper.setConfigProperties(configProperties);
    }
}

