/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.federation.ldap;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.logging.Logger;
import org.keycloak.federation.kerberos.impl.KerberosUsernamePasswordAuthenticator;
import org.keycloak.federation.kerberos.impl.SPNEGOAuthenticator;
import org.keycloak.federation.ldap.LDAPFederationProviderFactory;
import org.keycloak.federation.ldap.LDAPUtils;
import org.keycloak.federation.ldap.ReadonlyLDAPUserModelDelegate;
import org.keycloak.federation.ldap.UnsyncedLDAPUserModelDelegate;
import org.keycloak.federation.ldap.WritableLDAPUserModelDelegate;
import org.keycloak.federation.ldap.kerberos.LDAPProviderKerberosConfig;
import org.keycloak.models.CredentialValidationOutput;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserCredentialValueModel;
import org.keycloak.models.UserFederationProvider;
import org.keycloak.models.UserFederationProviderModel;
import org.keycloak.models.UserModel;
import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.PartitionManager;
import org.picketlink.idm.model.basic.BasicModel;
import org.picketlink.idm.model.basic.User;
import org.picketlink.idm.query.IdentityQuery;

public class LDAPFederationProvider
implements UserFederationProvider {
    private static final Logger logger = Logger.getLogger(LDAPFederationProvider.class);
    public static final String LDAP_ID = "LDAP_ID";
    public static final String SYNC_REGISTRATIONS = "syncRegistrations";
    protected LDAPFederationProviderFactory factory;
    protected KeycloakSession session;
    protected UserFederationProviderModel model;
    protected PartitionManager partitionManager;
    protected UserFederationProvider.EditMode editMode;
    protected LDAPProviderKerberosConfig kerberosConfig;
    protected final Set<String> supportedCredentialTypes = new HashSet<String>();

    public LDAPFederationProvider(LDAPFederationProviderFactory factory, KeycloakSession session, UserFederationProviderModel model, PartitionManager partitionManager) {
        this.factory = factory;
        this.session = session;
        this.model = model;
        this.partitionManager = partitionManager;
        this.kerberosConfig = new LDAPProviderKerberosConfig(model);
        String editModeString = (String)model.getConfig().get("editMode");
        this.editMode = editModeString == null ? UserFederationProvider.EditMode.READ_ONLY : UserFederationProvider.EditMode.valueOf((String)editModeString);
        this.supportedCredentialTypes.add("password");
        if (this.kerberosConfig.isAllowKerberosAuthentication()) {
            this.supportedCredentialTypes.add("kerberos");
        }
    }

    private ModelException convertIDMException(IdentityManagementException ie) {
        Throwable realCause = ie;
        while (realCause.getCause() != null) {
            realCause = realCause.getCause();
        }
        return new ModelException(realCause.getMessage(), (Throwable)ie);
    }

    public KeycloakSession getSession() {
        return this.session;
    }

    public UserFederationProviderModel getModel() {
        return this.model;
    }

    public PartitionManager getPartitionManager() {
        return this.partitionManager;
    }

    public UserModel proxy(UserModel local) {
        switch (this.editMode) {
            case READ_ONLY: {
                return new ReadonlyLDAPUserModelDelegate(local, this);
            }
            case WRITABLE: {
                return new WritableLDAPUserModelDelegate(local, this);
            }
            case UNSYNCED: {
                return new UnsyncedLDAPUserModelDelegate(local, this);
            }
        }
        return local;
    }

    public Set<String> getSupportedCredentialTypes(UserModel local) {
        HashSet<String> supportedCredentialTypes = new HashSet<String>(this.supportedCredentialTypes);
        if (this.editMode == UserFederationProvider.EditMode.UNSYNCED) {
            for (UserCredentialValueModel cred : local.getCredentialsDirectly()) {
                if (!cred.getType().equals("password")) continue;
                supportedCredentialTypes.remove("password");
            }
        }
        return supportedCredentialTypes;
    }

    public Set<String> getSupportedCredentialTypes() {
        return new HashSet<String>(this.supportedCredentialTypes);
    }

    public boolean synchronizeRegistrations() {
        return "true".equalsIgnoreCase((String)this.model.getConfig().get(SYNC_REGISTRATIONS)) && this.editMode == UserFederationProvider.EditMode.WRITABLE;
    }

    public UserModel register(RealmModel realm, UserModel user) {
        if (this.editMode == UserFederationProvider.EditMode.READ_ONLY || this.editMode == UserFederationProvider.EditMode.UNSYNCED) {
            throw new IllegalStateException("Registration is not supported by this ldap server");
        }
        if (!this.synchronizeRegistrations()) {
            throw new IllegalStateException("Registration is not supported by this ldap server");
        }
        try {
            User picketlinkUser = LDAPUtils.addUser(this.partitionManager, user.getUsername(), user.getFirstName(), user.getLastName(), user.getEmail());
            user.setAttribute(LDAP_ID, picketlinkUser.getId());
            return this.proxy(user);
        }
        catch (IdentityManagementException ie) {
            throw this.convertIDMException(ie);
        }
    }

    public boolean removeUser(RealmModel realm, UserModel user) {
        if (this.editMode == UserFederationProvider.EditMode.READ_ONLY || this.editMode == UserFederationProvider.EditMode.UNSYNCED) {
            logger.warnf("User '%s' can't be deleted in LDAP as editMode is '%s'", (Object)user.getUsername(), (Object)this.editMode.toString());
            return false;
        }
        try {
            return LDAPUtils.removeUser(this.partitionManager, user.getUsername());
        }
        catch (IdentityManagementException ie) {
            throw this.convertIDMException(ie);
        }
    }

    public List<UserModel> searchByAttributes(Map<String, String> attributes, RealmModel realm, int maxResults) {
        LinkedList<UserModel> searchResults = new LinkedList<UserModel>();
        try {
            Map<String, User> plUsers = this.searchPicketlink(attributes, maxResults);
            for (User user : plUsers.values()) {
                if (this.session.userStorage().getUserByUsername(user.getLoginName(), realm) != null) continue;
                UserModel imported = this.importUserFromPicketlink(realm, user);
                searchResults.add(imported);
            }
        }
        catch (IdentityManagementException ie) {
            throw this.convertIDMException(ie);
        }
        return searchResults;
    }

    protected Map<String, User> searchPicketlink(Map<String, String> attributes, int maxResults) {
        User user;
        IdentityManager identityManager = this.getIdentityManager();
        HashMap<String, User> results = new HashMap<String, User>();
        if (attributes.containsKey("username") && (user = BasicModel.getUser((IdentityManager)identityManager, (String)attributes.get("username"))) != null) {
            results.put(user.getLoginName(), user);
        }
        if (attributes.containsKey("email") && (user = this.queryByEmail(identityManager, attributes.get("email"))) != null) {
            results.put(user.getLoginName(), user);
        }
        if (attributes.containsKey("firstName") || attributes.containsKey("lastName")) {
            IdentityQuery query = identityManager.createIdentityQuery(User.class);
            if (attributes.containsKey("firstName")) {
                query.setParameter(User.FIRST_NAME, new Object[]{attributes.get("firstName")});
            }
            if (attributes.containsKey("lastName")) {
                query.setParameter(User.LAST_NAME, new Object[]{attributes.get("lastName")});
            }
            query.setLimit(maxResults);
            List agents = query.getResultList();
            for (User user2 : agents) {
                results.put(user2.getLoginName(), user2);
            }
        }
        return results;
    }

    public boolean isValid(UserModel local) {
        try {
            User picketlinkUser = LDAPUtils.getUser(this.partitionManager, local.getUsername());
            if (picketlinkUser == null) {
                return false;
            }
            return picketlinkUser.getId().equals(local.getAttribute(LDAP_ID));
        }
        catch (IdentityManagementException ie) {
            throw this.convertIDMException(ie);
        }
    }

    public UserModel getUserByUsername(RealmModel realm, String username) {
        try {
            User picketlinkUser = LDAPUtils.getUser(this.partitionManager, username);
            if (picketlinkUser == null) {
                return null;
            }
            if (!username.equals(picketlinkUser.getLoginName())) {
                logger.warnf("User found in LDAP but with different username. LDAP username: %s, Searched username: %s", (Object)username, (Object)picketlinkUser.getLoginName());
                return null;
            }
            return this.importUserFromPicketlink(realm, picketlinkUser);
        }
        catch (IdentityManagementException ie) {
            throw this.convertIDMException(ie);
        }
    }

    public IdentityManager getIdentityManager() {
        return this.partitionManager.createIdentityManager();
    }

    protected UserModel importUserFromPicketlink(RealmModel realm, User picketlinkUser) {
        String email;
        String string = email = picketlinkUser.getEmail() != null && picketlinkUser.getEmail().trim().length() > 0 ? picketlinkUser.getEmail() : null;
        if (picketlinkUser.getLoginName() == null) {
            throw new ModelException("User returned from LDAP has null username! Check configuration of your LDAP mappings. ID of user from LDAP: " + picketlinkUser.getId());
        }
        UserModel imported = this.session.userStorage().addUser(realm, picketlinkUser.getLoginName());
        imported.setEnabled(true);
        imported.setEmail(email);
        imported.setFirstName(picketlinkUser.getFirstName());
        imported.setLastName(picketlinkUser.getLastName());
        imported.setFederationLink(this.model.getId());
        imported.setAttribute(LDAP_ID, picketlinkUser.getId());
        logger.debugf("Added new user from LDAP. Username: " + imported.getUsername() + ", Email: ", (Object)(imported.getEmail() + ", LDAP_ID: " + picketlinkUser.getId()));
        return this.proxy(imported);
    }

    protected User queryByEmail(IdentityManager identityManager, String email) throws IdentityManagementException {
        return LDAPUtils.getUserByEmail(identityManager, email);
    }

    public UserModel getUserByEmail(RealmModel realm, String email) {
        IdentityManager identityManager = this.getIdentityManager();
        try {
            User picketlinkUser = this.queryByEmail(identityManager, email);
            if (picketlinkUser == null) {
                return null;
            }
            if (!email.equals(picketlinkUser.getEmail())) {
                logger.warnf("User found in LDAP but with different email. LDAP email: %s, Searched email: %s", (Object)email, (Object)picketlinkUser.getEmail());
                return null;
            }
            return this.importUserFromPicketlink(realm, picketlinkUser);
        }
        catch (IdentityManagementException ie) {
            throw this.convertIDMException(ie);
        }
    }

    public void preRemove(RealmModel realm) {
    }

    public void preRemove(RealmModel realm, RoleModel role) {
    }

    public boolean validPassword(String username, String password) {
        if (this.kerberosConfig.isAllowKerberosAuthentication() && this.kerberosConfig.isUseKerberosForPasswordAuthentication()) {
            KerberosUsernamePasswordAuthenticator authenticator = this.factory.createKerberosUsernamePasswordAuthenticator(this.kerberosConfig);
            return authenticator.validUser(username, password);
        }
        try {
            return LDAPUtils.validatePassword(this.partitionManager, username, password);
        }
        catch (IdentityManagementException ie) {
            throw this.convertIDMException(ie);
        }
    }

    public boolean validCredentials(RealmModel realm, UserModel user, List<UserCredentialModel> input) {
        Iterator<UserCredentialModel> i$ = input.iterator();
        if (i$.hasNext()) {
            UserCredentialModel cred = i$.next();
            if (cred.getType().equals("password")) {
                return this.validPassword(user.getUsername(), cred.getValue());
            }
            return false;
        }
        return true;
    }

    public boolean validCredentials(RealmModel realm, UserModel user, UserCredentialModel ... input) {
        return this.validCredentials(realm, user, Arrays.asList(input));
    }

    public CredentialValidationOutput validCredentials(RealmModel realm, UserCredentialModel credential) {
        if (credential.getType().equals("kerberos") && this.kerberosConfig.isAllowKerberosAuthentication()) {
            String spnegoToken = credential.getValue();
            SPNEGOAuthenticator spnegoAuthenticator = this.factory.createSPNEGOAuthenticator(spnegoToken, this.kerberosConfig);
            spnegoAuthenticator.authenticate();
            HashMap<String, String> state = new HashMap<String, String>();
            if (spnegoAuthenticator.isAuthenticated()) {
                String username = spnegoAuthenticator.getAuthenticatedUsername();
                UserModel user = this.findOrCreateAuthenticatedUser(realm, username);
                if (user == null) {
                    logger.warn((Object)("Kerberos/SPNEGO authentication succeeded with username [" + username + "], but couldn't find or create user with federation provider [" + this.model.getDisplayName() + "]"));
                    return CredentialValidationOutput.failed();
                }
                String delegationCredential = spnegoAuthenticator.getSerializedDelegationCredential();
                if (delegationCredential != null) {
                    state.put("gss_delegation_credential", delegationCredential);
                }
                return new CredentialValidationOutput(user, CredentialValidationOutput.Status.AUTHENTICATED, state);
            }
            state.put("SpnegoResponseToken", spnegoAuthenticator.getResponseToken());
            return new CredentialValidationOutput(null, CredentialValidationOutput.Status.CONTINUE, state);
        }
        return CredentialValidationOutput.failed();
    }

    public void close() {
    }

    protected void importPicketlinkUsers(RealmModel realm, List<User> users, UserFederationProviderModel fedModel) {
        for (User picketlinkUser : users) {
            String username = picketlinkUser.getLoginName();
            UserModel currentUser = this.session.userStorage().getUserByUsername(username, realm);
            if (currentUser == null) {
                this.importUserFromPicketlink(realm, picketlinkUser);
                continue;
            }
            if (fedModel.getId().equals(currentUser.getFederationLink()) && picketlinkUser.getId().equals(currentUser.getAttribute(LDAP_ID))) {
                String email = picketlinkUser.getEmail() != null && picketlinkUser.getEmail().trim().length() > 0 ? picketlinkUser.getEmail() : null;
                currentUser.setEmail(email);
                currentUser.setFirstName(picketlinkUser.getFirstName());
                currentUser.setLastName(picketlinkUser.getLastName());
                logger.debugf("Updated user from LDAP: %s", (Object)currentUser.getUsername());
                continue;
            }
            logger.warnf("User '%s' is not updated during sync as he is not linked to federation provider '%s'", (Object)username, (Object)fedModel.getDisplayName());
        }
    }

    protected UserModel findOrCreateAuthenticatedUser(RealmModel realm, String username) {
        UserModel user = this.session.userStorage().getUserByUsername(username, realm);
        if (user != null) {
            logger.debug((Object)("Kerberos authenticated user " + username + " found in Keycloak storage"));
            if (!this.model.getId().equals(user.getFederationLink())) {
                logger.warn((Object)("User with username " + username + " already exists, but is not linked to provider [" + this.model.getDisplayName() + "]"));
                return null;
            }
            if (this.isValid(user)) {
                return this.proxy(user);
            }
            logger.warn((Object)("User with username " + username + " already exists and is linked to provider [" + this.model.getDisplayName() + "] but is not valid. Stale LDAP_ID on local user is: " + user.getAttribute(LDAP_ID)));
            logger.warn((Object)"Will re-create user");
            this.session.userStorage().removeUser(realm, user);
        }
        logger.debug((Object)("Kerberos authenticated user " + username + " not in Keycloak storage. Creating him"));
        return this.getUserByUsername(realm, username);
    }
}

