/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.mongo;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.QueryBuilder;
import java.util.LinkedList;
import java.util.List;
import org.keycloak.connections.mongo.api.MongoIdentifiableEntity;
import org.keycloak.connections.mongo.api.MongoStore;
import org.keycloak.connections.mongo.api.context.MongoStoreInvocationContext;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientSessionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.UserSessionProvider;
import org.keycloak.models.UsernameLoginFailureModel;
import org.keycloak.models.sessions.mongo.ClientSessionAdapter;
import org.keycloak.models.sessions.mongo.UserSessionAdapter;
import org.keycloak.models.sessions.mongo.UsernameLoginFailureAdapter;
import org.keycloak.models.sessions.mongo.entities.MongoClientSessionEntity;
import org.keycloak.models.sessions.mongo.entities.MongoUserSessionEntity;
import org.keycloak.models.sessions.mongo.entities.MongoUsernameLoginFailureEntity;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.RealmInfoUtil;
import org.keycloak.util.Time;

public class MongoUserSessionProvider
implements UserSessionProvider {
    private final KeycloakSession session;
    private final MongoStore mongoStore;
    private final MongoStoreInvocationContext invocationContext;

    public MongoUserSessionProvider(KeycloakSession session, MongoStore mongoStore, MongoStoreInvocationContext invocationContext) {
        this.session = session;
        this.mongoStore = mongoStore;
        this.invocationContext = invocationContext;
    }

    public MongoStore getMongoStore() {
        return this.mongoStore;
    }

    public ClientSessionModel createClientSession(RealmModel realm, ClientModel client) {
        MongoClientSessionEntity entity = new MongoClientSessionEntity();
        entity.setId(KeycloakModelUtils.generateId());
        entity.setTimestamp(Time.currentTime());
        entity.setClientId(client.getId());
        entity.setRealmId(realm.getId());
        this.mongoStore.insertEntity((MongoIdentifiableEntity)entity, this.invocationContext);
        return new ClientSessionAdapter(this.session, this, realm, entity, this.invocationContext);
    }

    public ClientSessionModel getClientSession(RealmModel realm, String id) {
        MongoClientSessionEntity entity = this.getClientSessionEntity(id);
        if (entity == null) {
            return null;
        }
        return new ClientSessionAdapter(this.session, this, realm, entity, this.invocationContext);
    }

    public ClientSessionModel getClientSession(String id) {
        MongoClientSessionEntity entity = this.getClientSessionEntity(id);
        if (entity != null) {
            RealmModel realm = this.session.realms().getRealm(entity.getRealmId());
            return new ClientSessionAdapter(this.session, this, realm, entity, this.invocationContext);
        }
        return null;
    }

    public UserSessionModel createUserSession(RealmModel realm, UserModel user, String loginUsername, String ipAddress, String authMethod, boolean rememberMe, String brokerSessionId, String brokerUserId) {
        MongoUserSessionEntity entity = new MongoUserSessionEntity();
        entity.setRealmId(realm.getId());
        entity.setUser(user.getId());
        entity.setLoginUsername(loginUsername);
        entity.setIpAddress(ipAddress);
        entity.setAuthMethod(authMethod);
        entity.setRememberMe(rememberMe);
        entity.setRealmId(realm.getId());
        entity.setBrokerSessionId(brokerSessionId);
        entity.setBrokerUserId(brokerUserId);
        int currentTime = Time.currentTime();
        entity.setStarted(currentTime);
        entity.setLastSessionRefresh(currentTime);
        this.mongoStore.insertEntity((MongoIdentifiableEntity)entity, this.invocationContext);
        return new UserSessionAdapter(this.session, this, entity, realm, this.invocationContext);
    }

    public UserSessionModel getUserSession(RealmModel realm, String id) {
        MongoUserSessionEntity entity = this.getUserSessionEntity(realm, id);
        if (entity == null) {
            return null;
        }
        return new UserSessionAdapter(this.session, this, entity, realm, this.invocationContext);
    }

    MongoUserSessionEntity getUserSessionEntity(RealmModel realm, String id) {
        return (MongoUserSessionEntity)this.mongoStore.loadEntity(MongoUserSessionEntity.class, id, this.invocationContext);
    }

    MongoClientSessionEntity getClientSessionEntity(String id) {
        return (MongoClientSessionEntity)this.mongoStore.loadEntity(MongoClientSessionEntity.class, id, this.invocationContext);
    }

    public List<UserSessionModel> getUserSessions(RealmModel realm, UserModel user) {
        BasicDBObject query = new BasicDBObject("user", (Object)user.getId());
        LinkedList<UserSessionModel> sessions = new LinkedList<UserSessionModel>();
        for (MongoUserSessionEntity e : this.mongoStore.loadEntities(MongoUserSessionEntity.class, (DBObject)query, this.invocationContext)) {
            sessions.add(new UserSessionAdapter(this.session, this, e, realm, this.invocationContext));
        }
        return sessions;
    }

    public List<UserSessionModel> getUserSessionByBrokerUserId(RealmModel realm, String brokerUserId) {
        BasicDBObject query = new BasicDBObject("brokerUserId", (Object)brokerUserId);
        LinkedList<UserSessionModel> sessions = new LinkedList<UserSessionModel>();
        for (MongoUserSessionEntity e : this.mongoStore.loadEntities(MongoUserSessionEntity.class, (DBObject)query, this.invocationContext)) {
            sessions.add(new UserSessionAdapter(this.session, this, e, realm, this.invocationContext));
        }
        return sessions;
    }

    public UserSessionModel getUserSessionByBrokerSessionId(RealmModel realm, String brokerSessionId) {
        BasicDBObject query = new BasicDBObject("brokerSessionId", (Object)brokerSessionId);
        LinkedList<UserSessionAdapter> sessions = new LinkedList<UserSessionAdapter>();
        for (MongoUserSessionEntity e : this.mongoStore.loadEntities(MongoUserSessionEntity.class, (DBObject)query, this.invocationContext)) {
            sessions.add(new UserSessionAdapter(this.session, this, e, realm, this.invocationContext));
        }
        if (sessions.isEmpty()) {
            return null;
        }
        return (UserSessionModel)sessions.get(0);
    }

    public List<UserSessionModel> getUserSessionsByNote(RealmModel realm, String noteName, String noteValue) {
        DBObject query = new QueryBuilder().and("realmId").is((Object)realm.getId()).and("notes." + noteName).is((Object)noteValue).get();
        LinkedList<UserSessionModel> sessions = new LinkedList<UserSessionModel>();
        for (MongoUserSessionEntity e : this.mongoStore.loadEntities(MongoUserSessionEntity.class, query, this.invocationContext)) {
            sessions.add(new UserSessionAdapter(this.session, this, e, realm, this.invocationContext));
        }
        return sessions;
    }

    public List<UserSessionModel> getUserSessions(RealmModel realm, ClientModel client) {
        return this.getUserSessions(realm, client, -1, -1);
    }

    public List<UserSessionModel> getUserSessions(RealmModel realm, ClientModel client, int firstResult, int maxResults) {
        DBObject query = new QueryBuilder().and("clientId").is((Object)client.getId()).and("sessionId").notEquals(null).get();
        BasicDBObject sort = new BasicDBObject("timestamp", (Object)1).append("id", (Object)1);
        List clientSessions = this.mongoStore.loadEntities(MongoClientSessionEntity.class, query, (DBObject)sort, firstResult, maxResults, this.invocationContext);
        LinkedList<UserSessionModel> result = new LinkedList<UserSessionModel>();
        for (MongoClientSessionEntity clientSession : clientSessions) {
            MongoUserSessionEntity userSession = (MongoUserSessionEntity)this.mongoStore.loadEntity(MongoUserSessionEntity.class, clientSession.getSessionId(), this.invocationContext);
            result.add(new UserSessionAdapter(this.session, this, userSession, realm, this.invocationContext));
        }
        return result;
    }

    public int getActiveUserSessions(RealmModel realm, ClientModel client) {
        DBObject query = new QueryBuilder().and("clientId").is((Object)client.getId()).and("sessionId").notEquals(null).get();
        return this.mongoStore.countEntities(MongoClientSessionEntity.class, query, this.invocationContext);
    }

    public void removeUserSession(RealmModel realm, UserSessionModel session) {
        this.mongoStore.removeEntity((MongoIdentifiableEntity)((UserSessionAdapter)session).getMongoEntity(), this.invocationContext);
    }

    public void removeUserSessions(RealmModel realm, UserModel user) {
        BasicDBObject query = new BasicDBObject("user", (Object)user.getId());
        this.mongoStore.removeEntities(MongoUserSessionEntity.class, (DBObject)query, this.invocationContext);
    }

    public void removeUserSessions(RealmModel realm) {
        BasicDBObject query = new BasicDBObject("realmId", (Object)realm.getId());
        this.mongoStore.removeEntities(MongoUserSessionEntity.class, (DBObject)query, this.invocationContext);
        query = new QueryBuilder().and("realmId").is((Object)realm.getId()).get();
        this.mongoStore.removeEntities(MongoClientSessionEntity.class, (DBObject)query, this.invocationContext);
    }

    public void removeExpiredUserSessions(RealmModel realm) {
        int currentTime = Time.currentTime();
        DBObject query = new QueryBuilder().and("realmId").is((Object)realm.getId()).and("started").lessThan((Object)(currentTime - realm.getSsoSessionMaxLifespan())).get();
        this.mongoStore.removeEntities(MongoUserSessionEntity.class, query, this.invocationContext);
        query = new QueryBuilder().and("realmId").is((Object)realm.getId()).and("lastSessionRefresh").lessThan((Object)(currentTime - realm.getSsoSessionIdleTimeout())).get();
        this.mongoStore.removeEntities(MongoUserSessionEntity.class, query, this.invocationContext);
        query = new QueryBuilder().and("sessionId").is(null).and("realmId").is((Object)realm.getId()).and("timestamp").lessThan((Object)(currentTime - RealmInfoUtil.getDettachedClientSessionLifespan((RealmModel)realm))).get();
        this.mongoStore.removeEntities(MongoClientSessionEntity.class, query, this.invocationContext);
    }

    public UsernameLoginFailureModel getUserLoginFailure(RealmModel realm, String username) {
        DBObject query = new QueryBuilder().and("username").is((Object)username).and("realmId").is((Object)realm.getId()).get();
        MongoUsernameLoginFailureEntity user = (MongoUsernameLoginFailureEntity)this.mongoStore.loadSingleEntity(MongoUsernameLoginFailureEntity.class, query, this.invocationContext);
        if (user == null) {
            return null;
        }
        return new UsernameLoginFailureAdapter(this.invocationContext, user);
    }

    public UsernameLoginFailureModel addUserLoginFailure(RealmModel realm, String username) {
        UsernameLoginFailureModel userLoginFailure = this.getUserLoginFailure(realm, username);
        if (userLoginFailure != null) {
            return userLoginFailure;
        }
        MongoUsernameLoginFailureEntity userEntity = new MongoUsernameLoginFailureEntity();
        userEntity.setUsername(username);
        userEntity.setRealmId(realm.getId());
        this.mongoStore.insertEntity((MongoIdentifiableEntity)userEntity, this.invocationContext);
        return new UsernameLoginFailureAdapter(this.invocationContext, userEntity);
    }

    public void onRealmRemoved(RealmModel realm) {
        this.removeUserSessions(realm);
    }

    public void onClientRemoved(RealmModel realm, ClientModel client) {
        DBObject query = new QueryBuilder().and("clientId").is((Object)client.getId()).get();
        BasicDBObject sort = new BasicDBObject("timestamp", (Object)1).append("id", (Object)1);
        List clientSessions = this.mongoStore.loadEntities(MongoClientSessionEntity.class, query, (DBObject)sort, -1, -1, this.invocationContext);
        for (MongoClientSessionEntity clientSession : clientSessions) {
            MongoUserSessionEntity userSession = (MongoUserSessionEntity)this.mongoStore.loadEntity(MongoUserSessionEntity.class, clientSession.getSessionId(), this.invocationContext);
            this.getMongoStore().pullItemFromList((MongoIdentifiableEntity)userSession, "clientSessions", (Object)clientSession.getId(), this.invocationContext);
            this.mongoStore.removeEntity((MongoIdentifiableEntity)clientSession, this.invocationContext);
        }
    }

    public void onUserRemoved(RealmModel realm, UserModel user) {
        this.removeUserSessions(realm, user);
        DBObject query = new QueryBuilder().or(new DBObject[]{new BasicDBObject("username", (Object)user.getUsername()), new BasicDBObject("username", (Object)user.getEmail())}).and("realmId").is((Object)realm.getId()).get();
        this.mongoStore.removeEntities(MongoUsernameLoginFailureEntity.class, query, this.invocationContext);
    }

    public void close() {
    }
}

