/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.jpa;

import java.util.LinkedList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientSessionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.UserSessionProvider;
import org.keycloak.models.UsernameLoginFailureModel;
import org.keycloak.models.sessions.jpa.ClientSessionAdapter;
import org.keycloak.models.sessions.jpa.UserSessionAdapter;
import org.keycloak.models.sessions.jpa.UsernameLoginFailureAdapter;
import org.keycloak.models.sessions.jpa.entities.ClientSessionEntity;
import org.keycloak.models.sessions.jpa.entities.UserSessionEntity;
import org.keycloak.models.sessions.jpa.entities.UserSessionNoteEntity;
import org.keycloak.models.sessions.jpa.entities.UsernameLoginFailureEntity;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.RealmInfoUtil;
import org.keycloak.util.Time;

public class JpaUserSessionProvider
implements UserSessionProvider {
    protected final KeycloakSession session;
    protected final EntityManager em;

    public JpaUserSessionProvider(KeycloakSession session, EntityManager em) {
        this.session = session;
        this.em = em;
    }

    public ClientSessionModel createClientSession(RealmModel realm, ClientModel client) {
        ClientSessionEntity entity = new ClientSessionEntity();
        entity.setId(KeycloakModelUtils.generateId());
        entity.setTimestamp(Time.currentTime());
        entity.setClientId(client.getId());
        entity.setRealmId(realm.getId());
        this.em.persist((Object)entity);
        return new ClientSessionAdapter(this.session, this.em, realm, entity);
    }

    public ClientSessionModel getClientSession(RealmModel realm, String id) {
        ClientSessionEntity clientSession = (ClientSessionEntity)this.em.find(ClientSessionEntity.class, (Object)id);
        if (clientSession != null && clientSession.getRealmId().equals(realm.getId())) {
            return new ClientSessionAdapter(this.session, this.em, realm, clientSession);
        }
        return null;
    }

    public ClientSessionModel getClientSession(String id) {
        ClientSessionEntity clientSession = (ClientSessionEntity)this.em.find(ClientSessionEntity.class, (Object)id);
        if (clientSession != null) {
            RealmModel realm = this.session.realms().getRealm(clientSession.getRealmId());
            return new ClientSessionAdapter(this.session, this.em, realm, clientSession);
        }
        return null;
    }

    public UsernameLoginFailureModel getUserLoginFailure(RealmModel realm, String username) {
        UsernameLoginFailureEntity entity = (UsernameLoginFailureEntity)this.em.find(UsernameLoginFailureEntity.class, (Object)new UsernameLoginFailureEntity.Key(realm.getId(), username));
        if (entity == null) {
            return null;
        }
        return new UsernameLoginFailureAdapter(entity);
    }

    public UsernameLoginFailureModel addUserLoginFailure(RealmModel realm, String username) {
        UsernameLoginFailureModel model = this.getUserLoginFailure(realm, username);
        if (model != null) {
            return model;
        }
        UsernameLoginFailureEntity entity = new UsernameLoginFailureEntity();
        entity.setUsername(username);
        entity.setRealmId(realm.getId());
        this.em.persist((Object)entity);
        return new UsernameLoginFailureAdapter(entity);
    }

    public UserSessionModel createUserSession(RealmModel realm, UserModel user, String loginUsername, String ipAddress, String authMethod, boolean rememberMe, String brokerSessionId, String brokerUserId) {
        UserSessionEntity entity = new UserSessionEntity();
        entity.setId(KeycloakModelUtils.generateId());
        entity.setRealmId(realm.getId());
        entity.setUserId(user.getId());
        entity.setLoginUsername(loginUsername);
        entity.setIpAddress(ipAddress);
        entity.setAuthMethod(authMethod);
        entity.setRememberMe(rememberMe);
        entity.setBrokerSessionId(brokerSessionId);
        entity.setBrokerUserId(brokerUserId);
        int currentTime = Time.currentTime();
        entity.setStarted(currentTime);
        entity.setLastSessionRefresh(currentTime);
        this.em.persist((Object)entity);
        return new UserSessionAdapter(this.session, this.em, realm, entity);
    }

    public UserSessionModel getUserSession(RealmModel realm, String id) {
        UserSessionEntity entity = (UserSessionEntity)this.em.find(UserSessionEntity.class, (Object)id);
        return entity != null ? new UserSessionAdapter(this.session, this.em, realm, entity) : null;
    }

    public List<UserSessionModel> getUserSessions(RealmModel realm, UserModel user) {
        LinkedList<UserSessionModel> sessions = new LinkedList<UserSessionModel>();
        TypedQuery query = this.em.createNamedQuery("getUserSessionByUser", UserSessionEntity.class).setParameter("realmId", (Object)realm.getId()).setParameter("userId", (Object)user.getId());
        for (UserSessionEntity e : query.getResultList()) {
            sessions.add(new UserSessionAdapter(this.session, this.em, realm, e));
        }
        return sessions;
    }

    public List<UserSessionModel> getUserSessionByBrokerUserId(RealmModel realm, String brokerUserId) {
        LinkedList<UserSessionModel> sessions = new LinkedList<UserSessionModel>();
        TypedQuery query = this.em.createNamedQuery("getUserSessionByBrokerUserId", UserSessionEntity.class).setParameter("realmId", (Object)realm.getId()).setParameter("brokerUserId", (Object)brokerUserId);
        for (UserSessionEntity e : query.getResultList()) {
            sessions.add(new UserSessionAdapter(this.session, this.em, realm, e));
        }
        return sessions;
    }

    public UserSessionModel getUserSessionByBrokerSessionId(RealmModel realm, String brokerSessionId) {
        LinkedList<UserSessionAdapter> sessions = new LinkedList<UserSessionAdapter>();
        TypedQuery query = this.em.createNamedQuery("getUserSessionByBrokerSessionId", UserSessionEntity.class).setParameter("realmId", (Object)realm.getId()).setParameter("brokerSessionId", (Object)brokerSessionId);
        for (UserSessionEntity e : query.getResultList()) {
            sessions.add(new UserSessionAdapter(this.session, this.em, realm, e));
        }
        if (sessions.isEmpty()) {
            return null;
        }
        return (UserSessionModel)sessions.get(0);
    }

    public List<UserSessionModel> getUserSessionsByNote(RealmModel realm, String noteName, String noteValue) {
        LinkedList<UserSessionModel> sessions = new LinkedList<UserSessionModel>();
        TypedQuery query = this.em.createNamedQuery("selectNoteByNameValue", UserSessionNoteEntity.class).setParameter("name", (Object)noteName).setParameter("value", (Object)noteValue);
        for (UserSessionNoteEntity note : query.getResultList()) {
            if (!note.getUserSession().getRealmId().equals(realm.getId())) continue;
            sessions.add(new UserSessionAdapter(this.session, this.em, realm, note.getUserSession()));
        }
        return sessions;
    }

    public List<UserSessionModel> getUserSessions(RealmModel realm, ClientModel client) {
        return this.getUserSessions(realm, client, -1, -1);
    }

    public List<UserSessionModel> getUserSessions(RealmModel realm, ClientModel client, int firstResult, int maxResults) {
        LinkedList<UserSessionModel> list = new LinkedList<UserSessionModel>();
        TypedQuery query = this.em.createNamedQuery("getUserSessionByClient", UserSessionEntity.class).setParameter("realmId", (Object)realm.getId()).setParameter("clientId", (Object)client.getId());
        if (firstResult != -1) {
            query.setFirstResult(firstResult);
        }
        if (maxResults != -1) {
            query.setMaxResults(maxResults);
        }
        for (UserSessionEntity entity : query.getResultList()) {
            list.add(new UserSessionAdapter(this.session, this.em, realm, entity));
        }
        return list;
    }

    public int getActiveUserSessions(RealmModel realm, ClientModel client) {
        Object count = this.em.createNamedQuery("getActiveUserSessionByClient").setParameter("realmId", (Object)realm.getId()).setParameter("clientId", (Object)client.getId()).getSingleResult();
        return ((Number)count).intValue();
    }

    public void removeUserSession(RealmModel realm, UserSessionModel session) {
        UserSessionEntity entity = (UserSessionEntity)this.em.find(UserSessionEntity.class, (Object)session.getId());
        if (entity != null) {
            for (ClientSessionEntity c : entity.getClientSessions()) {
                this.em.remove((Object)c);
            }
            this.em.remove((Object)entity);
        }
    }

    public void removeUserSessions(RealmModel realm, UserModel user) {
        this.em.createNamedQuery("removeClientSessionNoteByUser").setParameter("realmId", (Object)realm.getId()).setParameter("userId", (Object)user.getId()).executeUpdate();
        this.em.createNamedQuery("removeClientSessionRoleByUser").setParameter("realmId", (Object)realm.getId()).setParameter("userId", (Object)user.getId()).executeUpdate();
        this.em.createNamedQuery("removeClientSessionByUser").setParameter("realmId", (Object)realm.getId()).setParameter("userId", (Object)user.getId()).executeUpdate();
        this.em.createNamedQuery("removeUserSessionNoteByUser").setParameter("realmId", (Object)realm.getId()).setParameter("userId", (Object)user.getId()).executeUpdate();
        this.em.createNamedQuery("removeUserSessionByUser").setParameter("realmId", (Object)realm.getId()).setParameter("userId", (Object)user.getId()).executeUpdate();
    }

    public void removeExpiredUserSessions(RealmModel realm) {
        int maxTime = Time.currentTime() - realm.getSsoSessionMaxLifespan();
        int idleTime = Time.currentTime() - realm.getSsoSessionIdleTimeout();
        int dettachedClientSessionExpired = Time.currentTime() - RealmInfoUtil.getDettachedClientSessionLifespan((RealmModel)realm);
        this.em.createNamedQuery("removeDetachedClientSessionRoleByExpired").setParameter("realmId", (Object)realm.getId()).setParameter("maxTime", (Object)dettachedClientSessionExpired).executeUpdate();
        this.em.createNamedQuery("removeDetachedClientSessionNoteByExpired").setParameter("realmId", (Object)realm.getId()).setParameter("maxTime", (Object)dettachedClientSessionExpired).executeUpdate();
        this.em.createNamedQuery("removeDetachedClientSessionByExpired").setParameter("realmId", (Object)realm.getId()).setParameter("maxTime", (Object)dettachedClientSessionExpired).executeUpdate();
        this.em.createNamedQuery("removeClientSessionRoleByExpired").setParameter("realmId", (Object)realm.getId()).setParameter("maxTime", (Object)maxTime).setParameter("idleTime", (Object)idleTime).executeUpdate();
        this.em.createNamedQuery("removeClientSessionNoteByExpired").setParameter("realmId", (Object)realm.getId()).setParameter("maxTime", (Object)maxTime).setParameter("idleTime", (Object)idleTime).executeUpdate();
        this.em.createNamedQuery("removeClientSessionByExpired").setParameter("realmId", (Object)realm.getId()).setParameter("maxTime", (Object)maxTime).setParameter("idleTime", (Object)idleTime).executeUpdate();
        this.em.createNamedQuery("removeUserSessionNoteByExpired").setParameter("realmId", (Object)realm.getId()).setParameter("maxTime", (Object)maxTime).setParameter("idleTime", (Object)idleTime).executeUpdate();
        this.em.createNamedQuery("removeUserSessionByExpired").setParameter("realmId", (Object)realm.getId()).setParameter("maxTime", (Object)maxTime).setParameter("idleTime", (Object)idleTime).executeUpdate();
    }

    public void removeUserSessions(RealmModel realm) {
        this.em.createNamedQuery("removeClientSessionNoteByRealm").setParameter("realmId", (Object)realm.getId()).executeUpdate();
        this.em.createNamedQuery("removeClientSessionRoleByRealm").setParameter("realmId", (Object)realm.getId()).executeUpdate();
        this.em.createNamedQuery("removeClientSessionByRealm").setParameter("realmId", (Object)realm.getId()).executeUpdate();
        this.em.createNamedQuery("removeUserSessionNoteByRealm").setParameter("realmId", (Object)realm.getId()).executeUpdate();
        this.em.createNamedQuery("removeUserSessionByRealm").setParameter("realmId", (Object)realm.getId()).executeUpdate();
    }

    public void onRealmRemoved(RealmModel realm) {
        this.removeUserSessions(realm);
        this.em.createNamedQuery("removeLoginFailuresByRealm").setParameter("realmId", (Object)realm.getId()).executeUpdate();
    }

    public void onClientRemoved(RealmModel realm, ClientModel client) {
        this.em.createNamedQuery("removeClientSessionNoteByClient").setParameter("realmId", (Object)realm.getId()).setParameter("clientId", (Object)client.getId()).executeUpdate();
        this.em.createNamedQuery("removeClientSessionRoleByClient").setParameter("realmId", (Object)realm.getId()).setParameter("clientId", (Object)client.getId()).executeUpdate();
        this.em.createNamedQuery("removeClientSessionByClient").setParameter("realmId", (Object)realm.getId()).setParameter("clientId", (Object)client.getId()).executeUpdate();
    }

    public void onUserRemoved(RealmModel realm, UserModel user) {
        this.removeUserSessions(realm, user);
        this.em.createNamedQuery("removeLoginFailuresByUser").setParameter("realmId", (Object)realm.getId()).setParameter("username", (Object)user.getUsername()).setParameter("email", (Object)user.getEmail()).executeUpdate();
    }

    public void close() {
    }
}

