/*
 * Decompiled with CFR 0.152.
 */
package liquibase.diff;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import liquibase.database.Database;
import liquibase.diff.DiffGenerator;
import liquibase.diff.DiffResult;
import liquibase.diff.compare.CompareControl;
import liquibase.exception.DatabaseException;
import liquibase.exception.LiquibaseException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.servicelocator.ServiceLocator;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.snapshot.EmptyDatabaseSnapshot;
import liquibase.snapshot.InvalidExampleException;
import liquibase.snapshot.SnapshotControl;
import liquibase.snapshot.SnapshotGeneratorFactory;

public class DiffGeneratorFactory {
    private static DiffGeneratorFactory instance;
    private List<DiffGenerator> implementedGenerators = new ArrayList<DiffGenerator>();

    protected DiffGeneratorFactory() {
        try {
            Class<DiffGenerator>[] classes;
            for (Class<DiffGenerator> clazz : classes = ServiceLocator.getInstance().findClasses(DiffGenerator.class)) {
                this.register(clazz.getConstructor(new Class[0]).newInstance(new Object[0]));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static DiffGeneratorFactory getInstance() {
        if (instance == null) {
            instance = new DiffGeneratorFactory();
        }
        return instance;
    }

    public void register(DiffGenerator generator) {
        this.implementedGenerators.add(0, generator);
    }

    public DiffGenerator getGenerator(Database referenceDatabase, Database comparisonDatabase) {
        TreeSet<DiffGenerator> foundGenerators = new TreeSet<DiffGenerator>(new Comparator<DiffGenerator>(){

            @Override
            public int compare(DiffGenerator o1, DiffGenerator o2) {
                return -1 * new Integer(o1.getPriority()).compareTo(o2.getPriority());
            }
        });
        for (DiffGenerator diffGenerator : this.implementedGenerators) {
            if (!diffGenerator.supports(referenceDatabase, comparisonDatabase)) continue;
            foundGenerators.add(diffGenerator);
        }
        if (foundGenerators.size() == 0) {
            throw new UnexpectedLiquibaseException("Cannot find DiffGenerator for " + referenceDatabase.getShortName() + ", " + comparisonDatabase.getShortName());
        }
        try {
            return (DiffGenerator)((DiffGenerator)foundGenerators.iterator().next()).getClass().newInstance();
        }
        catch (Exception e) {
            throw new UnexpectedLiquibaseException(e);
        }
    }

    public DiffResult compare(Database referenceDatabase, Database comparisonDatabase, CompareControl compareControl) throws LiquibaseException {
        return this.compare(referenceDatabase, comparisonDatabase, new SnapshotControl(referenceDatabase), new SnapshotControl(comparisonDatabase), compareControl);
    }

    public DiffResult compare(Database referenceDatabase, Database comparisonDatabase, SnapshotControl referenceSnapshotControl, SnapshotControl comparisonSnapshotControl, CompareControl compareControl) throws LiquibaseException {
        DatabaseSnapshot referenceSnapshot = SnapshotGeneratorFactory.getInstance().createSnapshot(referenceDatabase.getDefaultSchema(), referenceDatabase, referenceSnapshotControl);
        DatabaseSnapshot comparisonSnapshot = null;
        comparisonSnapshot = comparisonDatabase == null ? new EmptyDatabaseSnapshot(referenceDatabase) : SnapshotGeneratorFactory.getInstance().createSnapshot(comparisonDatabase.getDefaultSchema(), comparisonDatabase, comparisonSnapshotControl);
        return this.getGenerator(referenceDatabase, comparisonDatabase).compare(referenceSnapshot, comparisonSnapshot, compareControl);
    }

    public DiffResult compare(DatabaseSnapshot referenceSnapshot, DatabaseSnapshot comparisonSnapshot, CompareControl compareControl) throws DatabaseException {
        Database comparisonDatabase;
        Database referenceDatabase = referenceSnapshot.getDatabase();
        if (comparisonSnapshot == null) {
            comparisonDatabase = referenceSnapshot.getDatabase();
            try {
                comparisonSnapshot = new EmptyDatabaseSnapshot(referenceDatabase, referenceSnapshot.getSnapshotControl());
            }
            catch (InvalidExampleException e) {
                throw new UnexpectedLiquibaseException(e);
            }
        } else {
            comparisonDatabase = comparisonSnapshot.getDatabase();
        }
        return this.getGenerator(referenceDatabase, comparisonDatabase).compare(referenceSnapshot, comparisonSnapshot, compareControl);
    }
}

