/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.jpa;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import org.keycloak.models.ApplicationModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.jpa.ClientAdapter;
import org.keycloak.models.jpa.RoleAdapter;
import org.keycloak.models.jpa.entities.ApplicationEntity;
import org.keycloak.models.jpa.entities.RoleEntity;
import org.keycloak.models.utils.KeycloakModelUtils;

public class ApplicationAdapter
extends ClientAdapter
implements ApplicationModel {
    protected EntityManager em;
    protected KeycloakSession session;
    protected ApplicationEntity applicationEntity;

    public ApplicationAdapter(RealmModel realm, EntityManager em, KeycloakSession session, ApplicationEntity applicationEntity) {
        super(realm, applicationEntity, em);
        this.session = session;
        this.realm = realm;
        this.em = em;
        this.applicationEntity = applicationEntity;
    }

    public void updateApplication() {
        this.em.flush();
    }

    public String getName() {
        return this.entity.getName();
    }

    public void setName(String name) {
        this.entity.setName(name);
    }

    public boolean isSurrogateAuthRequired() {
        return this.applicationEntity.isSurrogateAuthRequired();
    }

    public void setSurrogateAuthRequired(boolean surrogateAuthRequired) {
        this.applicationEntity.setSurrogateAuthRequired(surrogateAuthRequired);
    }

    public String getManagementUrl() {
        return this.applicationEntity.getManagementUrl();
    }

    public void setManagementUrl(String url) {
        this.applicationEntity.setManagementUrl(url);
    }

    public String getBaseUrl() {
        return this.applicationEntity.getBaseUrl();
    }

    public void setBaseUrl(String url) {
        this.applicationEntity.setBaseUrl(url);
    }

    public boolean isBearerOnly() {
        return this.applicationEntity.isBearerOnly();
    }

    public void setBearerOnly(boolean only) {
        this.applicationEntity.setBearerOnly(only);
    }

    public boolean isDirectGrantsOnly() {
        return false;
    }

    public void setDirectGrantsOnly(boolean flag) {
    }

    public RoleModel getRole(String name) {
        TypedQuery query = this.em.createNamedQuery("getAppRoleByName", RoleEntity.class);
        query.setParameter("name", (Object)name);
        query.setParameter("application", (Object)this.entity);
        List roles = query.getResultList();
        if (roles.size() == 0) {
            return null;
        }
        return new RoleAdapter(this.realm, this.em, (RoleEntity)roles.get(0));
    }

    public RoleModel addRole(String name) {
        return this.addRole(KeycloakModelUtils.generateId(), name);
    }

    public RoleModel addRole(String id, String name) {
        RoleEntity roleEntity = new RoleEntity();
        roleEntity.setId(id);
        roleEntity.setName(name);
        roleEntity.setApplication(this.applicationEntity);
        roleEntity.setApplicationRole(true);
        roleEntity.setRealmId(this.realm.getId());
        this.em.persist((Object)roleEntity);
        this.applicationEntity.getRoles().add(roleEntity);
        this.em.flush();
        return new RoleAdapter(this.realm, this.em, roleEntity);
    }

    public boolean removeRole(RoleModel roleModel) {
        if (roleModel == null) {
            return false;
        }
        if (!roleModel.getContainer().equals(this)) {
            return false;
        }
        this.session.users().preRemove(this.getRealm(), roleModel);
        RoleEntity role = RoleAdapter.toRoleEntity(roleModel, this.em);
        if (!role.isApplicationRole()) {
            return false;
        }
        this.applicationEntity.getRoles().remove(role);
        this.applicationEntity.getDefaultRoles().remove(role);
        this.em.createNativeQuery("delete from COMPOSITE_ROLE where CHILD_ROLE = :role").setParameter("role", (Object)role).executeUpdate();
        this.em.createNamedQuery("deleteScopeMappingByRole").setParameter("role", (Object)role).executeUpdate();
        role.setApplication(null);
        this.em.flush();
        this.em.remove((Object)role);
        this.em.flush();
        return true;
    }

    public Set<RoleModel> getRoles() {
        HashSet<RoleModel> list = new HashSet<RoleModel>();
        Collection<RoleEntity> roles = this.applicationEntity.getRoles();
        if (roles == null) {
            return list;
        }
        for (RoleEntity entity : roles) {
            list.add(new RoleAdapter(this.realm, this.em, entity));
        }
        return list;
    }

    @Override
    public boolean hasScope(RoleModel role) {
        if (super.hasScope(role)) {
            return true;
        }
        Set<RoleModel> roles = this.getRoles();
        if (roles.contains(role)) {
            return true;
        }
        for (RoleModel mapping : roles) {
            if (!mapping.hasRole(role)) continue;
            return true;
        }
        return false;
    }

    public Set<RoleModel> getApplicationScopeMappings(ClientModel client) {
        Set roleMappings = client.getScopeMappings();
        HashSet<RoleModel> appRoles = new HashSet<RoleModel>();
        for (RoleModel role : roleMappings) {
            ApplicationModel app;
            RoleContainerModel container = role.getContainer();
            if (container instanceof RealmModel || !(app = (ApplicationModel)container).getId().equals(this.getId())) continue;
            appRoles.add(role);
        }
        return appRoles;
    }

    public List<String> getDefaultRoles() {
        Collection<RoleEntity> entities = this.applicationEntity.getDefaultRoles();
        ArrayList<String> roles = new ArrayList<String>();
        if (entities == null) {
            return roles;
        }
        for (RoleEntity entity : entities) {
            roles.add(entity.getName());
        }
        return roles;
    }

    public void addDefaultRole(String name) {
        RoleModel role = this.getRole(name);
        if (role == null) {
            role = this.addRole(name);
        }
        Collection<RoleEntity> entities = this.applicationEntity.getDefaultRoles();
        for (RoleEntity entity : entities) {
            if (!entity.getId().equals(role.getId())) continue;
            return;
        }
        RoleEntity roleEntity = RoleAdapter.toRoleEntity(role, this.em);
        entities.add(roleEntity);
        this.em.flush();
    }

    public void updateDefaultRoles(String[] defaultRoles) {
        Collection<RoleEntity> entities = this.applicationEntity.getDefaultRoles();
        HashSet<String> already = new HashSet<String>();
        ArrayList<RoleEntity> remove = new ArrayList<RoleEntity>();
        for (RoleEntity rel : entities) {
            if (!ApplicationAdapter.contains(rel.getName(), defaultRoles)) {
                remove.add(rel);
                continue;
            }
            already.add(rel.getName());
        }
        for (RoleEntity entity : remove) {
            entities.remove(entity);
        }
        this.em.flush();
        for (String roleName : defaultRoles) {
            if (already.contains(roleName)) continue;
            this.addDefaultRole(roleName);
        }
        this.em.flush();
    }

    public int getNodeReRegistrationTimeout() {
        return this.applicationEntity.getNodeReRegistrationTimeout();
    }

    public void setNodeReRegistrationTimeout(int timeout) {
        this.applicationEntity.setNodeReRegistrationTimeout(timeout);
    }

    public Map<String, Integer> getRegisteredNodes() {
        return this.applicationEntity.getRegisteredNodes();
    }

    public void registerNode(String nodeHost, int registrationTime) {
        Map<String, Integer> currentNodes = this.getRegisteredNodes();
        currentNodes.put(nodeHost, registrationTime);
        this.em.flush();
    }

    public void unregisterNode(String nodeHost) {
        Map<String, Integer> currentNodes = this.getRegisteredNodes();
        currentNodes.remove(nodeHost);
        this.em.flush();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof ApplicationModel)) {
            return false;
        }
        ApplicationModel that = (ApplicationModel)o;
        return that.getId().equals(this.getId());
    }

    @Override
    public int hashCode() {
        return this.getId().hashCode();
    }

    public String toString() {
        return this.getName();
    }

    ApplicationEntity getJpaEntity() {
        return this.applicationEntity;
    }
}

