/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.managers;

import java.util.Map;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.jboss.resteasy.spi.HttpRequest;
import org.keycloak.ClientConnection;
import org.keycloak.events.EventBuilder;
import org.keycloak.login.LoginFormsProvider;
import org.keycloak.models.ClientSessionModel;
import org.keycloak.models.CredentialValidationOutput;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RequiredCredentialModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.oidc.TokenManager;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.resources.flows.Flows;

public class HttpAuthenticationManager {
    private static final Logger logger = Logger.getLogger(HttpAuthenticationManager.class);
    private KeycloakSession session;
    private RealmModel realm;
    private UriInfo uriInfo;
    private HttpRequest request;
    private EventBuilder event;
    private ClientConnection clientConnection;
    private ClientSessionModel clientSession;

    public HttpAuthenticationManager(KeycloakSession session, ClientSessionModel clientSession, RealmModel realm, UriInfo uriInfo, HttpRequest request, ClientConnection clientConnection, EventBuilder event) {
        this.session = session;
        this.realm = realm;
        this.uriInfo = uriInfo;
        this.request = request;
        this.event = event;
        this.clientConnection = clientConnection;
        this.clientSession = clientSession;
    }

    public HttpAuthOutput spnegoAuthenticate(HttpHeaders headers) {
        boolean kerberosSupported = false;
        for (RequiredCredentialModel c : this.realm.getRequiredCredentials()) {
            if (!c.getType().equals("kerberos")) continue;
            kerberosSupported = true;
        }
        if (logger.isTraceEnabled()) {
            String log = kerberosSupported ? "SPNEGO authentication is supported" : "SPNEGO authentication is not supported";
            logger.trace((Object)log);
        }
        if (!kerberosSupported) {
            return new HttpAuthOutput(null, null);
        }
        String authHeader = (String)this.request.getHttpHeaders().getRequestHeaders().getFirst((Object)"Authorization");
        if (authHeader == null) {
            return this.challengeNegotiation(null);
        }
        String[] tokens = authHeader.split(" ");
        if (tokens.length != 2) {
            logger.warn((Object)("Invalid length of tokens: " + tokens.length));
            return this.challengeNegotiation(null);
        }
        if (!"Negotiate".equalsIgnoreCase(tokens[0])) {
            logger.warn((Object)("Unknown scheme " + tokens[0]));
            return this.challengeNegotiation(null);
        }
        String spnegoToken = tokens[1];
        UserCredentialModel spnegoCredential = UserCredentialModel.kerberos((String)spnegoToken);
        CredentialValidationOutput output = this.session.users().validCredentials(this.realm, new UserCredentialModel[]{spnegoCredential});
        if (output.getAuthStatus() == CredentialValidationOutput.Status.AUTHENTICATED) {
            return this.sendResponse(output.getAuthenticatedUser(), output.getState(), "spnego", headers);
        }
        String spnegoResponseToken = (String)output.getState().get("SpnegoResponseToken");
        return this.challengeNegotiation(spnegoResponseToken);
    }

    private HttpAuthOutput sendResponse(UserModel user, Map<String, String> authState, String authMethod, HttpHeaders headers) {
        Response response;
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("User " + user.getUsername() + " authenticated with " + authMethod));
        }
        if (!user.isEnabled()) {
            this.event.error("user_disabled");
            response = Flows.forwardToSecurityFailurePage(this.session, this.realm, this.uriInfo, headers, "accountDisabledMessage", new Object[0]);
        } else {
            UserSessionModel userSession = this.session.sessions().createUserSession(this.realm, user, user.getUsername(), this.clientConnection.getRemoteAddr(), authMethod, false, null, null);
            for (Map.Entry<String, String> entry : authState.entrySet()) {
                userSession.setNote(entry.getKey(), entry.getValue());
            }
            TokenManager.attachClientSession(userSession, this.clientSession);
            this.event.user(user).session(userSession).detail("auth_method", authMethod).detail("username", user.getUsername());
            response = AuthenticationManager.nextActionAfterAuthentication(this.session, userSession, this.clientSession, this.clientConnection, this.request, this.uriInfo, this.event);
        }
        return new HttpAuthOutput(response, null);
    }

    private HttpAuthOutput challengeNegotiation(final String negotiateToken) {
        return new HttpAuthOutput(null, new HttpAuthChallenge(){

            @Override
            public void sendChallenge(LoginFormsProvider loginFormsProvider) {
                String negotiateHeader;
                String string = negotiateHeader = negotiateToken == null ? "Negotiate" : "Negotiate " + negotiateToken;
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Sending back WWW-Authenticate: " + negotiateHeader));
                }
                loginFormsProvider.setStatus(Response.Status.UNAUTHORIZED);
                loginFormsProvider.setResponseHeader("WWW-Authenticate", negotiateHeader);
            }
        });
    }

    public static interface HttpAuthChallenge {
        public void sendChallenge(LoginFormsProvider var1);
    }

    public class HttpAuthOutput {
        private final Response response;
        private final HttpAuthChallenge challenge;

        public HttpAuthOutput(Response response, HttpAuthChallenge challenge) {
            this.response = response;
            this.challenge = challenge;
        }

        public Response getResponse() {
            return this.response;
        }

        public HttpAuthChallenge getChallenge() {
            return this.challenge;
        }
    }
}

