/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.broker.oidc;

import java.io.IOException;
import java.security.PublicKey;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.codehaus.jackson.JsonNode;
import org.jboss.logging.Logger;
import org.keycloak.ClientConnection;
import org.keycloak.broker.oidc.AbstractOAuth2IdentityProvider;
import org.keycloak.broker.oidc.OIDCIdentityProviderConfig;
import org.keycloak.broker.oidc.util.SimpleHttp;
import org.keycloak.broker.provider.AuthenticationRequest;
import org.keycloak.broker.provider.FederatedIdentity;
import org.keycloak.broker.provider.IdentityBrokerException;
import org.keycloak.broker.provider.IdentityProvider;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.jose.jws.crypto.RSAProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.representations.AccessTokenResponse;
import org.keycloak.representations.IDToken;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.resources.IdentityBrokerService;
import org.keycloak.services.resources.RealmsResource;
import org.keycloak.services.resources.flows.Flows;
import org.keycloak.util.JsonSerialization;
import org.keycloak.util.PemUtils;

public class OIDCIdentityProvider
extends AbstractOAuth2IdentityProvider<OIDCIdentityProviderConfig> {
    protected static final Logger logger = Logger.getLogger(OIDCIdentityProvider.class);
    public static final String OAUTH2_PARAMETER_PROMPT = "prompt";
    public static final String SCOPE_OPENID = "openid";
    public static final String FEDERATED_ID_TOKEN = "FEDERATED_ID_TOKEN";

    public OIDCIdentityProvider(OIDCIdentityProviderConfig config) {
        super(config);
        String defaultScope = config.getDefaultScope();
        if (!defaultScope.contains(SCOPE_OPENID)) {
            config.setDefaultScope("openid " + defaultScope);
        }
    }

    @Override
    public Object callback(RealmModel realm, IdentityProvider.AuthenticationCallback callback, EventBuilder event) {
        return new OIDCEndpoint(callback, realm, event);
    }

    protected PublicKey getExternalIdpKey() {
        String signingCert = ((OIDCIdentityProviderConfig)this.getConfig()).getCertificateSignatureVerifier();
        try {
            if (signingCert != null && !signingCert.trim().equals("")) {
                return PemUtils.decodeCertificate((String)signingCert).getPublicKey();
            }
            if (((OIDCIdentityProviderConfig)this.getConfig()).getPublicKeySignatureVerifier() != null && !((OIDCIdentityProviderConfig)this.getConfig()).getPublicKeySignatureVerifier().trim().equals("")) {
                return PemUtils.decodePublicKey((String)((OIDCIdentityProviderConfig)this.getConfig()).getPublicKeySignatureVerifier());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    protected boolean verify(JWSInput jws, PublicKey key) {
        if (key == null) {
            return true;
        }
        if (!((OIDCIdentityProviderConfig)this.getConfig()).isValidateSignature()) {
            return true;
        }
        return RSAProvider.verify((JWSInput)jws, (PublicKey)key);
    }

    public Response keycloakInitiatedBrowserLogout(UserSessionModel userSession, UriInfo uriInfo, RealmModel realm) {
        if (((OIDCIdentityProviderConfig)this.getConfig()).getLogoutUrl() == null || ((OIDCIdentityProviderConfig)this.getConfig()).getLogoutUrl().trim().equals("")) {
            return null;
        }
        UriBuilder logoutUri = UriBuilder.fromUri((String)((OIDCIdentityProviderConfig)this.getConfig()).getLogoutUrl()).queryParam("state", new Object[]{userSession.getId()});
        String idToken = userSession.getNote(FEDERATED_ID_TOKEN);
        if (idToken != null) {
            logoutUri.queryParam("id_token_hint", new Object[]{idToken});
        }
        String redirect = RealmsResource.brokerUrl((UriInfo)uriInfo).path(IdentityBrokerService.class, "getEndpoint").path(OIDCEndpoint.class, "logoutResponse").build(new Object[]{realm.getName(), ((OIDCIdentityProviderConfig)this.getConfig()).getAlias()}).toString();
        logoutUri.queryParam("post_logout_redirect_uri", new Object[]{redirect});
        return Response.status((int)302).location(logoutUri.build(new Object[0])).build();
    }

    @Override
    protected UriBuilder createAuthorizationUrl(AuthenticationRequest request) {
        UriBuilder authorizationUrl = super.createAuthorizationUrl(request);
        String prompt = ((OIDCIdentityProviderConfig)this.getConfig()).getPrompt();
        if (prompt != null && !prompt.isEmpty()) {
            authorizationUrl.queryParam(OAUTH2_PARAMETER_PROMPT, new Object[]{prompt});
        }
        return authorizationUrl;
    }

    @Override
    protected FederatedIdentity getFederatedIdentity(Map<String, String> notes, String response) {
        AccessTokenResponse tokenResponse = null;
        try {
            tokenResponse = (AccessTokenResponse)JsonSerialization.readValue((String)response, AccessTokenResponse.class);
        }
        catch (IOException e) {
            throw new IdentityBrokerException("Could not decode access token response.", (Throwable)e);
        }
        PublicKey key = this.getExternalIdpKey();
        String accessToken = this.verifyAccessToken(key, tokenResponse);
        String encodedIdToken = tokenResponse.getIdToken();
        notes.put("FEDERATED_ACCESS_TOKEN", accessToken);
        notes.put(FEDERATED_ID_TOKEN, encodedIdToken);
        notes.put("FEDERATED_REFRESH_TOKEN", tokenResponse.getRefreshToken());
        notes.put("FEDERATED_TOKEN_EXPIRATION", Long.toString(tokenResponse.getExpiresIn()));
        IDToken idToken = this.validateIdToken(key, encodedIdToken);
        try {
            String id = idToken.getSubject();
            String name = idToken.getName();
            String preferredUsername = idToken.getPreferredUsername();
            String email = idToken.getEmail();
            if (id == null || name == null || preferredUsername == null || email == null && ((OIDCIdentityProviderConfig)this.getConfig()).getUserInfoUrl() != null) {
                JsonNode userInfo = SimpleHttp.doGet(((OIDCIdentityProviderConfig)this.getConfig()).getUserInfoUrl()).header("Authorization", "Bearer " + accessToken).asJson();
                id = this.getJsonProperty(userInfo, "sub");
                name = this.getJsonProperty(userInfo, "name");
                preferredUsername = this.getJsonProperty(userInfo, "preferred_username");
                email = this.getJsonProperty(userInfo, "email");
            }
            FederatedIdentity identity = new FederatedIdentity(id);
            identity.setId(id);
            identity.setName(name);
            identity.setEmail(email);
            identity.setBrokerUserId(((OIDCIdentityProviderConfig)this.getConfig()).getAlias() + "." + id);
            if (tokenResponse.getSessionState() != null) {
                identity.setBrokerSessionId(((OIDCIdentityProviderConfig)this.getConfig()).getAlias() + "." + tokenResponse.getSessionState());
            }
            if (preferredUsername == null) {
                preferredUsername = email;
            }
            if (preferredUsername == null) {
                preferredUsername = id;
            }
            identity.setUsername(preferredUsername);
            if (((OIDCIdentityProviderConfig)this.getConfig()).isStoreToken()) {
                identity.setToken(response);
            }
            return identity;
        }
        catch (Exception e) {
            throw new IdentityBrokerException("Could not fetch attributes from userinfo endpoint.", (Throwable)e);
        }
    }

    private String verifyAccessToken(PublicKey key, AccessTokenResponse tokenResponse) {
        String accessToken = tokenResponse.getToken();
        if (accessToken == null) {
            throw new IdentityBrokerException("No access_token from server.");
        }
        return accessToken;
    }

    private IDToken validateIdToken(PublicKey key, String encodedToken) {
        if (encodedToken == null) {
            throw new IdentityBrokerException("No id_token from server.");
        }
        try {
            JWSInput jws = new JWSInput(encodedToken);
            if (!this.verify(jws, key)) {
                throw new IdentityBrokerException("IDToken signature validation failed");
            }
            IDToken idToken = (IDToken)jws.readJsonContent(IDToken.class);
            String aud = idToken.getAudience();
            String iss = idToken.getIssuer();
            if (aud != null && !aud.equals(((OIDCIdentityProviderConfig)this.getConfig()).getClientId())) {
                throw new IdentityBrokerException("Wrong audience from id_token..");
            }
            String trustedIssuers = ((OIDCIdentityProviderConfig)this.getConfig()).getIssuer();
            if (trustedIssuers != null) {
                String[] issuers;
                for (String trustedIssuer : issuers = trustedIssuers.split(",")) {
                    if (iss == null || !iss.equals(trustedIssuer.trim())) continue;
                    return idToken;
                }
                throw new IdentityBrokerException("Wrong issuer from id_token. Got: " + iss + " expected: " + ((OIDCIdentityProviderConfig)this.getConfig()).getIssuer());
            }
            return idToken;
        }
        catch (IOException e) {
            throw new IdentityBrokerException("Could not decode id token.", (Throwable)e);
        }
    }

    @Override
    protected String getDefaultScopes() {
        return SCOPE_OPENID;
    }

    protected class OIDCEndpoint
    extends AbstractOAuth2IdentityProvider.Endpoint {
        public OIDCEndpoint(IdentityProvider.AuthenticationCallback callback, RealmModel realm, EventBuilder event) {
            super(OIDCIdentityProvider.this, callback, realm, event);
        }

        @GET
        @Path(value="logout_response")
        public Response logoutResponse(@Context UriInfo uriInfo, @QueryParam(value="state") String state) {
            UserSessionModel userSession = this.session.sessions().getUserSession(this.realm, state);
            if (userSession == null) {
                logger.error((Object)"no valid user session");
                EventBuilder event = new EventBuilder(this.realm, this.session, this.clientConnection);
                event.event(EventType.LOGOUT);
                event.error("user_session_not_found");
                return Flows.forwardToSecurityFailurePage((KeycloakSession)this.session, (RealmModel)this.realm, (UriInfo)uriInfo, (HttpHeaders)this.headers, (String)"identityProviderUnexpectedErrorMessage", (Object[])new Object[0]);
            }
            if (userSession.getState() != UserSessionModel.State.LOGGING_OUT) {
                logger.error((Object)"usersession in different state");
                EventBuilder event = new EventBuilder(this.realm, this.session, this.clientConnection);
                event.event(EventType.LOGOUT);
                event.error("user_session_not_found");
                return Flows.forwardToSecurityFailurePage((KeycloakSession)this.session, (RealmModel)this.realm, (UriInfo)uriInfo, (HttpHeaders)this.headers, (String)"sessionNotActiveMessage", (Object[])new Object[0]);
            }
            return AuthenticationManager.finishBrowserLogout((KeycloakSession)this.session, (RealmModel)this.realm, (UserSessionModel)userSession, (UriInfo)uriInfo, (ClientConnection)this.clientConnection, (HttpHeaders)this.headers);
        }
    }
}

