/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.saml;

import java.net.URI;
import javax.xml.datatype.XMLGregorianCalendar;
import org.keycloak.protocol.saml.SAML2BindingBuilder;
import org.picketlink.common.exceptions.ConfigurationException;
import org.picketlink.common.exceptions.ParsingException;
import org.picketlink.common.exceptions.ProcessingException;
import org.picketlink.identity.federation.api.saml.v2.request.SAML2Request;
import org.picketlink.identity.federation.core.saml.v2.util.XMLTimeUtil;
import org.picketlink.identity.federation.core.sts.PicketLinkCoreSTS;
import org.picketlink.identity.federation.saml.v2.assertion.NameIDType;
import org.picketlink.identity.federation.saml.v2.protocol.LogoutRequestType;
import org.picketlink.identity.federation.saml.v2.protocol.RequestAbstractType;
import org.w3c.dom.Document;

public class SAML2LogoutRequestBuilder
extends SAML2BindingBuilder<SAML2LogoutRequestBuilder> {
    protected String userPrincipal;
    protected String userPrincipalFormat;
    protected String sessionIndex;

    public SAML2LogoutRequestBuilder userPrincipal(String nameID, String nameIDformat) {
        this.userPrincipal = nameID;
        this.userPrincipalFormat = nameIDformat;
        return this;
    }

    public SAML2LogoutRequestBuilder sessionIndex(String index) {
        this.sessionIndex = index;
        return this;
    }

    public SAML2BindingBuilder.RedirectBindingBuilder redirectBinding() throws ConfigurationException, ProcessingException, ParsingException {
        Document samlResponseDocument = this.buildDocument();
        return new SAML2BindingBuilder.RedirectBindingBuilder(this, samlResponseDocument);
    }

    public SAML2BindingBuilder.PostBindingBuilder postBinding() throws ConfigurationException, ProcessingException, ParsingException {
        Document samlResponseDocument = this.buildDocument();
        return new SAML2BindingBuilder.PostBindingBuilder(this, samlResponseDocument);
    }

    public Document buildDocument() throws ProcessingException, ConfigurationException, ParsingException {
        Document document = new SAML2Request().convert((RequestAbstractType)this.createLogoutRequest());
        if (this.encrypt) {
            this.encryptDocument(document);
        }
        return document;
    }

    private LogoutRequestType createLogoutRequest() throws ConfigurationException {
        LogoutRequestType lort = new SAML2Request().createLogoutRequest(this.issuer);
        NameIDType nameID = new NameIDType();
        nameID.setValue(this.userPrincipal);
        String nameIDFormat = this.userPrincipalFormat;
        nameID.setFormat(URI.create(nameIDFormat));
        lort.setNameID(nameID);
        if (this.issuer != null) {
            NameIDType issuerID = new NameIDType();
            issuerID.setValue(this.issuer);
            lort.setIssuer(issuerID);
        }
        if (this.sessionIndex != null) {
            lort.addSessionIndex(this.sessionIndex);
        }
        long assertionValidity = PicketLinkCoreSTS.instance().getConfiguration().getIssuedTokenTimeout();
        lort.setNotOnOrAfter(XMLTimeUtil.add((XMLGregorianCalendar)lort.getIssueInstant(), (long)assertionValidity));
        lort.setDestination(URI.create(this.destination));
        return lort;
    }
}

