/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import javax.security.cert.X509Certificate;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.keycloak.KeycloakSecurityContext;
import org.keycloak.adapters.AdapterDeploymentContext;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.OIDCHttpFacade;
import org.keycloak.adapters.ServerRequest;
import org.keycloak.adapters.spi.AuthenticationError;
import org.keycloak.adapters.spi.HttpFacade;
import org.keycloak.adapters.spi.LogoutError;
import org.keycloak.common.util.KeycloakUriBuilder;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.jose.jws.JWSInputException;
import org.keycloak.representations.AccessTokenResponse;
import org.keycloak.representations.IDToken;
import org.keycloak.servlet.KeycloakDeploymentDelegateOAuthClient;

public class ServletOAuthClient
extends KeycloakDeploymentDelegateOAuthClient {
    public void stop() {
        this.getDeployment().getClient().getConnectionManager().shutdown();
    }

    private AccessTokenResponse resolveBearerToken(HttpServletRequest request, String redirectUri, String code) throws IOException, ServerRequest.HttpFailure {
        KeycloakDeployment resolvedDeployment = this.resolveDeployment(this.getDeployment(), request);
        return ServerRequest.invokeAccessCodeToToken((KeycloakDeployment)resolvedDeployment, (String)code, (String)redirectUri, null);
    }

    public void redirectRelative(String relativePath, HttpServletRequest request, HttpServletResponse response) throws IOException {
        KeycloakUriBuilder builder = KeycloakUriBuilder.fromUri((String)request.getRequestURL().toString()).replacePath(request.getContextPath()).replaceQuery(null).path(relativePath);
        String redirect = builder.toTemplate();
        this.redirect(redirect, request, response);
    }

    public void redirect(String redirectUri, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String state = this.getStateCode();
        KeycloakDeployment resolvedDeployment = this.resolveDeployment(this.getDeployment(), request);
        String authUrl = resolvedDeployment.getAuthUrl().clone().build(new Object[0]).toString();
        KeycloakUriBuilder uriBuilder = KeycloakUriBuilder.fromUri((String)authUrl).queryParam("response_type", new Object[]{"code"}).queryParam("client_id", new Object[]{this.getClientId()}).queryParam("redirect_uri", new Object[]{redirectUri}).queryParam("state", new Object[]{state});
        if (this.scope != null) {
            uriBuilder.queryParam("scope", new Object[]{this.scope});
        }
        URI url = uriBuilder.build(new Object[0]);
        String stateCookiePath = this.stateCookiePath;
        if (stateCookiePath == null) {
            stateCookiePath = request.getContextPath();
        }
        if (stateCookiePath.equals("")) {
            stateCookiePath = "/";
        }
        Cookie cookie = new Cookie(this.stateCookieName, state);
        cookie.setSecure(this.isSecure);
        cookie.setPath(stateCookiePath);
        response.addCookie(cookie);
        response.sendRedirect(url.toString());
    }

    protected String getCookieValue(String name, HttpServletRequest request) {
        if (request.getCookies() == null) {
            return null;
        }
        for (Cookie cookie : request.getCookies()) {
            if (!cookie.getName().equals(name)) continue;
            return cookie.getValue();
        }
        return null;
    }

    protected String getCode(HttpServletRequest request) {
        String[] params;
        String query = request.getQueryString();
        if (query == null) {
            return null;
        }
        for (String param : params = query.split("&")) {
            String name;
            int eq = param.indexOf(61);
            if (eq == -1 || !(name = param.substring(0, eq)).equals("code")) continue;
            return param.substring(eq + 1);
        }
        return null;
    }

    public AccessTokenResponse getBearerToken(HttpServletRequest request) throws IOException, ServerRequest.HttpFailure {
        String error = request.getParameter("error");
        if (error != null) {
            throw new IOException("OAuth error: " + error);
        }
        String redirectUri = request.getRequestURL().append("?").append(request.getQueryString()).toString();
        String stateCookie = this.getCookieValue(this.stateCookieName, request);
        if (stateCookie == null) {
            throw new IOException("state cookie not set");
        }
        String state = request.getParameter("state");
        String code = request.getParameter("code");
        if (state == null) {
            throw new IOException("state parameter was null");
        }
        if (!state.equals(stateCookie)) {
            throw new IOException("state parameter invalid");
        }
        if (code == null) {
            throw new IOException("code parameter was null");
        }
        return this.resolveBearerToken(request, redirectUri, code);
    }

    public AccessTokenResponse refreshToken(HttpServletRequest request, String refreshToken) throws IOException, ServerRequest.HttpFailure {
        KeycloakDeployment resolvedDeployment = this.resolveDeployment(this.getDeployment(), request);
        return ServerRequest.invokeRefresh((KeycloakDeployment)resolvedDeployment, (String)refreshToken);
    }

    public static IDToken extractIdToken(String idToken) {
        if (idToken == null) {
            return null;
        }
        try {
            JWSInput input = new JWSInput(idToken);
            return (IDToken)input.readJsonContent(IDToken.class);
        }
        catch (JWSInputException e) {
            throw new RuntimeException(e);
        }
    }

    private KeycloakDeployment resolveDeployment(KeycloakDeployment baseDeployment, HttpServletRequest request) {
        ServletFacade facade = new ServletFacade(request);
        return new AdapterDeploymentContext(baseDeployment).resolveDeployment((HttpFacade)facade);
    }

    public static class ServletFacade
    implements OIDCHttpFacade {
        private final HttpServletRequest servletRequest;

        private ServletFacade(HttpServletRequest servletRequest) {
            this.servletRequest = servletRequest;
        }

        public KeycloakSecurityContext getSecurityContext() {
            throw new IllegalStateException("Not yet implemented");
        }

        public HttpFacade.Request getRequest() {
            return new HttpFacade.Request(){

                public String getFirstParam(String param) {
                    return ServletFacade.this.servletRequest.getParameter(param);
                }

                public String getMethod() {
                    return ServletFacade.this.servletRequest.getMethod();
                }

                public String getURI() {
                    return ServletFacade.this.servletRequest.getRequestURL().toString();
                }

                public boolean isSecure() {
                    return ServletFacade.this.servletRequest.isSecure();
                }

                public String getQueryParamValue(String param) {
                    return ServletFacade.this.servletRequest.getParameter(param);
                }

                public HttpFacade.Cookie getCookie(String cookieName) {
                    return null;
                }

                public String getHeader(String name) {
                    return ServletFacade.this.servletRequest.getHeader(name);
                }

                public List<String> getHeaders(String name) {
                    return null;
                }

                public InputStream getInputStream() {
                    try {
                        return ServletFacade.this.servletRequest.getInputStream();
                    }
                    catch (IOException ioe) {
                        throw new RuntimeException(ioe);
                    }
                }

                public String getRemoteAddr() {
                    return ServletFacade.this.servletRequest.getRemoteAddr();
                }

                public void setError(AuthenticationError error) {
                    ServletFacade.this.servletRequest.setAttribute(AuthenticationError.class.getName(), (Object)error);
                }

                public void setError(LogoutError error) {
                    ServletFacade.this.servletRequest.setAttribute(LogoutError.class.getName(), (Object)error);
                }
            };
        }

        public HttpFacade.Response getResponse() {
            throw new IllegalStateException("Not yet implemented");
        }

        public X509Certificate[] getCertificateChain() {
            throw new IllegalStateException("Not yet implemented");
        }
    }
}

