/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.representations.adapters.config;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PolicyEnforcerConfig {
    @JsonProperty(value="create-resources")
    private Boolean createResources;
    @JsonProperty(value="enforcement-mode")
    private EnforcementMode enforcementMode = EnforcementMode.ENFORCING;
    @JsonProperty(value="user-managed-access")
    private UmaProtocolConfig umaProtocolConfig;
    @JsonProperty(value="entitlement")
    private EntitlementProtocolConfig entitlementProtocolConfig;
    @JsonProperty(value="paths")
    private List<PathConfig> paths = new ArrayList<PathConfig>();
    @JsonProperty(value="online-introspection")
    private Boolean onlineIntrospection;
    @JsonProperty(value="on-deny-redirect-to")
    private String accessDeniedPath;

    public Boolean isCreateResources() {
        return this.createResources;
    }

    public List<PathConfig> getPaths() {
        if (this.paths == null) {
            return null;
        }
        return Collections.unmodifiableList(this.paths);
    }

    public EnforcementMode getEnforcementMode() {
        return this.enforcementMode;
    }

    public void setEnforcementMode(EnforcementMode enforcementMode) {
        this.enforcementMode = enforcementMode;
    }

    public UmaProtocolConfig getUmaProtocolConfig() {
        return this.umaProtocolConfig;
    }

    public EntitlementProtocolConfig getEntitlementProtocolConfig() {
        return this.entitlementProtocolConfig;
    }

    public Boolean isOnlineIntrospection() {
        return this.onlineIntrospection;
    }

    public void setPaths(List<PathConfig> paths) {
        this.paths = paths;
    }

    public String getAccessDeniedPath() {
        return this.accessDeniedPath;
    }

    public static class EntitlementProtocolConfig {
    }

    public static class UmaProtocolConfig {
    }

    public static enum EnforcementMode {
        PERMISSIVE,
        ENFORCING,
        DISABLED;

    }

    public static class MethodConfig {
        private String method;
        private List<String> scopes = Collections.emptyList();

        public String getMethod() {
            return this.method;
        }

        public void setMethod(String method) {
            this.method = method;
        }

        public List<String> getScopes() {
            return this.scopes;
        }

        public void setScopes(List<String> scopes) {
            this.scopes = scopes;
        }
    }

    public static class PathConfig {
        private String name;
        private String type;
        private String path;
        private List<MethodConfig> methods = new ArrayList<MethodConfig>();
        private List<String> scopes = Collections.emptyList();
        private String id;
        private boolean instance;
        @JsonIgnore
        private PathConfig parentConfig;

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public List<String> getScopes() {
            return this.scopes;
        }

        public void setScopes(List<String> scopes) {
            this.scopes = scopes;
        }

        public List<MethodConfig> getMethods() {
            return this.methods;
        }

        public void setMethods(List<MethodConfig> methods) {
            this.methods = methods;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public String toString() {
            return "PathConfig{name='" + this.name + '\'' + ", type='" + this.type + '\'' + ", path='" + this.path + '\'' + ", scopes=" + this.scopes + ", id='" + this.id + '\'' + '}';
        }

        public boolean hasPattern() {
            return this.getPath().indexOf("{") != -1;
        }

        public boolean isInstance() {
            return this.instance;
        }

        public void setInstance(boolean instance) {
            this.instance = instance;
        }

        public void setParentConfig(PathConfig parentConfig) {
            this.parentConfig = parentConfig;
        }

        public PathConfig getParentConfig() {
            return this.parentConfig;
        }
    }
}

