/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.undertow;

import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.Cookie;
import io.undertow.server.handlers.CookieImpl;
import io.undertow.util.AttachmentKey;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import javax.security.cert.X509Certificate;
import org.keycloak.adapters.spi.AuthenticationError;
import org.keycloak.adapters.spi.HttpFacade;
import org.keycloak.adapters.spi.LogoutError;
import org.keycloak.common.util.KeycloakUriBuilder;

public class UndertowHttpFacade
implements HttpFacade {
    public static final AttachmentKey<AuthenticationError> AUTH_ERROR_ATTACHMENT_KEY = AttachmentKey.create(AuthenticationError.class);
    public static final AttachmentKey<LogoutError> LOGOUT_ERROR_ATTACHMENT_KEY = AttachmentKey.create(LogoutError.class);
    protected HttpServerExchange exchange;
    protected RequestFacade requestFacade = new RequestFacade();
    protected ResponseFacade responseFacade = new ResponseFacade();

    public UndertowHttpFacade(HttpServerExchange exchange) {
        this.exchange = exchange;
    }

    public HttpFacade.Request getRequest() {
        return this.requestFacade;
    }

    public HttpFacade.Response getResponse() {
        return this.responseFacade;
    }

    public X509Certificate[] getCertificateChain() {
        X509Certificate[] chain = new X509Certificate[]{};
        try {
            chain = this.exchange.getConnection().getSslSessionInfo().getPeerCertificateChain();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return chain;
    }

    protected class ResponseFacade
    implements HttpFacade.Response {
        protected ResponseFacade() {
        }

        public void setStatus(int status) {
            UndertowHttpFacade.this.exchange.setResponseCode(status);
        }

        public void addHeader(String name, String value) {
            UndertowHttpFacade.this.exchange.getResponseHeaders().add(new HttpString(name), value);
        }

        public void setHeader(String name, String value) {
            UndertowHttpFacade.this.exchange.getResponseHeaders().put(new HttpString(name), value);
        }

        public void resetCookie(String name, String path) {
            CookieImpl cookie = new CookieImpl(name, "");
            cookie.setMaxAge(Integer.valueOf(0));
            cookie.setPath(path);
            UndertowHttpFacade.this.exchange.setResponseCookie((Cookie)cookie);
        }

        public void setCookie(String name, String value, String path, String domain, int maxAge, boolean secure, boolean httpOnly) {
            CookieImpl cookie = new CookieImpl(name, value);
            cookie.setPath(path);
            cookie.setDomain(domain);
            cookie.setMaxAge(Integer.valueOf(maxAge));
            cookie.setSecure(secure);
            cookie.setHttpOnly(httpOnly);
            UndertowHttpFacade.this.exchange.setResponseCookie((Cookie)cookie);
        }

        public OutputStream getOutputStream() {
            if (!UndertowHttpFacade.this.exchange.isBlocking()) {
                UndertowHttpFacade.this.exchange.startBlocking();
            }
            return UndertowHttpFacade.this.exchange.getOutputStream();
        }

        public void sendError(int code) {
            UndertowHttpFacade.this.exchange.setResponseCode(code);
        }

        public void sendError(int code, String message) {
            UndertowHttpFacade.this.exchange.setResponseCode(code);
            UndertowHttpFacade.this.exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, "text/html");
            try {
                UndertowHttpFacade.this.exchange.getOutputStream().write(message.getBytes());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            UndertowHttpFacade.this.exchange.endExchange();
        }

        public void end() {
            UndertowHttpFacade.this.exchange.endExchange();
        }
    }

    protected class RequestFacade
    implements HttpFacade.Request {
        protected RequestFacade() {
        }

        public String getURI() {
            KeycloakUriBuilder uriBuilder = KeycloakUriBuilder.fromUri((String)UndertowHttpFacade.this.exchange.getRequestURI()).replaceQuery(UndertowHttpFacade.this.exchange.getQueryString());
            if (!UndertowHttpFacade.this.exchange.isHostIncludedInRequestURI()) {
                uriBuilder.scheme(UndertowHttpFacade.this.exchange.getRequestScheme()).host(UndertowHttpFacade.this.exchange.getHostAndPort());
            }
            return uriBuilder.build(new Object[0]).toString();
        }

        public boolean isSecure() {
            String protocol = UndertowHttpFacade.this.exchange.getRequestScheme();
            return protocol.equalsIgnoreCase("https");
        }

        public String getFirstParam(String param) {
            throw new RuntimeException("Not implemented yet");
        }

        public String getQueryParamValue(String param) {
            Map queryParameters = UndertowHttpFacade.this.exchange.getQueryParameters();
            if (queryParameters == null) {
                return null;
            }
            Deque strings = (Deque)queryParameters.get(param);
            if (strings == null) {
                return null;
            }
            return (String)strings.getFirst();
        }

        public HttpFacade.Cookie getCookie(String cookieName) {
            Map requestCookies = UndertowHttpFacade.this.exchange.getRequestCookies();
            if (requestCookies == null) {
                return null;
            }
            Cookie cookie = (Cookie)requestCookies.get(cookieName);
            if (cookie == null) {
                return null;
            }
            return new HttpFacade.Cookie(cookie.getName(), cookie.getValue(), cookie.getVersion(), cookie.getDomain(), cookie.getPath());
        }

        public List<String> getHeaders(String name) {
            return UndertowHttpFacade.this.exchange.getRequestHeaders().get(name);
        }

        public String getMethod() {
            return UndertowHttpFacade.this.exchange.getRequestMethod().toString();
        }

        public String getHeader(String name) {
            return UndertowHttpFacade.this.exchange.getRequestHeaders().getFirst(name);
        }

        public InputStream getInputStream() {
            if (!UndertowHttpFacade.this.exchange.isBlocking()) {
                UndertowHttpFacade.this.exchange.startBlocking();
            }
            return UndertowHttpFacade.this.exchange.getInputStream();
        }

        public String getRemoteAddr() {
            InetSocketAddress sourceAddress = UndertowHttpFacade.this.exchange.getSourceAddress();
            if (sourceAddress == null) {
                return "";
            }
            InetAddress address = sourceAddress.getAddress();
            if (address == null) {
                return sourceAddress.getHostString();
            }
            return address.getHostAddress();
        }

        public void setError(AuthenticationError error) {
            UndertowHttpFacade.this.exchange.putAttachment(AUTH_ERROR_ATTACHMENT_KEY, (Object)error);
        }

        public void setError(LogoutError error) {
            UndertowHttpFacade.this.exchange.putAttachment(LOGOUT_ERROR_ATTACHMENT_KEY, (Object)error);
        }
    }
}

