/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.client.resource;

import org.keycloak.authorization.client.AuthorizationDeniedException;
import org.keycloak.authorization.client.representation.AuthorizationRequest;
import org.keycloak.authorization.client.representation.AuthorizationResponse;
import org.keycloak.authorization.client.util.Http;
import org.keycloak.authorization.client.util.HttpResponseException;
import org.keycloak.util.JsonSerialization;

public class AuthorizationResource {
    private final Http http;
    private final String accessToken;

    public AuthorizationResource(Http http, String aat) {
        this.http = http;
        this.accessToken = aat;
    }

    public AuthorizationResponse authorize(AuthorizationRequest request) {
        try {
            return this.http.post("/authz/authorize").authorizationBearer(this.accessToken).json(JsonSerialization.writeValueAsBytes((Object)request)).response().json(AuthorizationResponse.class).execute();
        }
        catch (HttpResponseException e) {
            if (403 == e.getStatusCode()) {
                throw new AuthorizationDeniedException(e);
            }
            throw new RuntimeException("Failed to obtain authorization data.", e);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to obtain authorization data.", e);
        }
    }
}

