/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters;

import java.io.IOException;
import java.net.URI;
import java.util.Map;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.jboss.logging.Logger;
import org.keycloak.adapters.KeycloakConfigResolver;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.KeycloakDeploymentBuilder;
import org.keycloak.adapters.authentication.ClientCredentialsProvider;
import org.keycloak.adapters.authorization.PolicyEnforcer;
import org.keycloak.adapters.rotation.PublicKeyLocator;
import org.keycloak.adapters.spi.HttpFacade;
import org.keycloak.common.enums.RelativeUrlsUsed;
import org.keycloak.common.enums.SslRequired;
import org.keycloak.common.util.KeycloakUriBuilder;
import org.keycloak.enums.TokenStore;
import org.keycloak.representations.adapters.config.AdapterConfig;

public class AdapterDeploymentContext {
    private static final Logger log = Logger.getLogger(AdapterDeploymentContext.class);
    protected KeycloakDeployment deployment;
    protected KeycloakConfigResolver configResolver;

    public AdapterDeploymentContext() {
    }

    public AdapterDeploymentContext(KeycloakDeployment deployment) {
        this.deployment = deployment;
    }

    public AdapterDeploymentContext(KeycloakConfigResolver configResolver) {
        this.configResolver = configResolver;
    }

    public KeycloakDeployment resolveDeployment(HttpFacade facade) {
        if (null != this.configResolver) {
            return this.configResolver.resolve(facade.getRequest());
        }
        if (this.deployment == null) {
            return null;
        }
        if (this.deployment.getAuthServerBaseUrl() == null) {
            return this.deployment;
        }
        KeycloakDeployment resolvedDeployment = this.resolveUrls(this.deployment, facade);
        if (resolvedDeployment.getPublicKeyLocator() == null) {
            throw new RuntimeException("KeycloakDeployment was never initialized through appropriate SPIs");
        }
        return resolvedDeployment;
    }

    protected KeycloakDeployment resolveUrls(KeycloakDeployment deployment, HttpFacade facade) {
        if (deployment.relativeUrls == RelativeUrlsUsed.NEVER) {
            return deployment;
        }
        DeploymentDelegate delegate = new DeploymentDelegate(this.deployment);
        delegate.setAuthServerBaseUrl(this.getBaseBuilder(facade, this.deployment.getAuthServerBaseUrl()).build(new Object[0]).toString());
        return delegate;
    }

    protected KeycloakUriBuilder getBaseBuilder(HttpFacade facade, String base) {
        KeycloakUriBuilder builder = KeycloakUriBuilder.fromUri((String)base);
        URI request = URI.create(facade.getRequest().getURI());
        String scheme = request.getScheme();
        if (this.deployment.getSslRequired().isRequired(facade.getRequest().getRemoteAddr())) {
            scheme = "https";
            if (!request.getScheme().equals(scheme) && request.getPort() != -1) {
                log.error((Object)("request scheme: " + request.getScheme() + " ssl required"));
                throw new RuntimeException("Can't resolve relative url from adapter config.");
            }
        }
        builder.scheme(scheme);
        builder.host(request.getHost());
        if (request.getPort() != -1) {
            builder.port(request.getPort());
        }
        return builder;
    }

    protected void close(HttpResponse response) {
        if (response.getEntity() != null) {
            try {
                response.getEntity().getContent().close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void updateDeployment(AdapterConfig config) {
        if (null != this.configResolver) {
            throw new IllegalStateException("Cannot parse an adapter config and build an updated deployment when on a multi-tenant scenario.");
        }
        this.deployment = KeycloakDeploymentBuilder.build(config);
    }

    protected static class DeploymentDelegate
    extends KeycloakDeployment {
        protected KeycloakDeployment delegate;

        public DeploymentDelegate(KeycloakDeployment delegate) {
            this.delegate = delegate;
        }

        public void setAuthServerBaseUrl(String authServerBaseUrl) {
            this.authServerBaseUrl = authServerBaseUrl;
            KeycloakUriBuilder serverBuilder = KeycloakUriBuilder.fromUri((String)authServerBaseUrl);
            this.resolveUrls(serverBuilder);
        }

        @Override
        public RelativeUrlsUsed getRelativeUrls() {
            return this.delegate.getRelativeUrls();
        }

        @Override
        public String getRealmInfoUrl() {
            return this.realmInfoUrl != null ? this.realmInfoUrl : this.delegate.getRealmInfoUrl();
        }

        @Override
        public String getTokenUrl() {
            return this.tokenUrl != null ? this.tokenUrl : this.delegate.getTokenUrl();
        }

        @Override
        public KeycloakUriBuilder getLogoutUrl() {
            return this.logoutUrl != null ? this.logoutUrl : this.delegate.getLogoutUrl();
        }

        @Override
        public String getAccountUrl() {
            return this.accountUrl != null ? this.accountUrl : this.delegate.getAccountUrl();
        }

        @Override
        public String getRegisterNodeUrl() {
            return this.registerNodeUrl != null ? this.registerNodeUrl : this.delegate.getRegisterNodeUrl();
        }

        @Override
        public String getUnregisterNodeUrl() {
            return this.unregisterNodeUrl != null ? this.unregisterNodeUrl : this.delegate.getUnregisterNodeUrl();
        }

        @Override
        public String getJwksUrl() {
            return this.jwksUrl != null ? this.jwksUrl : this.delegate.getJwksUrl();
        }

        @Override
        public String getResourceName() {
            return this.delegate.getResourceName();
        }

        @Override
        public String getRealm() {
            return this.delegate.getRealm();
        }

        @Override
        public void setRealm(String realm) {
            this.delegate.setRealm(realm);
        }

        @Override
        public void setPublicKeyLocator(PublicKeyLocator publicKeyLocator) {
            this.delegate.setPublicKeyLocator(publicKeyLocator);
        }

        @Override
        public PublicKeyLocator getPublicKeyLocator() {
            return this.delegate.getPublicKeyLocator();
        }

        @Override
        public void setResourceName(String resourceName) {
            this.delegate.setResourceName(resourceName);
        }

        @Override
        public boolean isBearerOnly() {
            return this.delegate.isBearerOnly();
        }

        @Override
        public void setBearerOnly(boolean bearerOnly) {
            this.delegate.setBearerOnly(bearerOnly);
        }

        @Override
        public boolean isEnableBasicAuth() {
            return this.delegate.isEnableBasicAuth();
        }

        @Override
        public void setEnableBasicAuth(boolean enableBasicAuth) {
            this.delegate.setEnableBasicAuth(enableBasicAuth);
        }

        @Override
        public boolean isPublicClient() {
            return this.delegate.isPublicClient();
        }

        @Override
        public void setPublicClient(boolean publicClient) {
            this.delegate.setPublicClient(publicClient);
        }

        @Override
        public Map<String, Object> getResourceCredentials() {
            return this.delegate.getResourceCredentials();
        }

        @Override
        public void setResourceCredentials(Map<String, Object> resourceCredentials) {
            this.delegate.setResourceCredentials(resourceCredentials);
        }

        @Override
        public void setClientAuthenticator(ClientCredentialsProvider clientAuthenticator) {
            this.delegate.setClientAuthenticator(clientAuthenticator);
        }

        @Override
        public ClientCredentialsProvider getClientAuthenticator() {
            return this.delegate.getClientAuthenticator();
        }

        @Override
        public HttpClient getClient() {
            return this.delegate.getClient();
        }

        @Override
        public void setClient(HttpClient client) {
            this.delegate.setClient(client);
        }

        @Override
        public String getScope() {
            return this.delegate.getScope();
        }

        @Override
        public void setScope(String scope) {
            this.delegate.setScope(scope);
        }

        @Override
        public SslRequired getSslRequired() {
            return this.delegate.getSslRequired();
        }

        @Override
        public void setSslRequired(SslRequired sslRequired) {
            this.delegate.setSslRequired(sslRequired);
        }

        @Override
        public TokenStore getTokenStore() {
            return this.delegate.getTokenStore();
        }

        @Override
        public void setTokenStore(TokenStore tokenStore) {
            this.delegate.setTokenStore(tokenStore);
        }

        @Override
        public String getStateCookieName() {
            return this.delegate.getStateCookieName();
        }

        @Override
        public void setStateCookieName(String stateCookieName) {
            this.delegate.setStateCookieName(stateCookieName);
        }

        @Override
        public boolean isUseResourceRoleMappings() {
            return this.delegate.isUseResourceRoleMappings();
        }

        @Override
        public void setUseResourceRoleMappings(boolean useResourceRoleMappings) {
            this.delegate.setUseResourceRoleMappings(useResourceRoleMappings);
        }

        @Override
        public boolean isCors() {
            return this.delegate.isCors();
        }

        @Override
        public void setCors(boolean cors) {
            this.delegate.setCors(cors);
        }

        @Override
        public int getCorsMaxAge() {
            return this.delegate.getCorsMaxAge();
        }

        @Override
        public void setCorsMaxAge(int corsMaxAge) {
            this.delegate.setCorsMaxAge(corsMaxAge);
        }

        @Override
        public String getCorsAllowedHeaders() {
            return this.delegate.getCorsAllowedHeaders();
        }

        @Override
        public void setNotBefore(int notBefore) {
            this.delegate.setNotBefore(notBefore);
        }

        @Override
        public int getNotBefore() {
            return this.delegate.getNotBefore();
        }

        @Override
        public void updateNotBefore(int notBefore) {
            this.delegate.setNotBefore(notBefore);
            this.getPublicKeyLocator().reset(this);
        }

        @Override
        public void setExposeToken(boolean exposeToken) {
            this.delegate.setExposeToken(exposeToken);
        }

        @Override
        public boolean isExposeToken() {
            return this.delegate.isExposeToken();
        }

        @Override
        public void setCorsAllowedMethods(String corsAllowedMethods) {
            this.delegate.setCorsAllowedMethods(corsAllowedMethods);
        }

        @Override
        public String getCorsAllowedMethods() {
            return this.delegate.getCorsAllowedMethods();
        }

        @Override
        public void setCorsAllowedHeaders(String corsAllowedHeaders) {
            this.delegate.setCorsAllowedHeaders(corsAllowedHeaders);
        }

        @Override
        public boolean isAlwaysRefreshToken() {
            return this.delegate.isAlwaysRefreshToken();
        }

        @Override
        public void setAlwaysRefreshToken(boolean alwaysRefreshToken) {
            this.delegate.setAlwaysRefreshToken(alwaysRefreshToken);
        }

        @Override
        public int getRegisterNodePeriod() {
            return this.delegate.getRegisterNodePeriod();
        }

        @Override
        public void setRegisterNodePeriod(int registerNodePeriod) {
            this.delegate.setRegisterNodePeriod(registerNodePeriod);
        }

        @Override
        public void setRegisterNodeAtStartup(boolean registerNodeAtStartup) {
            this.delegate.setRegisterNodeAtStartup(registerNodeAtStartup);
        }

        @Override
        public boolean isRegisterNodeAtStartup() {
            return this.delegate.isRegisterNodeAtStartup();
        }

        @Override
        public String getPrincipalAttribute() {
            return this.delegate.getPrincipalAttribute();
        }

        @Override
        public void setPrincipalAttribute(String principalAttribute) {
            this.delegate.setPrincipalAttribute(principalAttribute);
        }

        @Override
        public boolean isTurnOffChangeSessionIdOnLogin() {
            return this.delegate.isTurnOffChangeSessionIdOnLogin();
        }

        @Override
        public void setTurnOffChangeSessionIdOnLogin(boolean turnOffChangeSessionIdOnLogin) {
            this.delegate.setTurnOffChangeSessionIdOnLogin(turnOffChangeSessionIdOnLogin);
        }

        @Override
        public int getTokenMinimumTimeToLive() {
            return this.delegate.getTokenMinimumTimeToLive();
        }

        @Override
        public void setTokenMinimumTimeToLive(int tokenMinimumTimeToLive) {
            this.delegate.setTokenMinimumTimeToLive(tokenMinimumTimeToLive);
        }

        @Override
        public PolicyEnforcer getPolicyEnforcer() {
            return this.delegate.getPolicyEnforcer();
        }

        @Override
        public void setPolicyEnforcer(PolicyEnforcer policyEnforcer) {
            this.delegate.setPolicyEnforcer(policyEnforcer);
        }

        @Override
        public void setMinTimeBetweenJwksRequests(int minTimeBetweenJwksRequests) {
            this.delegate.setMinTimeBetweenJwksRequests(minTimeBetweenJwksRequests);
        }

        @Override
        public int getMinTimeBetweenJwksRequests() {
            return this.delegate.getMinTimeBetweenJwksRequests();
        }

        @Override
        public int getPublicKeyCacheTtl() {
            return this.delegate.getPublicKeyCacheTtl();
        }

        @Override
        public void setPublicKeyCacheTtl(int publicKeyCacheTtl) {
            this.delegate.setPublicKeyCacheTtl(publicKeyCacheTtl);
        }
    }
}

