/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.subsystem.wf8.extension;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.common.GenericSubsystemDescribeHandler;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.keycloak.subsystem.wf8.extension.KeycloakExtension;
import org.keycloak.subsystem.wf8.extension.SecureDeploymentAddHandler;
import org.keycloak.subsystem.wf8.extension.SecureDeploymentRemoveHandler;
import org.keycloak.subsystem.wf8.extension.SecureDeploymentWriteAttributeHandler;
import org.keycloak.subsystem.wf8.extension.SharedAttributeDefinitons;

public class SecureDeploymentDefinition
extends SimpleResourceDefinition {
    public static final String TAG_NAME = "secure-deployment";
    protected static final SimpleAttributeDefinition REALM = new SimpleAttributeDefinitionBuilder("realm", ModelType.STRING, true).setXmlName("realm").setAllowExpression(true).setValidator((ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, true, true)).build();
    protected static final SimpleAttributeDefinition RESOURCE = new SimpleAttributeDefinitionBuilder("resource", ModelType.STRING, true).setXmlName("resource").setAllowExpression(true).setValidator((ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, true, true)).build();
    protected static final SimpleAttributeDefinition USE_RESOURCE_ROLE_MAPPINGS = new SimpleAttributeDefinitionBuilder("use-resource-role-mappings", ModelType.BOOLEAN, true).setXmlName("use-resource-role-mappings").setAllowExpression(true).setDefaultValue(new ModelNode(false)).build();
    protected static final SimpleAttributeDefinition BEARER_ONLY = new SimpleAttributeDefinitionBuilder("bearer-only", ModelType.BOOLEAN, true).setXmlName("bearer-only").setAllowExpression(true).setDefaultValue(new ModelNode(false)).build();
    protected static final SimpleAttributeDefinition ENABLE_BASIC_AUTH = new SimpleAttributeDefinitionBuilder("enable-basic-auth", ModelType.BOOLEAN, true).setXmlName("enable-basic-auth").setAllowExpression(true).setDefaultValue(new ModelNode(false)).build();
    protected static final SimpleAttributeDefinition PUBLIC_CLIENT = new SimpleAttributeDefinitionBuilder("public-client", ModelType.BOOLEAN, true).setXmlName("public-client").setAllowExpression(true).setDefaultValue(new ModelNode(false)).build();
    protected static final List<SimpleAttributeDefinition> DEPLOYMENT_ONLY_ATTRIBUTES = new ArrayList<SimpleAttributeDefinition>();
    protected static final List<SimpleAttributeDefinition> ALL_ATTRIBUTES;
    private static final Map<String, SimpleAttributeDefinition> DEFINITION_LOOKUP;
    private static SecureDeploymentWriteAttributeHandler attrHandler;

    public SecureDeploymentDefinition() {
        super(PathElement.pathElement((String)TAG_NAME), (ResourceDescriptionResolver)KeycloakExtension.getResourceDescriptionResolver(TAG_NAME), (OperationStepHandler)SecureDeploymentAddHandler.INSTANCE, (OperationStepHandler)SecureDeploymentRemoveHandler.INSTANCE);
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        resourceRegistration.registerOperationHandler((OperationDefinition)GenericSubsystemDescribeHandler.DEFINITION, (OperationStepHandler)GenericSubsystemDescribeHandler.INSTANCE);
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        super.registerAttributes(resourceRegistration);
        for (AttributeDefinition attributeDefinition : ALL_ATTRIBUTES) {
            resourceRegistration.registerReadWriteAttribute(attributeDefinition, null, (OperationStepHandler)attrHandler);
        }
    }

    public static SimpleAttributeDefinition lookup(String name) {
        return DEFINITION_LOOKUP.get(name);
    }

    static {
        DEPLOYMENT_ONLY_ATTRIBUTES.add(REALM);
        DEPLOYMENT_ONLY_ATTRIBUTES.add(RESOURCE);
        DEPLOYMENT_ONLY_ATTRIBUTES.add(USE_RESOURCE_ROLE_MAPPINGS);
        DEPLOYMENT_ONLY_ATTRIBUTES.add(BEARER_ONLY);
        DEPLOYMENT_ONLY_ATTRIBUTES.add(ENABLE_BASIC_AUTH);
        DEPLOYMENT_ONLY_ATTRIBUTES.add(PUBLIC_CLIENT);
        ALL_ATTRIBUTES = new ArrayList<SimpleAttributeDefinition>();
        ALL_ATTRIBUTES.addAll(DEPLOYMENT_ONLY_ATTRIBUTES);
        ALL_ATTRIBUTES.addAll(SharedAttributeDefinitons.ATTRIBUTES);
        DEFINITION_LOOKUP = new HashMap<String, SimpleAttributeDefinition>();
        for (SimpleAttributeDefinition def : ALL_ATTRIBUTES) {
            DEFINITION_LOOKUP.put(def.getXmlName(), def);
        }
        attrHandler = new SecureDeploymentWriteAttributeHandler(ALL_ATTRIBUTES);
    }
}

