/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters;

import java.io.IOException;
import java.security.PublicKey;
import org.jboss.logging.Logger;
import org.keycloak.KeycloakPrincipal;
import org.keycloak.KeycloakSecurityContext;
import org.keycloak.RSATokenVerifier;
import org.keycloak.adapters.AdapterTokenStore;
import org.keycloak.adapters.AdapterUtils;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.RefreshableKeycloakSecurityContext;
import org.keycloak.adapters.spi.HttpFacade;
import org.keycloak.common.VerificationException;
import org.keycloak.common.util.KeycloakUriBuilder;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.IDToken;

public class CookieTokenStore {
    private static final Logger log = Logger.getLogger(CookieTokenStore.class);
    private static final String DELIM = "___";

    public static void setTokenCookie(KeycloakDeployment deployment, HttpFacade facade, RefreshableKeycloakSecurityContext session) {
        log.debugf("Set new %s cookie now", (Object)"KEYCLOAK_ADAPTER_STATE");
        String accessToken = session.getTokenString();
        String idToken = session.getIdTokenString();
        String refreshToken = session.getRefreshToken();
        String cookie = accessToken + DELIM + idToken + DELIM + refreshToken;
        String cookiePath = CookieTokenStore.getContextPath(facade);
        facade.getResponse().setCookie("KEYCLOAK_ADAPTER_STATE", cookie, cookiePath, null, -1, deployment.getSslRequired().isRequired(facade.getRequest().getRemoteAddr()), true);
    }

    public static KeycloakPrincipal<RefreshableKeycloakSecurityContext> getPrincipalFromCookie(KeycloakDeployment deployment, HttpFacade facade, AdapterTokenStore tokenStore) {
        HttpFacade.Cookie cookie = facade.getRequest().getCookie("KEYCLOAK_ADAPTER_STATE");
        if (cookie == null) {
            log.debug((Object)"Not found adapter state cookie in current request");
            return null;
        }
        String cookieVal = cookie.getValue();
        String[] tokens = cookieVal.split(DELIM);
        if (tokens.length != 3) {
            log.warnf("Invalid format of %s cookie. Count of tokens: %s, expected 3", (Object)"KEYCLOAK_ADAPTER_STATE", (Object)tokens.length);
            return null;
        }
        String accessTokenString = tokens[0];
        String idTokenString = tokens[1];
        String refreshTokenString = tokens[2];
        try {
            IDToken idToken;
            AccessToken accessToken = RSATokenVerifier.verifyToken((String)accessTokenString, (PublicKey)deployment.getRealmKey(), (String)deployment.getRealmInfoUrl(), (boolean)false, (boolean)true);
            if (idTokenString != null && idTokenString.length() > 0) {
                JWSInput input = new JWSInput(idTokenString);
                try {
                    idToken = (IDToken)input.readJsonContent(IDToken.class);
                }
                catch (IOException e) {
                    throw new VerificationException((Throwable)e);
                }
            } else {
                idToken = null;
            }
            log.debug((Object)"Token Verification succeeded!");
            RefreshableKeycloakSecurityContext secContext = new RefreshableKeycloakSecurityContext(deployment, tokenStore, accessTokenString, accessToken, idTokenString, idToken, refreshTokenString);
            return new KeycloakPrincipal(AdapterUtils.getPrincipalName(deployment, accessToken), (KeycloakSecurityContext)secContext);
        }
        catch (VerificationException ve) {
            log.warn((Object)"Failed verify token", (Throwable)ve);
            return null;
        }
    }

    public static void removeCookie(HttpFacade facade) {
        String cookiePath = CookieTokenStore.getContextPath(facade);
        facade.getResponse().resetCookie("KEYCLOAK_ADAPTER_STATE", cookiePath);
    }

    private static String getContextPath(HttpFacade facade) {
        String uri = facade.getRequest().getURI();
        String path = KeycloakUriBuilder.fromUri((String)uri).getPath();
        int index = path.indexOf("/", 1);
        return index == -1 ? path : path.substring(0, index);
    }
}

