/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.wildfly;

import io.undertow.server.HttpServerExchange;
import java.security.Principal;
import java.security.acl.Group;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Set;
import javax.security.auth.Subject;
import org.jboss.logging.Logger;
import org.jboss.security.NestableGroup;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityContextAssociation;
import org.jboss.security.SimpleGroup;
import org.jboss.security.SimplePrincipal;
import org.keycloak.adapters.HttpFacade;
import org.keycloak.adapters.KeycloakAccount;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.undertow.KeycloakUndertowAccount;
import org.keycloak.adapters.undertow.ServletRequestAuthenticator;
import org.keycloak.adapters.undertow.UndertowUserSessionManagement;
import org.keycloak.adapters.wildfly.SecurityInfoHelper;

public class WildflyRequestAuthenticator
extends ServletRequestAuthenticator {
    protected static Logger log = Logger.getLogger(WildflyRequestAuthenticator.class);

    public WildflyRequestAuthenticator(HttpFacade facade, KeycloakDeployment deployment, int sslRedirectPort, io.undertow.security.api.SecurityContext securityContext, HttpServerExchange exchange, UndertowUserSessionManagement userSessionManagement) {
        super(facade, deployment, sslRedirectPort, securityContext, exchange, userSessionManagement);
    }

    protected void propagateKeycloakContext(KeycloakUndertowAccount account) {
        super.propagateKeycloakContext(account);
        SecurityInfoHelper.propagateSessionInfo((KeycloakAccount)account);
        log.debug((Object)"propagate security context to wildfly");
        Subject subject = new Subject();
        Set<Principal> principals = subject.getPrincipals();
        principals.add(account.getPrincipal());
        Group[] roleSets = this.getRoleSets(account.getRoles());
        for (int g = 0; g < roleSets.length; ++g) {
            Group group = roleSets[g];
            String name = group.getName();
            Group subjectGroup = this.createGroup(name, principals);
            if (subjectGroup instanceof NestableGroup) {
                SimpleGroup tmp = new SimpleGroup("Roles");
                subjectGroup.addMember((Principal)tmp);
                subjectGroup = tmp;
            }
            Enumeration members = group.members();
            while (members.hasMoreElements()) {
                Principal role = (Principal)members.nextElement();
                subjectGroup.addMember(role);
            }
        }
        SimpleGroup callerGroup = new SimpleGroup("CallerPrincipal");
        callerGroup.addMember(account.getPrincipal());
        principals.add((Principal)callerGroup);
        SecurityContext sc = SecurityContextAssociation.getSecurityContext();
        Principal userPrincipal = this.getPrincipal(subject);
        sc.getUtil().createSubjectInfo(userPrincipal, (Object)account, subject);
    }

    protected Principal getPrincipal(Subject subject) {
        Set<Principal> principals;
        Principal principal = null;
        Principal callerPrincipal = null;
        if (subject != null && (principals = subject.getPrincipals()) != null && !principals.isEmpty()) {
            for (Principal p : principals) {
                Enumeration e;
                Group g;
                if (!(p instanceof Group) && principal == null) {
                    principal = p;
                }
                if (!(p instanceof Group) || !(g = (Group)Group.class.cast(p)).getName().equals("CallerPrincipal") || callerPrincipal != null || !(e = g.members()).hasMoreElements()) continue;
                callerPrincipal = (Principal)e.nextElement();
            }
        }
        return callerPrincipal == null ? principal : callerPrincipal;
    }

    protected Group createGroup(String name, Set<Principal> principals) {
        SimpleGroup roles = null;
        for (Principal next : principals) {
            Group grp;
            if (!(next instanceof Group) || !(grp = (Group)next).getName().equals(name)) continue;
            roles = grp;
            break;
        }
        if (roles == null) {
            roles = new SimpleGroup(name);
            principals.add((Principal)roles);
        }
        return roles;
    }

    protected Group[] getRoleSets(Collection<String> roleSet) {
        SimpleGroup roles = new SimpleGroup("Roles");
        Group[] roleSets = new Group[]{roles};
        for (String role : roleSet) {
            roles.addMember((Principal)new SimplePrincipal(role));
        }
        return roleSets;
    }
}

