/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.wildfly.adduser;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.Console;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ServiceLoader;
import org.aesh.AeshRuntimeRunner;
import org.aesh.command.Command;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandNotFoundException;
import org.aesh.command.CommandResult;
import org.aesh.command.container.CommandContainer;
import org.aesh.command.impl.registry.AeshCommandRegistryBuilder;
import org.aesh.command.invocation.CommandInvocation;
import org.aesh.command.option.Option;
import org.aesh.command.registry.CommandRegistry;
import org.aesh.command.registry.CommandRegistryException;
import org.keycloak.common.crypto.CryptoIntegration;
import org.keycloak.credential.CredentialModel;
import org.keycloak.credential.hash.PasswordHashProvider;
import org.keycloak.credential.hash.PasswordHashProviderFactory;
import org.keycloak.models.credential.PasswordCredentialModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.util.JsonSerialization;

public class AddUser {
    private static final String COMMAND_NAME = "add-user";
    private static final int DEFAULT_HASH_ITERATIONS = 100000;
    private static final String DEFAULT_HASH_ALGORITH = "pbkdf2-sha256";

    public static void main(String[] args) {
        AeshRuntimeRunner.builder().command(AddUserCommand.class).args(args).execute();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static File getAddUserFile(AddUserCommand command) throws Exception {
        File configDir;
        if (command.isDomain()) {
            if (command.getDc() != null) {
                configDir = new File(command.getDc());
            } else if (System.getProperty("jboss.domain.config.user.dir") != null) {
                configDir = new File(System.getProperty("jboss.domain.config.user.dir"));
            } else {
                if (System.getenv("JBOSS_HOME") == null) throw new Exception("Could not find domain configuration directory");
                configDir = new File(System.getenv("JBOSS_HOME") + File.separator + "domain" + File.separator + "configuration");
            }
        } else if (command.getSc() != null) {
            configDir = new File(command.getSc());
        } else if (System.getProperty("jboss.server.config.user.dir") != null) {
            configDir = new File(System.getProperty("jboss.server.config.user.dir"));
        } else {
            if (System.getenv("JBOSS_HOME") == null) throw new Exception("Could not find standalone configuration directory");
            configDir = new File(System.getenv("JBOSS_HOME") + File.separator + "standalone" + File.separator + "configuration");
        }
        if (configDir.isDirectory()) return new File(configDir, "keycloak-add-user.json");
        throw new Exception("'" + configDir + "' does not exist or is not a directory");
    }

    private static void createUser(File addUserFile, String realmName, String userName, String password, String rolesString, int iterations) throws Exception {
        List realms = addUserFile.isFile() ? (List)JsonSerialization.readValue((InputStream)new FileInputStream(addUserFile), (TypeReference)new TypeReference<List<RealmRepresentation>>(){}) : new LinkedList();
        if (realmName == null) {
            realmName = "master";
        }
        RealmRepresentation realm = null;
        for (RealmRepresentation r : realms) {
            if (!r.getRealm().equals(realmName)) continue;
            realm = r;
        }
        if (realm == null) {
            realm = new RealmRepresentation();
            realm.setRealm(realmName);
            realms.add(realm);
            realm.setUsers(new LinkedList());
        }
        for (UserRepresentation u : realm.getUsers()) {
            if (!u.getUsername().equals(userName)) continue;
            throw new Exception("User with username '" + userName + "' already added to '" + addUserFile + "'");
        }
        UserRepresentation user = new UserRepresentation();
        user.setEnabled(Boolean.valueOf(true));
        user.setUsername(userName);
        user.setCredentials(new LinkedList());
        PasswordHashProviderFactory hashProviderFactory = AddUser.getHashProviderFactory(DEFAULT_HASH_ALGORITH);
        PasswordHashProvider hashProvider = (PasswordHashProvider)hashProviderFactory.create(null);
        PasswordCredentialModel credentialModel = hashProvider.encodedCredential(password, iterations > 0 ? iterations : 100000);
        CredentialRepresentation credentials = ModelToRepresentation.toRepresentation((CredentialModel)credentialModel);
        user.getCredentials().add(credentials);
        String[] roles = rolesString != null ? rolesString.split(",") : (realmName.equals("master") ? new String[]{"admin"} : new String[]{"realm-management/realm-admin"});
        for (String r : roles) {
            if (r.indexOf(47) != -1) {
                String[] cr = r.split("/");
                String client = cr[0];
                String clientRole = cr[1];
                if (user.getClientRoles() == null) {
                    user.setClientRoles(new HashMap());
                }
                if (user.getClientRoles().get(client) == null) {
                    user.getClientRoles().put(client, new LinkedList());
                }
                ((List)user.getClientRoles().get(client)).add(clientRole);
                continue;
            }
            if (user.getRealmRoles() == null) {
                user.setRealmRoles(new LinkedList());
            }
            user.getRealmRoles().add(r);
        }
        realm.getUsers().add(user);
        JsonSerialization.writeValuePrettyToStream((OutputStream)new FileOutputStream(addUserFile), realms);
        System.out.println("Added '" + userName + "' to '" + addUserFile + "', restart server to load user");
    }

    private static PasswordHashProviderFactory getHashProviderFactory(String providerId) {
        ServiceLoader<PasswordHashProviderFactory> providerFactories = ServiceLoader.load(PasswordHashProviderFactory.class);
        for (PasswordHashProviderFactory f : providerFactories) {
            if (!f.getId().equals(providerId)) continue;
            return f;
        }
        return null;
    }

    private static void checkRequired(Command command, String field) throws Exception {
        if (AddUser.isEmpty(command, field).booleanValue()) {
            Option option = command.getClass().getDeclaredField(field).getAnnotation(Option.class);
            String optionName = option != null && option.shortName() != '\u0000' ? "-" + option.shortName() + ", --" + field : "--" + field;
            throw new Exception("Option: " + optionName + " is required");
        }
    }

    private static Boolean isEmpty(Command command, String field) throws Exception {
        Method m = command.getClass().getMethod("get" + Character.toUpperCase(field.charAt(0)) + field.substring(1), new Class[0]);
        return m.invoke((Object)command, new Object[0]) == null;
    }

    private static String promptForInput() throws Exception {
        Console console = System.console();
        if (console == null) {
            throw new Exception("Couldn't get Console instance");
        }
        console.printf("Press ctrl-d (Unix) or ctrl-z (Windows) to exit\n", new Object[0]);
        char[] passwordArray = console.readPassword("Password: ", new Object[0]);
        if (passwordArray == null) {
            System.exit(0);
        }
        return new String(passwordArray);
    }

    private static void printHelp(Command command) throws CommandNotFoundException, CommandRegistryException {
        CommandRegistry registry = AeshCommandRegistryBuilder.builder().command(command).create();
        CommandContainer commandContainer = registry.getCommand(command.getClass().getAnnotation(CommandDefinition.class).name(), null);
        String help = commandContainer.printHelp(null);
        System.out.println(help);
    }

    @CommandDefinition(name="add-user", description="[options...]")
    public static class AddUserCommand
    implements Command {
        @Option(shortName=114, hasValue=true, description="Name of realm to add user to")
        private String realm;
        @Option(shortName=117, hasValue=true, description="Name of the user")
        private String user;
        @Option(shortName=112, hasValue=true, description="Password of the user")
        private String password;
        @Option(hasValue=true, description="Roles to add to the user")
        private String roles;
        @Option(hasValue=true, description="Hash iterations")
        private int iterations;
        @Option(hasValue=false, description="Enable domain mode")
        private boolean domain;
        @Option(hasValue=true, description="Define the location of the server config directory")
        private String sc;
        @Option(hasValue=true, description="Define the location of the domain config directory")
        private String dc;
        @Option(shortName=104, hasValue=false, description="Display this help and exit")
        private boolean help;

        public CommandResult execute(CommandInvocation commandInvocation) throws InterruptedException {
            try {
                if (this.help) {
                    AddUser.printHelp(this);
                } else {
                    AddUser.checkRequired(this, "user");
                    if (AddUser.isEmpty(this, "password").booleanValue()) {
                        this.password = AddUser.promptForInput();
                    }
                    File addUserFile = AddUser.getAddUserFile(this);
                    CryptoIntegration.init((ClassLoader)AddUser.class.getClassLoader());
                    AddUser.createUser(addUserFile, this.realm, this.user, this.password, this.roles, this.iterations);
                }
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
                System.exit(1);
            }
            return CommandResult.SUCCESS;
        }

        public String getRealm() {
            return this.realm;
        }

        public String getUser() {
            return this.user;
        }

        public String getPassword() {
            return this.password;
        }

        public String getRoles() {
            return this.roles;
        }

        public int getIterations() {
            return this.iterations;
        }

        public boolean isDomain() {
            return this.domain;
        }

        public String getSc() {
            return this.sc;
        }

        public String getDc() {
            return this.dc;
        }

        public boolean isHelp() {
            return this.help;
        }
    }
}

