/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.vault;

import java.lang.invoke.MethodHandles;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;
import org.jboss.logging.Logger;
import org.keycloak.vault.AbstractVaultProvider;
import org.keycloak.vault.DefaultVaultRawSecret;
import org.keycloak.vault.VaultKeyResolver;
import org.keycloak.vault.VaultRawSecret;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.credential.store.CredentialStore;
import org.wildfly.security.credential.store.CredentialStoreException;
import org.wildfly.security.password.interfaces.ClearPassword;

public class ElytronCSKeyStoreProvider
extends AbstractVaultProvider {
    private static final Logger logger = Logger.getLogger(MethodHandles.lookup().lookupClass());
    private final CredentialStore credentialStore;

    public ElytronCSKeyStoreProvider(CredentialStore store, String realmName, List<VaultKeyResolver> resolvers) {
        super(realmName, resolvers);
        this.credentialStore = store;
    }

    protected VaultRawSecret obtainSecretInternal(String vaultSecretId) {
        try {
            PasswordCredential credential = (PasswordCredential)this.credentialStore.retrieve(vaultSecretId, PasswordCredential.class);
            if (credential == null) {
                logger.debugf("Cannot find secret %s in credential store", (Object)vaultSecretId);
                return DefaultVaultRawSecret.forBuffer(Optional.empty());
            }
            char[] secret = (char[])credential.getPassword().castAndApply(ClearPassword.class, ClearPassword::getPassword);
            ByteBuffer buffer = StandardCharsets.UTF_8.encode(CharBuffer.wrap(secret));
            return DefaultVaultRawSecret.forBuffer(Optional.of(buffer));
        }
        catch (CredentialStoreException e) {
            logger.debugf((Throwable)e, "Unable to retrieve secret %s from credential store", (Object)vaultSecretId);
            return DefaultVaultRawSecret.forBuffer(Optional.empty());
        }
    }

    public void close() {
    }
}

