/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.vault;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import java.util.HashMap;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.vault.AbstractVaultProviderFactory;
import org.keycloak.vault.ElytronCSKeyStoreProvider;
import org.keycloak.vault.VaultNotFoundException;
import org.keycloak.vault.VaultProvider;
import org.wildfly.security.auth.SupportLevel;
import org.wildfly.security.auth.server.IdentityCredentials;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.credential.source.CredentialSource;
import org.wildfly.security.credential.store.CredentialStore;
import org.wildfly.security.credential.store.CredentialStoreException;
import org.wildfly.security.credential.store.WildFlyElytronCredentialStoreProvider;
import org.wildfly.security.credential.store.impl.KeyStoreCredentialStore;
import org.wildfly.security.password.Password;
import org.wildfly.security.password.interfaces.ClearPassword;
import org.wildfly.security.util.PasswordBasedEncryptionUtil;

public class ElytronCSKeyStoreProviderFactory
extends AbstractVaultProviderFactory {
    private static final Logger logger = Logger.getLogger(MethodHandles.lookup().lookupClass());
    private static final String PROVIDER_ID = "elytron-cs-keystore";
    static final String CS_LOCATION = "location";
    static final String CS_SECRET = "secret";
    static final String CS_KEYSTORE_TYPE = "keyStoreType";
    static final String JCEKS = "JCEKS";
    private String credentialStoreLocation;
    private String credentialStoreType;
    private String credentialStoreSecret;

    public VaultProvider create(KeycloakSession session) {
        CredentialStore credentialStore;
        if (this.credentialStoreLocation == null || this.credentialStoreSecret == null) {
            logger.debug((Object)"Can not create an elytron-based vault provider since it's not initialized correctly");
            return null;
        }
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put(CS_LOCATION, this.credentialStoreLocation);
        attributes.put(CS_KEYSTORE_TYPE, this.credentialStoreType);
        try {
            credentialStore = CredentialStore.getInstance((String)KeyStoreCredentialStore.KEY_STORE_CREDENTIAL_STORE);
            credentialStore.initialize(attributes, (CredentialStore.ProtectionParameter)new CredentialStore.CredentialSourceProtectionParameter(this.getCredentialSource(this.credentialStoreSecret)));
        }
        catch (NoSuchAlgorithmException | CredentialStoreException e) {
            logger.debug((Object)"Error instantiating credential store", e);
            return null;
        }
        return new ElytronCSKeyStoreProvider(credentialStore, this.getRealmName(session), this.keyResolvers);
    }

    public void init(Config.Scope config) {
        super.init(config);
        this.credentialStoreLocation = config.get(CS_LOCATION);
        if (this.credentialStoreLocation == null) {
            logger.debug((Object)"ElytronCSKeyStoreProviderFactory not properly configured - missing store location");
            return;
        }
        if (!Files.exists(Paths.get(this.credentialStoreLocation, new String[0]), new LinkOption[0])) {
            throw new VaultNotFoundException("The " + this.credentialStoreLocation + " file doesn't exist");
        }
        this.credentialStoreSecret = config.get(CS_SECRET);
        if (this.credentialStoreSecret == null) {
            logger.debug((Object)"ElytronCSKeyStoreProviderFactory not properly configured - missing store secret");
            return;
        }
        this.credentialStoreType = config.get(CS_KEYSTORE_TYPE, JCEKS);
        Security.addProvider((Provider)WildFlyElytronCredentialStoreProvider.getInstance());
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
        Security.removeProvider(WildFlyElytronCredentialStoreProvider.getInstance().getName());
    }

    public String getId() {
        return PROVIDER_ID;
    }

    protected CredentialSource getCredentialSource(final String secret) {
        if (secret != null && secret.startsWith("MASK-")) {
            return new CredentialSource(){

                public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws IOException {
                    return credentialType == PasswordCredential.class ? SupportLevel.SUPPORTED : SupportLevel.UNSUPPORTED;
                }

                public <C extends Credential> C getCredential(Class<C> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws IOException {
                    int iterationCount;
                    String[] part = secret.substring(5).split(";");
                    if (part.length != 3) {
                        throw new IOException("Masked password command has the wrong format.%nUsage: MASK-<encoded secret>;<salt>;<iteration count> where <salt>=UTF-8 characters, <iteration count>=reasonable sized positive integer");
                    }
                    String salt = part[1];
                    try {
                        iterationCount = Integer.parseInt(part[2]);
                    }
                    catch (NumberFormatException e) {
                        throw new IOException("Masked password command has the wrong format.%nUsage: MASK-<encoded secret>;<salt>;<iteration count> where <salt>=UTF-8 characters, <iteration count>=reasonable sized positive integer");
                    }
                    try {
                        PasswordBasedEncryptionUtil decryptUtil = new PasswordBasedEncryptionUtil.Builder().picketBoxCompatibility().salt(salt).iteration(iterationCount).decryptMode().build();
                        return (C)((Credential)credentialType.cast(new PasswordCredential((Password)ClearPassword.createRaw((String)"clear", (char[])decryptUtil.decodeAndDecrypt(part[0])))));
                    }
                    catch (GeneralSecurityException e) {
                        throw new IOException(e);
                    }
                }
            };
        }
        return IdentityCredentials.NONE.withCredential((Credential)new PasswordCredential((Password)ClearPassword.createRaw((String)"clear", (char[])secret.toCharArray())));
    }
}

