/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.provider.wildfly;

import java.io.File;
import org.jboss.logging.Logger;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.keycloak.Config;
import org.keycloak.platform.PlatformProvider;
import org.keycloak.provider.wildfly.WildflyUtil;
import org.keycloak.services.ServicesLogger;

public class WildflyPlatform
implements PlatformProvider {
    private static final Logger log = Logger.getLogger(WildflyPlatform.class);
    private static final String DEFAULT_SCRIPT_ENGINE_MODULE = "org.openjdk.nashorn.nashorn-core";
    private static final String DEPLOYMENT_MODULE_NAME = "deployment.keycloak-server.war";
    Runnable shutdownHook;
    private File tmpDir;

    public void onStartup(Runnable startupHook) {
        startupHook.run();
    }

    public void onShutdown(Runnable shutdownHook) {
        this.shutdownHook = shutdownHook;
    }

    public void exit(Throwable cause) {
        ServicesLogger.LOGGER.fatal((Object)"Error during startup", cause);
        this.exit(1);
    }

    private void exit(final int status) {
        new Thread(){

            @Override
            public void run() {
                System.exit(status);
            }
        }.start();
    }

    public File getTmpDirectory() {
        if (this.tmpDir == null) {
            String tmpDirName = System.getProperty("jboss.server.temp.dir");
            if (tmpDirName == null) {
                throw new RuntimeException("System property jboss.server.temp.dir not set");
            }
            File tmpDir = new File(tmpDirName);
            if (tmpDir.isDirectory()) {
                this.tmpDir = tmpDir;
                log.debugf("Using server tmp directory: %s", (Object)tmpDir.getAbsolutePath());
            } else {
                throw new RuntimeException("Wildfly temp directory not exists under path: " + tmpDirName);
            }
        }
        return this.tmpDir;
    }

    public ClassLoader getScriptEngineClassLoader(Config.Scope scriptProviderConfig) {
        String engineModule = scriptProviderConfig.get("script-engine-module");
        if (engineModule == null) {
            engineModule = DEFAULT_SCRIPT_ENGINE_MODULE;
        }
        try {
            Module module = Module.getContextModuleLoader().loadModule(ModuleIdentifier.fromString((String)engineModule));
            log.infof("Found script engine module '%s'", (Object)engineModule);
            return module.getClassLoader();
        }
        catch (ModuleLoadException mle) {
            if (WildflyUtil.getJavaVersion() >= 15) {
                log.warnf("Cannot find script engine in the JBoss module '%s'. Please add JavaScript engine to the specified JBoss Module or make sure it is available on the classpath", (Object)engineModule);
                return null;
            }
            try {
                Module module = Module.getContextModuleLoader().loadModule(ModuleIdentifier.fromString((String)DEPLOYMENT_MODULE_NAME));
                log.debugf("Cannot find script engine in the JBoss module '%s'. Will fallback to the default script engine available from the module '%s'", (Object)engineModule, (Object)DEPLOYMENT_MODULE_NAME);
                return module.getClassLoader();
            }
            catch (ModuleLoadException mle2) {
                log.warnf("Cannot find script engine in the JBoss module '%s' and in the module '%s'. Please add JavaScript engine to the specified JBoss Module or make sure it is available on the classpath", (Object)engineModule, (Object)DEPLOYMENT_MODULE_NAME);
                return null;
            }
        }
    }
}

