/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ConnectionException;
import com.datastax.driver.core.ConvictionPolicy;
import com.datastax.driver.core.ExecutionInfo;
import com.datastax.driver.core.Token;
import com.datastax.driver.core.VersionNumber;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Host {
    private static final Logger logger = LoggerFactory.getLogger(Host.class);
    private final InetSocketAddress address;
    volatile State state;
    final ReentrantLock notificationsLock = new ReentrantLock(true);
    private final ConvictionPolicy policy;
    private final Cluster.Manager manager;
    final AtomicReference<ListenableFuture<?>> reconnectionAttempt = new AtomicReference();
    final ExecutionInfo defaultExecutionInfo;
    private volatile String datacenter;
    private volatile String rack;
    private volatile VersionNumber cassandraVersion;
    volatile InetAddress listenAddress;
    private volatile Set<Token> tokens;

    Host(InetSocketAddress address, ConvictionPolicy.Factory policy, Cluster.Manager manager) {
        if (address == null || policy == null) {
            throw new NullPointerException();
        }
        this.address = address;
        this.policy = policy.create(this);
        this.manager = manager;
        this.defaultExecutionInfo = new ExecutionInfo(ImmutableList.of(this));
        this.state = State.ADDED;
    }

    void setLocationInfo(String datacenter, String rack) {
        this.datacenter = datacenter;
        this.rack = rack;
    }

    void setVersionAndListenAdress(String cassandraVersion, InetAddress listenAddress) {
        if (listenAddress != null) {
            this.listenAddress = listenAddress;
        }
        if (cassandraVersion == null) {
            return;
        }
        try {
            this.cassandraVersion = VersionNumber.parse(cassandraVersion);
        }
        catch (IllegalArgumentException e) {
            logger.warn("Error parsing Cassandra version {}. This shouldn't have happened", (Object)cassandraVersion);
        }
    }

    public InetAddress getAddress() {
        return this.address.getAddress();
    }

    public InetSocketAddress getSocketAddress() {
        return this.address;
    }

    public String getDatacenter() {
        return this.datacenter;
    }

    public String getRack() {
        return this.rack;
    }

    public VersionNumber getCassandraVersion() {
        return this.cassandraVersion;
    }

    public Set<Token> getTokens() {
        return this.tokens;
    }

    void setTokens(Set<Token> tokens) {
        this.tokens = tokens;
    }

    public boolean isUp() {
        return this.state == State.UP;
    }

    public String getState() {
        return this.state.name();
    }

    public ListenableFuture<?> getReconnectionAttemptFuture() {
        return this.reconnectionAttempt.get();
    }

    public void tryReconnectOnce() {
        this.manager.startSingleReconnectionAttempt(this);
    }

    public boolean equals(Object other) {
        if (other instanceof Host) {
            Host that = (Host)other;
            return this.address.equals(that.address);
        }
        return false;
    }

    public int hashCode() {
        return this.address.hashCode();
    }

    boolean wasJustAdded() {
        return this.state == State.ADDED;
    }

    public String toString() {
        return this.address.toString();
    }

    void setDown() {
        this.state = State.DOWN;
    }

    void setUp() {
        this.policy.reset();
        this.state = State.UP;
    }

    boolean signalConnectionFailure(ConnectionException exception) {
        return this.policy.addFailure(exception);
    }

    public static interface StateListener {
        public void onAdd(Host var1);

        public void onUp(Host var1);

        public void onDown(Host var1);

        public void onRemove(Host var1);

        public void onRegister(Cluster var1);

        public void onUnregister(Cluster var1);
    }

    static enum State {
        ADDED,
        DOWN,
        UP;

    }
}

