/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.AggregateMetadata;
import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.FunctionMetadata;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.ReplicationStrategy;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.SimpleJSONParser;
import com.datastax.driver.core.TableMetadata;
import com.datastax.driver.core.UserType;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class KeyspaceMetadata {
    public static final String KS_NAME = "keyspace_name";
    private static final String DURABLE_WRITES = "durable_writes";
    private static final String STRATEGY_CLASS = "strategy_class";
    private static final String STRATEGY_OPTIONS = "strategy_options";
    private final String name;
    private final boolean durableWrites;
    private final ReplicationStrategy strategy;
    private final Map<String, String> replication;
    private final Map<String, TableMetadata> tables = new ConcurrentHashMap<String, TableMetadata>();
    private final Map<String, UserType> userTypes = new ConcurrentHashMap<String, UserType>();
    final Map<String, FunctionMetadata> functions = new ConcurrentHashMap<String, FunctionMetadata>();
    private final Map<String, AggregateMetadata> aggregates = new ConcurrentHashMap<String, AggregateMetadata>();

    @VisibleForTesting
    KeyspaceMetadata(String name, boolean durableWrites, Map<String, String> replication) {
        this.name = name;
        this.durableWrites = durableWrites;
        this.replication = replication;
        this.strategy = ReplicationStrategy.create(replication);
    }

    static KeyspaceMetadata build(Row row, List<Row> udtRows, ProtocolVersion protocolVersion, CodecRegistry codecRegistry) {
        String name = row.getString(KS_NAME);
        boolean durableWrites = row.getBool(DURABLE_WRITES);
        HashMap<String, String> replicationOptions = new HashMap<String, String>();
        replicationOptions.put("class", row.getString(STRATEGY_CLASS));
        replicationOptions.putAll(SimpleJSONParser.parseStringMap(row.getString(STRATEGY_OPTIONS)));
        KeyspaceMetadata ksm = new KeyspaceMetadata(name, durableWrites, replicationOptions);
        if (udtRows == null) {
            return ksm;
        }
        ksm.addUserTypes(udtRows, protocolVersion, codecRegistry);
        return ksm;
    }

    public String getName() {
        return this.name;
    }

    public boolean isDurableWrites() {
        return this.durableWrites;
    }

    public Map<String, String> getReplication() {
        return Collections.unmodifiableMap(this.replication);
    }

    public TableMetadata getTable(String name) {
        return this.tables.get(Metadata.handleId(name));
    }

    void removeTable(String table) {
        this.tables.remove(table);
    }

    public Collection<TableMetadata> getTables() {
        return Collections.unmodifiableCollection(this.tables.values());
    }

    public UserType getUserType(String name) {
        return this.userTypes.get(Metadata.handleId(name));
    }

    public Collection<UserType> getUserTypes() {
        return Collections.unmodifiableCollection(this.userTypes.values());
    }

    void addUserTypes(List<Row> udtRows, ProtocolVersion protocolVersion, CodecRegistry codecRegistry) {
        for (Row r : udtRows) {
            UserType def = UserType.build(r, protocolVersion, codecRegistry);
            this.userTypes.put(def.getTypeName(), def);
        }
    }

    void removeUserType(String userType) {
        this.userTypes.remove(userType);
    }

    public FunctionMetadata getFunction(String name, Collection<DataType> argumentTypes) {
        return this.functions.get(Metadata.fullFunctionName(Metadata.handleId(name), argumentTypes));
    }

    public FunctionMetadata getFunction(String name, DataType ... argumentTypes) {
        return this.getFunction(name, Lists.newArrayList(argumentTypes));
    }

    public Collection<FunctionMetadata> getFunctions() {
        return Collections.unmodifiableCollection(this.functions.values());
    }

    void removeFunction(String fullName) {
        this.functions.remove(fullName);
    }

    public AggregateMetadata getAggregate(String name, Collection<DataType> argumentTypes) {
        return this.aggregates.get(Metadata.fullFunctionName(Metadata.handleId(name), argumentTypes));
    }

    public AggregateMetadata getAggregate(String name, DataType ... argumentTypes) {
        return this.getAggregate(name, Lists.newArrayList(argumentTypes));
    }

    public Collection<AggregateMetadata> getAggregates() {
        return Collections.unmodifiableCollection(this.aggregates.values());
    }

    void removeAggregate(String fullName) {
        this.functions.remove(fullName);
    }

    public String exportAsString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.asCQLQuery()).append('\n');
        for (UserType udt : this.userTypes.values()) {
            sb.append('\n').append(udt.exportAsString()).append('\n');
        }
        for (TableMetadata tm : this.tables.values()) {
            sb.append('\n').append(tm.exportAsString()).append('\n');
        }
        for (FunctionMetadata fm : this.functions.values()) {
            sb.append('\n').append(fm.exportAsString()).append('\n');
        }
        for (AggregateMetadata am : this.aggregates.values()) {
            sb.append('\n').append(am.exportAsString()).append('\n');
        }
        return sb.toString();
    }

    public String asCQLQuery() {
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE KEYSPACE ").append(Metadata.escapeId(this.name)).append(" WITH ");
        sb.append("REPLICATION = { 'class' : '").append(this.replication.get("class")).append('\'');
        for (Map.Entry<String, String> entry : this.replication.entrySet()) {
            if (entry.getKey().equals("class")) continue;
            sb.append(", '").append(entry.getKey()).append("': '").append(entry.getValue()).append('\'');
        }
        sb.append(" } AND DURABLE_WRITES = ").append(this.durableWrites);
        sb.append(';');
        return sb.toString();
    }

    public String toString() {
        return this.asCQLQuery();
    }

    void add(TableMetadata tm) {
        this.tables.put(tm.getName(), tm);
    }

    void add(FunctionMetadata function) {
        this.functions.put(function.getFullName(), function);
    }

    void add(AggregateMetadata aggregate) {
        this.aggregates.put(aggregate.getFullName(), aggregate);
    }

    ReplicationStrategy replicationStrategy() {
        return this.strategy;
    }
}

