/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.util;

import io.undertow.UndertowMessages;
import io.undertow.connector.PooledByteBuffer;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

public class ReferenceCountedPooled
implements PooledByteBuffer {
    private final PooledByteBuffer underlying;
    private volatile int referenceCount;
    boolean mainFreed = false;
    private ByteBuffer slice = null;
    private final FreeNotifier freeNotifier;
    private static final AtomicIntegerFieldUpdater<ReferenceCountedPooled> referenceCountUpdater = AtomicIntegerFieldUpdater.newUpdater(ReferenceCountedPooled.class, "referenceCount");

    public ReferenceCountedPooled(PooledByteBuffer underlying, int referenceCount) {
        this(underlying, referenceCount, null);
    }

    public ReferenceCountedPooled(PooledByteBuffer underlying, int referenceCount, FreeNotifier freeNotifier) {
        this.underlying = underlying;
        this.referenceCount = referenceCount;
        this.freeNotifier = freeNotifier;
    }

    @Override
    public void close() {
        if (this.mainFreed) {
            return;
        }
        this.mainFreed = true;
        this.freeInternal();
    }

    @Override
    public boolean isOpen() {
        return !this.mainFreed;
    }

    public boolean isFreed() {
        return this.mainFreed;
    }

    public boolean tryUnfree() {
        int refs;
        do {
            if ((refs = referenceCountUpdater.get(this)) > 0) continue;
            return false;
        } while (!referenceCountUpdater.compareAndSet(this, refs, refs + 1));
        ByteBuffer resource = this.slice != null ? this.slice : this.underlying.getBuffer();
        resource.position(resource.limit());
        resource.limit(resource.capacity());
        this.slice = resource.slice();
        this.mainFreed = false;
        return true;
    }

    private void freeInternal() {
        if (referenceCountUpdater.decrementAndGet(this) == 0) {
            this.underlying.close();
            if (this.freeNotifier != null) {
                this.freeNotifier.freed();
            }
        }
    }

    @Override
    public ByteBuffer getBuffer() throws IllegalStateException {
        if (this.mainFreed) {
            throw UndertowMessages.MESSAGES.bufferAlreadyFreed();
        }
        if (this.slice != null) {
            return this.slice;
        }
        return this.underlying.getBuffer();
    }

    public PooledByteBuffer createView(final ByteBuffer newValue) {
        this.increaseReferenceCount();
        return new PooledByteBuffer(){
            boolean free = false;

            @Override
            public void close() {
                if (!this.free) {
                    this.free = true;
                    ReferenceCountedPooled.this.freeInternal();
                }
            }

            @Override
            public boolean isOpen() {
                return !this.free;
            }

            @Override
            public ByteBuffer getBuffer() throws IllegalStateException {
                if (this.free) {
                    throw UndertowMessages.MESSAGES.bufferAlreadyFreed();
                }
                return newValue;
            }
        };
    }

    public void increaseReferenceCount() {
        int val;
        do {
            if ((val = referenceCountUpdater.get(this)) != 0) continue;
            throw UndertowMessages.MESSAGES.objectWasFreed();
        } while (!referenceCountUpdater.compareAndSet(this, val, val + 1));
    }

    public static interface FreeNotifier {
        public void freed();
    }
}

