/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import java.lang.annotation.Annotation;
import java.util.Iterator;
import java.util.Set;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.CDI;
import javax.enterprise.inject.spi.Unmanaged;
import javax.enterprise.util.TypeLiteral;
import org.jboss.weld.bean.builtin.BeanManagerProxy;
import org.jboss.weld.logging.BeanManagerLogger;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.util.cache.LoadingCacheUtils;
import org.jboss.weld.util.reflection.Reflections;

public abstract class AbstractCDI<T>
extends CDI<T> {
    protected final Set<String> knownClassNames;
    private final LoadingCache<BeanManagerImpl, Instance<T>> instanceCache;

    public AbstractCDI() {
        ImmutableSet.Builder names = ImmutableSet.builder();
        for (Class<?> clazz = this.getClass(); clazz != CDI.class; clazz = clazz.getSuperclass()) {
            names.add(clazz.getName());
        }
        names.add(Unmanaged.class.getName());
        this.knownClassNames = names.build();
        this.instanceCache = CacheBuilder.newBuilder().build(new CacheLoader<BeanManagerImpl, Instance<T>>(){

            @Override
            public Instance<T> load(BeanManagerImpl beanManager) throws Exception {
                return (Instance)Reflections.cast(beanManager.getInstance(beanManager.createCreationalContext((Contextual)null)));
            }
        });
    }

    @Override
    public Iterator<T> iterator() {
        return this.getInstance().iterator();
    }

    @Override
    public T get() {
        return this.getInstance().get();
    }

    @Override
    public Instance<T> select(Annotation ... qualifiers) {
        return this.getInstance().select(qualifiers);
    }

    @Override
    public <U extends T> Instance<U> select(Class<U> subtype, Annotation ... qualifiers) {
        return this.getInstance().select(subtype, qualifiers);
    }

    @Override
    public <U extends T> Instance<U> select(TypeLiteral<U> subtype, Annotation ... qualifiers) {
        return this.getInstance().select(subtype, qualifiers);
    }

    @Override
    public boolean isUnsatisfied() {
        return this.getInstance().isUnsatisfied();
    }

    @Override
    public boolean isAmbiguous() {
        return this.getInstance().isAmbiguous();
    }

    @Override
    public void destroy(T instance) {
        this.getInstance().destroy(instance);
    }

    protected String getCallingClassName() {
        boolean outerSubclassReached = false;
        for (StackTraceElement element : Thread.currentThread().getStackTrace()) {
            if (!this.knownClassNames.contains(element.getClassName())) {
                if (!outerSubclassReached) continue;
                return element.getClassName();
            }
            outerSubclassReached = true;
        }
        throw BeanManagerLogger.LOG.unableToIdentifyBeanManager();
    }

    protected Instance<T> getInstance() {
        return (Instance)LoadingCacheUtils.getCastCacheValue(this.instanceCache, BeanManagerProxy.unwrap(this.getBeanManager()));
    }
}

