/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.secretstore.api.internal;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.Session;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Inject;
import org.keycloak.secretstore.api.internal.BoundStatements;
import org.keycloak.secretstore.api.internal.NamedStatement;
import org.keycloak.secretstore.api.internal.SecretStore;

@ApplicationScoped
public class ApplicationResources {
    @Inject
    @SecretStore
    Session session;
    private Map<BoundStatements, PreparedStatement> statements = new HashMap<BoundStatements, PreparedStatement>(BoundStatements.values().length);

    @PostConstruct
    public void buildStatements() {
        for (BoundStatements statement : BoundStatements.values()) {
            this.statements.put(statement, this.session.prepare(statement.getValue()));
        }
    }

    @Produces
    @NamedStatement
    public BoundStatement produceStatementByName(InjectionPoint injectionPoint) {
        NamedStatement annotation = injectionPoint.getAnnotated().getAnnotation(NamedStatement.class);
        BoundStatements stmtName = annotation.value();
        return this.statements.get((Object)stmtName).bind();
    }
}

