/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.secretstore.common.internal;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.Session;
import java.util.concurrent.Callable;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.keycloak.secretstore.common.CassandraNodes;
import org.keycloak.secretstore.common.CassandraPort;
import org.keycloak.secretstore.common.internal.MsgLogger;

@ApplicationScoped
public class CassandraSessionCallable
implements Callable<Session> {
    private static final String CASSANDRA_RETRY_ATTEMPTS = "hawkular-accounts.cassandra-retry-attempts";
    private static final String CASSANDRA_RETRY_INTERVAL = "hawkular-accounts.cassandra-retry-interval";
    private static int attempts = Integer.parseInt(System.getProperty("hawkular-accounts.cassandra-retry-attempts", "15"));
    private static int interval = Integer.parseInt(System.getProperty("hawkular-accounts.cassandra-retry-interval", "4000"));
    MsgLogger logger = MsgLogger.LOGGER;
    @Inject
    @CassandraPort
    String cqlPort;
    @Inject
    @CassandraNodes
    String nodes;

    @Override
    public Session call() throws Exception {
        try {
            return new Cluster.Builder().addContactPoints(this.nodes.split(",")).withPort(new Integer(this.cqlPort)).withProtocolVersion(ProtocolVersion.V3).withoutJMXReporting().build().connect();
        }
        catch (Exception e) {
            if (attempts != 0) {
                this.logger.attemptToConnectToCassandraFailed(attempts, e);
                --attempts;
                Thread.sleep(interval);
                return this.call();
            }
            this.logger.cannotConnectToCassandra(e);
            return null;
        }
    }
}

