/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.secretstore.proxy;

import io.undertow.client.ClientCallback;
import io.undertow.client.ClientConnection;
import io.undertow.client.UndertowClient;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.ServerConnection;
import io.undertow.server.handlers.proxy.ProxyCallback;
import io.undertow.server.handlers.proxy.ProxyClient;
import io.undertow.server.handlers.proxy.ProxyConnection;
import io.undertow.util.AttachmentKey;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.keycloak.secretstore.api.RequestRewriter;
import org.xnio.IoUtils;
import org.xnio.OptionMap;

public class TokenReplacingProxyHandler
implements ProxyClient {
    private static final ProxyClient.ProxyTarget TARGET = new ProxyClient.ProxyTarget(){};
    private final AttachmentKey<ClientConnection> clientAttachmentKey = AttachmentKey.create(ClientConnection.class);
    private final UndertowClient client = UndertowClient.getInstance();
    @Inject
    RequestRewriter requestRewriter;

    @Override
    public ProxyClient.ProxyTarget findTarget(HttpServerExchange exchange) {
        return TARGET;
    }

    @Override
    public void getConnection(ProxyClient.ProxyTarget target, HttpServerExchange exchange, ProxyCallback<ProxyConnection> callback, long timeout, TimeUnit timeUnit) {
        try {
            exchange = this.requestRewriter.rewrite(exchange);
        }
        catch (Exception e) {
            callback.failed(exchange);
            e.printStackTrace();
        }
        ClientConnection existing = exchange.getConnection().getAttachment(this.clientAttachmentKey);
        if (existing != null) {
            if (existing.isOpen()) {
                callback.completed(exchange, new ProxyConnection(existing, exchange.getRequestURI()));
                return;
            }
            exchange.getConnection().removeAttachment(this.clientAttachmentKey);
        }
        try {
            this.client.connect((ClientCallback<ClientConnection>)new ConnectNotifier(callback, exchange), new URI(exchange.getRequestURI()), exchange.getIoThread(), exchange.getConnection().getByteBufferPool(), OptionMap.EMPTY);
        }
        catch (URISyntaxException e) {
            callback.failed(exchange);
            e.printStackTrace();
        }
    }

    private final class ConnectNotifier
    implements ClientCallback<ClientConnection> {
        private final ProxyCallback<ProxyConnection> callback;
        private final HttpServerExchange exchange;

        private ConnectNotifier(ProxyCallback<ProxyConnection> callback, HttpServerExchange exchange) {
            this.callback = callback;
            this.exchange = exchange;
        }

        @Override
        public void completed(ClientConnection connection) {
            ServerConnection serverConnection = this.exchange.getConnection();
            serverConnection.putAttachment(TokenReplacingProxyHandler.this.clientAttachmentKey, connection);
            serverConnection.addCloseListener(serverConnection1 -> IoUtils.safeClose((Closeable)connection));
            connection.getCloseSetter().set(channel -> {
                ClientConnection cfr_ignored_0 = (ClientConnection)serverConnection.removeAttachment(TokenReplacingProxyHandler.this.clientAttachmentKey);
            });
            this.callback.completed(this.exchange, new ProxyConnection(connection, ""));
        }

        @Override
        public void failed(IOException e) {
            this.callback.failed(this.exchange);
        }
    }
}

