/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.secretstore.undertow.filter;

import io.undertow.servlet.ServletExtension;
import io.undertow.servlet.api.DeploymentInfo;
import javax.servlet.ServletContext;
import org.keycloak.secretstore.undertow.filter.AgentHttpHandler;
import org.keycloak.secretstore.undertow.filter.MsgLogger;

public class SecretStoreServletExtension
implements ServletExtension {
    private final MsgLogger logger = MsgLogger.LOGGER;

    @Override
    public void handleDeployment(DeploymentInfo deploymentInfo, ServletContext servletContext) {
        if (deploymentInfo.isAuthenticationMechanismPresent("KEYCLOAK")) {
            boolean enabled = Boolean.valueOf(servletContext.getInitParameter("org.keycloak.secretstore.enabled"));
            if (enabled) {
                this.logger.secretStoreEnabled();
                deploymentInfo.addOuterHandlerChainWrapper(AgentHttpHandler::new);
            } else {
                this.logger.secretStoreNotEnabled();
            }
        }
    }
}

