/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.secretstore.api;

import io.undertow.server.HttpServerExchange;
import io.undertow.util.HeaderValues;
import io.undertow.util.HttpString;
import java.io.StringReader;
import java.net.URLEncoder;
import java.time.ZonedDateTime;
import java.util.Base64;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.annotation.security.PermitAll;
import javax.ejb.Singleton;
import javax.inject.Inject;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonReader;
import org.keycloak.secretstore.api.Token;
import org.keycloak.secretstore.api.TokenService;
import org.keycloak.secretstore.api.internal.MsgLogger;
import org.keycloak.secretstore.common.AuthServerRequestExecutor;
import org.keycloak.secretstore.common.AuthServerUrl;
import org.keycloak.secretstore.common.RealmName;

@Singleton
@PermitAll
public class RequestRewriter {
    private static final Pattern UUID_PATTERN = Pattern.compile("[0-9a-f]{8}-[0-9a-f]{4}-[1-5][0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}");
    private final MsgLogger logger = MsgLogger.LOGGER;
    @Inject
    @RealmName
    String realmName;
    @Inject
    @AuthServerUrl
    String authServerUrl;
    @Inject
    AuthServerRequestExecutor authServerRequestExecutor;
    @Inject
    TokenService tokenService;

    public HttpServerExchange rewrite(HttpServerExchange httpServerExchange) throws Exception {
        UUID key;
        HeaderValues authorizationHeaders = httpServerExchange.getRequestHeaders().get("Authorization");
        if (authorizationHeaders == null || authorizationHeaders.size() < 1) {
            this.logger.noAuthorizationHeader();
            return httpServerExchange;
        }
        String authorizationHeader = authorizationHeaders.getFirst();
        String[] authorizationHeaderParts = authorizationHeader.trim().split("\\s+");
        if (authorizationHeaderParts.length != 2) {
            this.logger.authorizationHeaderInvalid(authorizationHeader);
            return httpServerExchange;
        }
        if (!authorizationHeaderParts[0].equalsIgnoreCase("Basic")) {
            this.logger.noBasicAuth();
            return httpServerExchange;
        }
        String authorization = new String(Base64.getDecoder().decode(authorizationHeaderParts[1]));
        String[] parts = authorization.split(":");
        if (parts.length != 2) {
            this.logger.authorizationValueInvalid(authorization);
            return httpServerExchange;
        }
        String keyAsString = parts[0];
        String secret = parts[1];
        if (keyAsString == null || keyAsString.isEmpty()) {
            this.logger.keyIsEmpty();
            return httpServerExchange;
        }
        if (!UUID_PATTERN.matcher(keyAsString).matches()) {
            this.logger.notLikeUUID(keyAsString);
            return httpServerExchange;
        }
        try {
            key = UUID.fromString(keyAsString);
        }
        catch (Throwable t) {
            this.logger.notAnUUID(keyAsString);
            return httpServerExchange;
        }
        Token token = this.tokenService.validate(key, secret);
        if (token == null) {
            this.logger.tokenNotFound(keyAsString);
            httpServerExchange.setStatusCode(403);
            httpServerExchange.endExchange();
            return null;
        }
        if (null != token.getExpiresAt() && ZonedDateTime.now().isAfter(token.getExpiresAt())) {
            this.logger.tokenExpired(token.getId().toString(), token.getExpiresAt().toString(), ZonedDateTime.now().toString());
            httpServerExchange.setStatusCode(403);
            httpServerExchange.endExchange();
            return null;
        }
        String bearerToken = this.getBearerToken(token);
        if (bearerToken == null) {
            this.logger.cannotGetBearerToken(token.getId().toString());
            httpServerExchange.setStatusCode(403);
            httpServerExchange.endExchange();
            return null;
        }
        this.logger.tokenReplaced(token.getId().toString(), bearerToken);
        httpServerExchange.getRequestHeaders().remove("Authorization");
        httpServerExchange.getRequestHeaders().put(new HttpString("Authorization"), "Bearer " + bearerToken);
        token.getAttributes().forEach((k, v) -> {
            httpServerExchange.getRequestHeaders().remove((String)k);
            httpServerExchange.getRequestHeaders().put(new HttpString((String)k), (String)v);
        });
        return httpServerExchange;
    }

    private String getBearerToken(Token token) throws Exception {
        String urlParameters;
        String tokenUrl = this.authServerUrl + "/realms/" + URLEncoder.encode(this.realmName, "UTF-8") + "/protocol/openid-connect/token";
        String sResponse = this.authServerRequestExecutor.execute(tokenUrl, urlParameters = "scope=offline_access&grant_type=refresh_token&refresh_token=" + URLEncoder.encode(token.getRefreshToken(), "UTF-8"), "POST");
        JsonReader jsonReader = Json.createReader(new StringReader(sResponse));
        JsonObject object = jsonReader.readObject();
        if (object.get("error") != null) {
            String error = object.getString("error");
            this.logger.errorResponseFromServer(error);
            return null;
        }
        String tokenType = object.getString("token_type");
        String bearerToken = object.getString("access_token");
        if (null == tokenType || tokenType.isEmpty() || !tokenType.equalsIgnoreCase("bearer")) {
            this.logger.invalidResponseFromServer();
            return null;
        }
        if (null == bearerToken || bearerToken.isEmpty()) {
            this.logger.invalidBearerTokenFromServer();
            return null;
        }
        return bearerToken;
    }
}

