/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.secretstore.common;

import java.io.StringReader;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.servlet.ServletContext;
import org.keycloak.secretstore.common.AuthServerUrl;
import org.keycloak.secretstore.common.CassandraNodes;
import org.keycloak.secretstore.common.CassandraPort;
import org.keycloak.secretstore.common.RealmConfiguration;
import org.keycloak.secretstore.common.RealmName;
import org.keycloak.secretstore.common.RealmResourceName;
import org.keycloak.secretstore.common.RealmResourceSecret;

@ApplicationScoped
public class ApplicationResources {
    private static final String REALM_CONFIG_KEY = "org.keycloak.json.adapterConfig";
    private String realmConfiguration = null;
    private ServletContext servletContext;
    private boolean realmConfigurationParsed = false;
    private String realmName;
    private String serverUrl;
    private String resourceName;
    private String secret;
    private String cassandraPort;
    private String cassandraNodes;

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    @Produces
    @CassandraNodes
    public String getCassandraNodes() {
        if (null == this.cassandraNodes) {
            this.cassandraNodes = System.getenv("CASSANDRA_NODES");
            if (null == this.cassandraNodes || this.cassandraNodes.isEmpty()) {
                this.cassandraNodes = "127.0.0.1";
            }
        }
        return this.cassandraNodes;
    }

    @Produces
    @CassandraPort
    public String getCassandraPort() {
        if (null == this.cassandraPort) {
            this.cassandraPort = System.getenv("CASSANDRA_CQL_PORT");
            if (null == this.cassandraPort || this.cassandraPort.isEmpty()) {
                this.cassandraPort = "9042";
            }
        }
        return this.cassandraPort;
    }

    @Produces
    @RealmConfiguration
    public String getRealmConfiguration() {
        if (null == this.realmConfiguration) {
            this.realmConfiguration = this.servletContext.getInitParameter(REALM_CONFIG_KEY);
        }
        return this.realmConfiguration;
    }

    @Produces
    @RealmName
    public String getRealmName() {
        if (!this.realmConfigurationParsed) {
            this.parseRealmConfiguration();
        }
        return this.realmName;
    }

    @Produces
    @AuthServerUrl
    public String getServerUrl() {
        if (!this.realmConfigurationParsed) {
            this.parseRealmConfiguration();
        }
        return this.serverUrl;
    }

    @Produces
    @RealmResourceName
    public String getResourceName() {
        if (!this.realmConfigurationParsed) {
            this.parseRealmConfiguration();
        }
        return this.resourceName;
    }

    @Produces
    @RealmResourceSecret
    public String getResourceNameSecret() {
        if (!this.realmConfigurationParsed) {
            this.parseRealmConfiguration();
        }
        return this.secret;
    }

    private void parseRealmConfiguration() {
        JsonReader jsonReader = Json.createReader(new StringReader(this.getRealmConfiguration()));
        JsonObject configurationJson = jsonReader.readObject();
        JsonObject credentials = configurationJson.getJsonObject("credentials");
        this.realmName = configurationJson.getString("realm");
        this.resourceName = configurationJson.getString("resource");
        this.secret = credentials.getString("secret");
        if (configurationJson.containsKey("auth-server-url-for-backend-requests")) {
            this.serverUrl = configurationJson.getString("auth-server-url-for-backend-requests");
        } else {
            String authContextPath = "/auth";
            if (configurationJson.containsKey("auth-server-url")) {
                authContextPath = configurationJson.getString("auth-server-url");
            }
            int portOffset = Integer.parseInt(System.getProperty("jboss.socket.binding.port-offset", "0"));
            int defaultPort = Integer.parseInt(System.getProperty("jboss.http.port", "8080"));
            String host = System.getProperty("jboss.bind.address", "127.0.0.1");
            this.serverUrl = authContextPath.toLowerCase().startsWith("http") ? authContextPath : "http://" + host + ":" + (defaultPort + portOffset) + authContextPath;
        }
        this.realmConfigurationParsed = true;
    }
}

