/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.secretstore.proxy.internal;

import com.esotericsoftware.yamlbeans.YamlException;
import com.esotericsoftware.yamlbeans.YamlReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.Reader;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Alternative;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.jboss.weld.environment.se.bindings.Parameters;
import org.keycloak.secretstore.common.AuthServerUrl;
import org.keycloak.secretstore.common.RealmName;
import org.keycloak.secretstore.common.RealmResourceName;
import org.keycloak.secretstore.common.RealmResourceSecret;
import org.keycloak.secretstore.proxy.internal.BindTo;
import org.keycloak.secretstore.proxy.internal.Configuration;
import org.keycloak.secretstore.proxy.internal.Port;

@ApplicationScoped
public class ApplicationResources {
    @Inject
    @Parameters
    String[] parameters;
    private CommandLine cmd;
    private Configuration configuration;

    @PostConstruct
    public void prepareCommandLineOptions() {
        InputStreamReader configurationReader;
        Options options = new Options();
        options.addOption("c", "configuration", true, "Configuration file");
        options.addOption("r", "realm-name", true, "Realm name");
        options.addOption("rn", "realm-resource", true, "Resource name");
        options.addOption("rs", "realm-secret", true, "Resource secret");
        options.addOption("u", "auth-server-url", true, "Keycloak Server URL");
        options.addOption("b", "bind", true, "IP address to bind to");
        options.addOption("p", "port", true, "Port to bind to");
        try {
            this.cmd = new DefaultParser().parse(options, this.parameters, false);
        }
        catch (ParseException e) {
            throw new RuntimeException("Could not parse configuration file", e);
        }
        if (this.cmd.hasOption("c")) {
            try {
                configurationReader = new FileReader(this.cmd.getOptionValue("c"));
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException("Could not load configuration file", e);
            }
        } else {
            configurationReader = new InputStreamReader(this.getClass().getResourceAsStream("/configuration.yml"));
        }
        YamlReader reader = new YamlReader((Reader)configurationReader);
        try {
            this.configuration = (Configuration)reader.read(Configuration.class);
        }
        catch (YamlException e) {
            throw new RuntimeException("Could not read configuration file", e);
        }
        if (this.cmd.hasOption("r")) {
            this.configuration.setRealmName(this.cmd.getOptionValue("r"));
        }
        if (this.cmd.hasOption("rn")) {
            this.configuration.setResourceName(this.cmd.getOptionValue("rn"));
        }
        if (this.cmd.hasOption("rs")) {
            this.configuration.setResourceSecret(this.cmd.getOptionValue("rs"));
        }
        if (this.cmd.hasOption("u")) {
            this.configuration.setAuthServerUrl(this.cmd.getOptionValue("u"));
        }
        if (this.cmd.hasOption("b")) {
            this.configuration.setBind(this.cmd.getOptionValue("b"));
        }
        if (this.cmd.hasOption("p")) {
            this.configuration.setPort(Integer.parseInt(this.cmd.getOptionValue("p")));
        }
    }

    @Alternative
    @Produces
    @RealmName
    public String getRealmName() {
        return this.configuration.getRealmName();
    }

    @Alternative
    @Produces
    @RealmResourceName
    public String getRealmResourceName() {
        return this.configuration.getResourceName();
    }

    @Alternative
    @Produces
    @RealmResourceSecret
    public String getRealmResourceSecret() {
        return this.configuration.getResourceSecret();
    }

    @Alternative
    @Produces
    @AuthServerUrl
    public String getAuthServerUrl() {
        return this.configuration.getAuthServerUrl();
    }

    @Produces
    @Port
    public int getPort() {
        return this.configuration.getPort();
    }

    @Produces
    @BindTo
    public String getBindTo() {
        return this.configuration.getBind();
    }
}

