/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.CodecUtils;
import com.datastax.driver.core.Configuration;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.RegularStatement;
import java.nio.ByteBuffer;

public class SimpleStatement
extends RegularStatement {
    private final String query;
    private final Object[] values;
    private final Cluster cluster;
    private volatile ByteBuffer routingKey;
    private volatile String keyspace;

    protected SimpleStatement(String query, Cluster cluster) {
        this(query, cluster, null);
    }

    protected SimpleStatement(String query, Cluster cluster, Object ... values) {
        if (values != null && values.length > 65535) {
            throw new IllegalArgumentException("Too many values, the maximum allowed is 65535");
        }
        this.query = query;
        this.values = values;
        this.cluster = cluster;
    }

    @Override
    public String getQueryString() {
        return this.query;
    }

    @Override
    public ByteBuffer[] getValues() {
        if (this.values == null) {
            return null;
        }
        this.cluster.init();
        Configuration configuration = this.cluster.getConfiguration();
        ProtocolVersion protocolVersion = configuration.getProtocolOptions().getProtocolVersion();
        CodecRegistry codecRegistry = configuration.getCodecRegistry();
        return CodecUtils.convert(this.values, protocolVersion, codecRegistry);
    }

    public int valuesCount() {
        return this.values == null ? 0 : this.values.length;
    }

    @Override
    public boolean hasValues() {
        return this.values != null && this.values.length > 0;
    }

    @Override
    public ByteBuffer getRoutingKey() {
        return this.routingKey;
    }

    public SimpleStatement setRoutingKey(ByteBuffer routingKey) {
        this.routingKey = routingKey;
        return this;
    }

    @Override
    public String getKeyspace() {
        return this.keyspace;
    }

    public SimpleStatement setKeyspace(String keyspace) {
        this.keyspace = keyspace;
        return this;
    }

    public SimpleStatement setRoutingKey(ByteBuffer ... routingKeyComponents) {
        this.routingKey = CodecUtils.compose(routingKeyComponents);
        return this;
    }
}

