/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.querybuilder;

import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.TypeCodec;
import com.datastax.driver.core.querybuilder.Assignment;
import com.datastax.driver.core.querybuilder.BindMarker;
import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

abstract class Utils {
    private static final Pattern cnamePattern = Pattern.compile("\\w+(?:\\[.+\\])?");

    Utils() {
    }

    static StringBuilder joinAndAppend(StringBuilder sb, CodecRegistry codecRegistry, String separator, List<? extends Appendeable> values, List<Object> variables) {
        for (int i = 0; i < values.size(); ++i) {
            if (i > 0) {
                sb.append(separator);
            }
            values.get(i).appendTo(sb, variables, codecRegistry);
        }
        return sb;
    }

    static StringBuilder joinAndAppendNames(StringBuilder sb, CodecRegistry codecRegistry, String separator, List<?> values) {
        for (int i = 0; i < values.size(); ++i) {
            if (i > 0) {
                sb.append(separator);
            }
            Utils.appendName(values.get(i), codecRegistry, sb);
        }
        return sb;
    }

    static StringBuilder joinAndAppendValues(StringBuilder sb, CodecRegistry codecRegistry, String separator, List<?> values, List<Object> variables) {
        for (int i = 0; i < values.size(); ++i) {
            if (i > 0) {
                sb.append(separator);
            }
            Utils.appendValue(values.get(i), codecRegistry, sb, variables);
        }
        return sb;
    }

    private static boolean isForceAppendToQueryString(Object value) {
        return value instanceof Number && !(value instanceof BigInteger) && !(value instanceof BigDecimal);
    }

    static StringBuilder appendValue(Object value, CodecRegistry codecRegistry, StringBuilder sb, List<Object> variables) {
        if (value == null) {
            sb.append("null");
        } else if (value instanceof BindMarker) {
            sb.append(value);
        } else if (value instanceof FCall) {
            FCall fcall = (FCall)value;
            sb.append(fcall.name).append('(');
            for (int i = 0; i < fcall.parameters.length; ++i) {
                if (i > 0) {
                    sb.append(',');
                }
                Utils.appendValue(fcall.parameters[i], codecRegistry, sb, variables);
            }
            sb.append(')');
        } else if (value instanceof CName) {
            Utils.appendName(((CName)value).name, codecRegistry, sb);
        } else if (value instanceof RawString) {
            sb.append(value.toString());
        } else if (variables == null || Utils.isForceAppendToQueryString(value)) {
            TypeCodec<Object> codec = codecRegistry.codecFor(value);
            sb.append(codec.format(value));
        } else {
            sb.append('?');
            variables.add(value);
            return sb;
        }
        return sb;
    }

    static boolean containsBindMarker(Object value) {
        if (value instanceof BindMarker) {
            return true;
        }
        if (!(value instanceof FCall)) {
            return false;
        }
        FCall fcall = (FCall)value;
        for (Object param : fcall.parameters) {
            if (!Utils.containsBindMarker(param)) continue;
            return true;
        }
        return false;
    }

    static boolean isIdempotent(Object value) {
        if (value == null) {
            return true;
        }
        if (value instanceof Assignment) {
            Assignment assignment = (Assignment)value;
            return assignment.isIdempotent();
        }
        if (value instanceof FCall) {
            return false;
        }
        if (value instanceof RawString) {
            return false;
        }
        if (value instanceof Collection) {
            for (Object elt : (Collection)value) {
                if (Utils.isIdempotent(elt)) continue;
                return false;
            }
            return true;
        }
        if (value instanceof Map) {
            for (Map.Entry entry : ((Map)value).entrySet()) {
                if (Utils.isIdempotent(entry.getKey()) && Utils.isIdempotent(entry.getValue())) continue;
                return false;
            }
        }
        return true;
    }

    static boolean isRawValue(Object value) {
        return value != null && !(value instanceof FCall) && !(value instanceof CName) && !(value instanceof BindMarker);
    }

    static StringBuilder appendName(String name, StringBuilder sb) {
        if (cnamePattern.matcher(name = name.trim()).matches() || name.startsWith("\"") || name.startsWith("token(")) {
            sb.append(name);
        } else {
            sb.append('\"').append(name).append('\"');
        }
        return sb;
    }

    static StringBuilder appendName(Object name, CodecRegistry codecRegistry, StringBuilder sb) {
        if (name instanceof String) {
            Utils.appendName((String)name, sb);
        } else if (name instanceof CName) {
            Utils.appendName(((CName)name).name, codecRegistry, sb);
        } else if (name instanceof FCall) {
            FCall fcall = (FCall)name;
            sb.append(fcall.name).append('(');
            for (int i = 0; i < fcall.parameters.length; ++i) {
                if (i > 0) {
                    sb.append(',');
                }
                Utils.appendValue(fcall.parameters[i], codecRegistry, sb, null);
            }
            sb.append(')');
        } else if (name instanceof Alias) {
            Alias alias = (Alias)name;
            Utils.appendName(alias.column, codecRegistry, sb);
            sb.append(" AS ").append(alias.alias);
        } else if (name instanceof RawString) {
            sb.append(((RawString)name).str);
        } else {
            throw new IllegalArgumentException(String.format("Invalid column %s of type unknown of the query builder", name));
        }
        return sb;
    }

    static class Alias {
        private final Object column;
        private final String alias;

        Alias(Object column, String alias) {
            this.column = column;
            this.alias = alias;
        }

        public String toString() {
            return String.format("%s AS %s", this.column, this.alias);
        }
    }

    static class CName {
        private final String name;

        CName(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    static class FCall {
        private final String name;
        private final Object[] parameters;

        FCall(String name, Object ... parameters) {
            Preconditions.checkNotNull(name);
            this.name = name;
            this.parameters = parameters;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.name).append('(');
            for (int i = 0; i < this.parameters.length; ++i) {
                if (i > 0) {
                    sb.append(',');
                }
                sb.append(this.parameters[i]);
            }
            sb.append(')');
            return sb.toString();
        }
    }

    static class RawString {
        private final String str;

        RawString(String str) {
            this.str = str;
        }

        public String toString() {
            return this.str;
        }
    }

    static abstract class Appendeable {
        Appendeable() {
        }

        abstract void appendTo(StringBuilder var1, List<Object> var2, CodecRegistry var3);

        abstract boolean containsBindMarker();
    }
}

