/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.secretstore.api.internal;

import com.datastax.driver.core.Session;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.annotation.security.PermitAll;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.enterprise.concurrent.ManagedExecutorService;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import org.keycloak.secretstore.api.internal.MsgLogger;
import org.keycloak.secretstore.api.internal.SecretStore;
import org.keycloak.secretstore.common.internal.CassandraSessionCallable;

@Startup
@Singleton
@ApplicationScoped
@PermitAll
public class SecretStoreSchemaInitializer {
    @Inject
    CassandraSessionCallable cassandraSessionCallable;
    MsgLogger logger = MsgLogger.LOGGER;
    private Future<Session> sessionFuture;
    @Resource
    private ManagedExecutorService executor;

    @PostConstruct
    public void init() {
        if (null == this.executor) {
            try {
                FutureTask<Session> task = new FutureTask<Session>(this.cassandraSessionCallable);
                task.run();
                this.sessionFuture = task;
            }
            catch (Exception e) {
                throw new RuntimeException("Could not connect to Cassandra", e);
            }
            return;
        }
        this.sessionFuture = this.executor.submit(this.cassandraSessionCallable);
    }

    @Produces
    @ApplicationScoped
    @SecretStore
    public Session getSession() {
        try {
            Session session = this.sessionFuture.get();
            InputStream input = this.getClass().getResourceAsStream("/secret-store.cql");
            try (BufferedReader buffer = new BufferedReader(new InputStreamReader(input));){
                String content = buffer.lines().collect(Collectors.joining("\n"));
                for (String cql : content.split("(?m)^-- #.*$")) {
                    if (cql.startsWith("--")) continue;
                    session.execute(cql);
                }
            }
            catch (Exception e) {
                this.logger.failedToInitializeSchema(e);
            }
            return session;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IllegalStateException("Could not get the initialized session.");
        }
    }
}

