/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.secretstore.api.internal;

import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.ValidIdRange;

@MessageLogger(projectCode="SECSTORE")
@ValidIdRange(min=160000, max=169999)
public interface MsgLogger {
    public static final MsgLogger LOGGER = (MsgLogger)Logger.getMessageLogger(MsgLogger.class, (String)MsgLogger.class.getPackage().getName());

    @LogMessage(level=Logger.Level.FATAL)
    @Message(id=160000, value="Failed to initialize Cassandra's schema for Secret Store. Reason")
    public void failedToInitializeSchema(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=160001, value="Secret Store received a response from Keycloak that doesn't include a bearer token.")
    public void invalidResponseFromServer();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=160002, value="Secret Store a bearer response from Keycloak without the token itself!")
    public void invalidBearerTokenFromServer();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=160003, value="Secret Store received an error response from Keycloak: %s")
    public void errorResponseFromServer(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=160004, value="Token %s has expired at %s, and it's %s now.")
    public void tokenExpired(String var1, String var2, String var3);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=160005, value="Token %s not found.")
    public void tokenNotFound(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=160006, value="Couldn't retrieve bearer token for token %s.")
    public void cannotGetBearerToken(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=160007, value="Token %s doesn't look like a UUID.")
    public void notLikeUUID(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=160008, value="Token %s is not an UUID.")
    public void notAnUUID(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=160009, value="Key not present.")
    public void keyIsEmpty();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=160010, value="Request doesn't contain a basic auth header.")
    public void noBasicAuth();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=160011, value="Request doesn't contain an authorization header.")
    public void noAuthorizationHeader();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=160012, value="Authorization header is invalid: %s")
    public void authorizationHeaderInvalid(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=160013, value="Token %s replaced by bearer token %s.")
    public void tokenReplaced(String var1, String var2);
}

