/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.secretstore.api;

import java.security.SecureRandom;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.keycloak.secretstore.api.BaseEntity;

public class Token
extends BaseEntity {
    private String refreshToken;
    private String secret;
    private String principal;
    private ZonedDateTime expiresAt;
    private Map<String, String> attributes = new HashMap<String, String>();

    protected Token(String refreshToken, String principal) {
        super(UUID.randomUUID());
        this.refreshToken = refreshToken;
        this.principal = principal;
        this.generateSecret();
    }

    public Token(UUID id, String refreshToken, String principal) {
        super(id);
        this.principal = principal;
        if (null == refreshToken) {
            throw new IllegalStateException("Refresh token should be provided for a new API/Secret pair.");
        }
        this.refreshToken = refreshToken;
        this.generateSecret();
    }

    public Token(UUID id, ZonedDateTime createdAt, ZonedDateTime updatedAt, String refreshToken, String secret, Map<String, String> attributes, String principal, ZonedDateTime expiresAt) {
        super(id, createdAt, updatedAt);
        this.refreshToken = refreshToken;
        this.secret = secret;
        this.principal = principal;
        this.expiresAt = expiresAt;
        this.setAttributes(attributes);
    }

    private void generateSecret() {
        SecureRandom random = new SecureRandom();
        byte[] secretBytes = new byte[16];
        random.nextBytes(secretBytes);
        StringBuilder sb = new StringBuilder();
        for (byte b : secretBytes) {
            sb.append(String.format("%02X", b).toLowerCase());
        }
        this.secret = sb.toString();
    }

    public String getSecret() {
        return this.secret;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public Map<String, String> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    public void setAttributes(Map<String, String> attributes) {
        if (null == attributes) {
            this.attributes = new HashMap<String, String>();
            return;
        }
        this.attributes = new HashMap<String, String>(attributes);
    }

    public void addAttribute(String key, String value) {
        this.attributes.put(key, value);
    }

    public String getAttribute(String key) {
        return this.attributes.get(key);
    }

    public String getPrincipal() {
        return this.principal;
    }

    public ZonedDateTime getExpiresAt() {
        return this.expiresAt;
    }

    public void setExpiresAt(ZonedDateTime expiresAt) {
        this.expiresAt = expiresAt;
    }
}

