/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.secretstore.api;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import java.sql.Timestamp;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.security.PermitAll;
import javax.ejb.Stateless;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.keycloak.secretstore.api.Token;
import org.keycloak.secretstore.api.internal.BoundStatements;
import org.keycloak.secretstore.api.internal.NamedStatement;
import org.keycloak.secretstore.api.internal.SecretStore;
import org.keycloak.secretstore.common.ZonedDateTimeAdapter;

@Stateless
@PermitAll
public class TokenService {
    @Inject
    @SecretStore
    Session session;
    @Inject
    ZonedDateTimeAdapter zonedDateTimeAdapter;
    @Inject
    @NamedStatement(value=BoundStatements.CREATE)
    Instance<BoundStatement> stmtCreate;
    @Inject
    @NamedStatement(value=BoundStatements.GET_BY_ID)
    Instance<BoundStatement> stmtGetById;
    @Inject
    @NamedStatement(value=BoundStatements.GET_BY_PRINCIPAL)
    Instance<BoundStatement> stmtGetByPrincipal;
    @Inject
    @NamedStatement(value=BoundStatements.REVOKE_BY_ID)
    Instance<BoundStatement> stmtRevokeById;

    public Token create(Token token) {
        UUID id = token.getId();
        String refreshToken = token.getRefreshToken();
        String secret = token.getSecret();
        String principal = token.getPrincipal();
        Timestamp createdAt = this.zonedDateTimeAdapter.convertToDatabaseColumn(token.getCreatedAt());
        Timestamp updatedAt = this.zonedDateTimeAdapter.convertToDatabaseColumn(token.getUpdatedAt());
        Map<String, String> attributes = token.getAttributes();
        this.session.execute((Statement)((BoundStatement)this.stmtCreate.get()).bind(new Object[]{id, refreshToken, secret, principal, attributes, createdAt, updatedAt}));
        return token;
    }

    public void revoke(UUID id) {
        this.session.execute((Statement)((BoundStatement)this.stmtRevokeById.get()).setUUID("id", id));
    }

    public Token getByIdForTrustedConsumers(UUID id) {
        ResultSet resultSet = this.session.execute((Statement)((BoundStatement)this.stmtGetById.get()).bind(new Object[]{id}));
        List rows = resultSet.all();
        if (rows.size() > 1) {
            throw new IllegalStateException("There are more than one token for this ID!");
        }
        if (rows.size() == 0) {
            return null;
        }
        return this.getFullTokenFromRow((Row)rows.stream().findFirst().get());
    }

    public Token getByIdForDistribution(UUID id) {
        ResultSet resultSet = this.session.execute((Statement)((BoundStatement)this.stmtGetById.get()).bind(new Object[]{id}));
        List rows = resultSet.all();
        if (rows.size() > 1) {
            throw new IllegalStateException("There are more than one token for this ID!");
        }
        if (rows.size() == 0) {
            return null;
        }
        return this.getSecureTokenFromRow((Row)rows.stream().findFirst().get());
    }

    public List<Token> getByPrincipalForTrustedConsumers(String principal) {
        return this.session.execute((Statement)((BoundStatement)this.stmtGetByPrincipal.get()).bind(new Object[]{principal})).all().stream().map(this::getFullTokenFromRow).collect(Collectors.toList());
    }

    public List<Token> getByPrincipalForDistribution(String principal) {
        return this.session.execute((Statement)((BoundStatement)this.stmtGetByPrincipal.get()).bind(new Object[]{principal})).all().stream().map(this::getSecureTokenFromRow).collect(Collectors.toList());
    }

    public Token validate(UUID key, String secret) {
        Token token = this.getByIdForTrustedConsumers(key);
        if (token == null) {
            return null;
        }
        return token.getSecret().equals(secret) ? token : null;
    }

    private Token getFullTokenFromRow(Row row) {
        Token token = this.getSecureTokenFromRow(row);
        token.setRefreshToken(row.getString("refreshToken"));
        return token;
    }

    private Token getSecureTokenFromRow(Row row) {
        UUID id = row.getUUID("id");
        ZonedDateTime createdAt = this.zonedDateTimeAdapter.convertToEntityAttribute(row.getTimestamp("createdAt"));
        ZonedDateTime updatedAt = this.zonedDateTimeAdapter.convertToEntityAttribute(row.getTimestamp("updatedAt"));
        String secret = row.getString("secret");
        String principal = row.getString("principal");
        Map attributes = row.getMap("attributes", String.class, String.class);
        return new Token(id, createdAt, updatedAt, null, secret, attributes, principal);
    }
}

