/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.secretstore.api.internal;

import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.ValidIdRange;

@MessageLogger(projectCode="SECSTORE")
@ValidIdRange(min=160000, max=169999)
public interface MsgLogger {
    public static final MsgLogger LOGGER = (MsgLogger)Logger.getMessageLogger(MsgLogger.class, (String)MsgLogger.class.getPackage().getName());

    @LogMessage(level=Logger.Level.FATAL)
    @Message(id=160000, value="Failed to initialize Cassandra's schema for Secret Store. Reason")
    public void failedToInitializeSchema(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=160001, value="Secret Store received a response from Keycloak that doesn't include a bearer token.")
    public void invalidResponseFromServer();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=160002, value="Secret Store a bearer response from Keycloak without the token itself!")
    public void invalidBearerTokenFromServer();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=160003, value="Secret Store received an error response from Keycloak: %s")
    public void errorResponseFromServer(String var1);
}

