/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.secretstore.api.internal;

import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import javax.xml.bind.annotation.adapters.XmlAdapter;

public class ZonedDateTimeXmlAdapter
extends XmlAdapter<String, ZonedDateTime> {
    private final DateTimeFormatter formatter = DateTimeFormatter.ISO_DATE_TIME;

    public ZonedDateTime unmarshal(String s) {
        if (null == s || s.isEmpty()) {
            return null;
        }
        return ZonedDateTime.parse(s, this.formatter);
    }

    public String marshal(ZonedDateTime zonedDateTime) {
        if (null == zonedDateTime) {
            return null;
        }
        return zonedDateTime.withZoneSameInstant(ZoneOffset.UTC).format(this.formatter);
    }
}

