/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.secretstore.api;

import java.io.Serializable;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.UUID;

public class BaseEntity
implements Serializable {
    private final ZonedDateTime createdAt;
    private UUID id = UUID.randomUUID();
    private ZonedDateTime updatedAt = ZonedDateTime.now();

    protected BaseEntity() {
        this.updatedAt = this.createdAt = ZonedDateTime.now();
    }

    public BaseEntity(UUID id) {
        this.updatedAt = this.createdAt = ZonedDateTime.now();
        if (null != id) {
            this.id = id;
        }
    }

    public BaseEntity(UUID id, ZonedDateTime createdAt, ZonedDateTime updatedAt) {
        this.id = id;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
    }

    public UUID getId() {
        return this.id;
    }

    public ZonedDateTime getCreatedAt() {
        return this.createdAt;
    }

    public ZonedDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt() {
        this.updatedAt = ZonedDateTime.now();
    }

    public String toString() {
        return "BaseEntity{id=" + this.id + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + '}';
    }

    public int hashCode() {
        int hash = 5;
        hash = 71 * hash + Objects.hashCode(this.id);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BaseEntity other = (BaseEntity)obj;
        return Objects.equals(this.id, other.id);
    }
}

