/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.secretstore.common;

import java.net.URLEncoder;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.keycloak.secretstore.common.AuthServerRequestExecutor;
import org.keycloak.secretstore.common.AuthServerUrl;
import org.keycloak.secretstore.common.RealmName;

@ApplicationScoped
public class TokenVerifier {
    @Inject
    AuthServerRequestExecutor executor;
    @Inject
    @AuthServerUrl
    private String baseUrl;
    @Inject
    @RealmName
    private String realm;

    public String verify(String token) throws Exception {
        String tokenUrl = this.baseUrl + "/realms/" + URLEncoder.encode(this.realm, "UTF-8") + "/protocol/openid-connect/validate";
        String urlParameters = "access_token=" + URLEncoder.encode(token, "UTF-8");
        return this.executor.execute(tokenUrl, urlParameters, "GET");
    }
}

