/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.secretstore.boundary;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Base64;
import java.util.List;
import java.util.UUID;
import javax.annotation.Resource;
import javax.annotation.security.PermitAll;
import javax.ejb.SessionContext;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.hawkular.accounts.common.UsernamePasswordConverter;
import org.keycloak.KeycloakPrincipal;
import org.keycloak.adapters.RefreshableKeycloakSecurityContext;
import org.keycloak.secretstore.api.Token;
import org.keycloak.secretstore.api.TokenService;
import org.keycloak.secretstore.entity.TokenCreateResponse;
import org.keycloak.secretstore.entity.TokenErrorResponse;

@Path(value="tokens")
@Stateless
@PermitAll
public class TokenEndpoint {
    @Resource
    SessionContext sessionContext;
    @Context
    HttpServletRequest request;
    @Context
    ServletContext servletContext;
    @Inject
    TokenService tokenService;
    @Context
    UriInfo uriInfo;
    @Inject
    UsernamePasswordConverter usernamePasswordConverter;

    @GET
    @Path(value="/")
    public Response listMyTokens() {
        String principal = this.sessionContext.getCallerPrincipal().getName();
        List tokens = this.tokenService.getByPrincipalForDistribution(principal);
        return Response.ok((Object)tokens).build();
    }

    @DELETE
    @Path(value="/{tokenId}")
    public Response revoke(@PathParam(value="tokenId") String tokenId) {
        String principal = this.sessionContext.getCallerPrincipal().getName();
        Token token = this.tokenService.getByIdForTrustedConsumers(UUID.fromString(tokenId));
        if (token != null && principal.equals(token.getPrincipal())) {
            this.tokenService.revoke(UUID.fromString(tokenId));
            return Response.noContent().build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @GET
    @Path(value="create")
    public Response createFromRedirect() {
        KeycloakPrincipal principal = (KeycloakPrincipal)this.sessionContext.getCallerPrincipal();
        RefreshableKeycloakSecurityContext kcSecurityContext = (RefreshableKeycloakSecurityContext)principal.getKeycloakSecurityContext();
        String refreshToken = kcSecurityContext.getRefreshToken();
        Token token = this.create(refreshToken);
        try {
            URI location;
            String redirectTo = System.getProperty("secretstore.redirectTo");
            if (null == redirectTo || redirectTo.isEmpty()) {
                return Response.ok((Object)"Redirect URL was not specified but token was created.").build();
            }
            if (redirectTo.toLowerCase().startsWith("http")) {
                location = new URI(redirectTo);
            } else {
                URI uri = this.uriInfo.getAbsolutePath();
                String newPath = redirectTo.replace("{tokenId}", token.getId().toString());
                location = new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), newPath, uri.getQuery(), uri.getFragment());
            }
            return Response.seeOther((URI)location).build();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return Response.ok((Object)"Could not redirect back to the original URL, but token was created.").build();
        }
    }

    @POST
    @Path(value="create")
    public Response createFromBasicAuth() throws Exception {
        String userAuthorizationHeader = this.request.getHeader("Authorization");
        String[] authorizationHeaderParts = userAuthorizationHeader.trim().split("\\s+");
        if (authorizationHeaderParts.length != 2) {
            TokenErrorResponse errorResponse = new TokenErrorResponse("Invalid authorization details.");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errorResponse).build();
        }
        if (!authorizationHeaderParts[0].equalsIgnoreCase("Basic")) {
            TokenErrorResponse errorResponse = new TokenErrorResponse("Only 'Basic' authentication is supported.");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errorResponse).build();
        }
        String authorization = new String(Base64.getDecoder().decode(authorizationHeaderParts[1]));
        String[] parts = authorization.split(":");
        String username = parts[0];
        String password = parts[1];
        if (username == null || username.isEmpty()) {
            TokenErrorResponse errorResponse = new TokenErrorResponse("Username is not provided.");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errorResponse).build();
        }
        String refreshToken = this.usernamePasswordConverter.getOfflineToken(username, password);
        Token token = this.create(refreshToken);
        return Response.ok((Object)new TokenCreateResponse(token)).build();
    }

    private Token create(String refreshToken) {
        String principal = this.sessionContext.getCallerPrincipal().getName();
        Token token = new Token(null, refreshToken, principal);
        String parametersToPersist = System.getProperty("secretstore.parametersToPersist");
        if (null != parametersToPersist && !parametersToPersist.isEmpty()) {
            String[] parameters;
            for (String parameter : parameters = parametersToPersist.split(",")) {
                String parameterValue = this.request.getHeader(parameter = parameter.trim());
                if (null == parameterValue || parameterValue.isEmpty()) {
                    parameterValue = this.request.getParameter(parameter);
                }
                if (null == parameterValue || parameterValue.isEmpty()) continue;
                token.addAttribute(parameter, parameterValue);
            }
        }
        return this.tokenService.create(token);
    }
}

